/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.integration.jei;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IBookmarkOverlay;
import mezz.jei.api.runtime.IIngredientListOverlay;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.common.Internal;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.spongepowered.asm.mixin.Pseudo;

@Pseudo
public final class JeiRuntimeProxy {
    private static volatile IJeiRuntime RUNTIME;

    private JeiRuntimeProxy() {
    }

    static void setRuntime(IJeiRuntime runtime) {
        RUNTIME = runtime;
    }

    @Nullable
    public static IJeiRuntime get() {
        return RUNTIME;
    }

    public static Optional<ITypedIngredient<?>> getIngredientUnderMouse() {
        Optional ing;
        Optional ing2;
        IJeiRuntime rt = RUNTIME;
        if (rt == null) {
            return Optional.empty();
        }
        IIngredientListOverlay list = rt.getIngredientListOverlay();
        if (list != null && (ing2 = list.getIngredientUnderMouse()).isPresent()) {
            return ing2.map(i -> i);
        }
        IBookmarkOverlay bm = rt.getBookmarkOverlay();
        if (bm != null && (ing = bm.getIngredientUnderMouse()).isPresent()) {
            return ing.map(i -> i);
        }
        return Optional.empty();
    }

    public static Optional<ITypedIngredient<?>> getIngredientUnderMouse(double mouseX, double mouseY) {
        IJeiRuntime rt = RUNTIME;
        if (rt == null || rt.getRecipesGui() == null) {
            return Optional.empty();
        }
        IIngredientManager ingredientManager = rt.getIngredientManager();
        Optional<ITypedIngredient> item = rt.getRecipesGui().getIngredientUnderMouse((IIngredientType)VanillaTypes.ITEM_STACK).flatMap(v -> ingredientManager.createTypedIngredient((IIngredientType)VanillaTypes.ITEM_STACK, v)).map(x -> x);
        if (item.isPresent()) {
            return Optional.of(item.get());
        }
        return Optional.empty();
    }

    public static boolean isJeiCheatModeEnabled() {
        try {
            return Internal.getClientToggleState().isCheatItemsEnabled();
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static void setIngredientFilterText(String text) {
        IJeiRuntime rt = RUNTIME;
        if (rt == null) {
            return;
        }
        try {
            rt.getIngredientFilter().setFilterText(text == null ? "" : text);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static <T> String getTypedIngredientDisplayName(ITypedIngredient<T> typed) {
        IJeiRuntime rt = RUNTIME;
        if (rt == null || typed == null) {
            return "";
        }
        try {
            IIngredientManager manager = rt.getIngredientManager();
            IIngredientHelper helper = manager.getIngredientHelper(typed.getType());
            String display = helper.getDisplayName(typed.getIngredient());
            if (display == null) {
                return "";
            }
            if (display instanceof Component) {
                Component comp = (Component)display;
                String s = comp.getString();
                return s == null ? "" : s;
            }
            String s = display.toString();
            return s == null ? "" : s;
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    public static List<? extends ITypedIngredient<?>> getBookmarkList() {
        try {
            Class<?> bridge = Class.forName("com.extendedae_plus.integration.jei.JeiBookmarkBridge");
            Method m = bridge.getMethod("getBookmarkList", new Class[0]);
            List list = (List)m.invoke(null, new Object[0]);
            return list == null ? Collections.emptyList() : list;
        }
        catch (Throwable ignored) {
            return Collections.emptyList();
        }
    }

    public static void addBookmark(ItemStack stack) {
        try {
            Class<?> bridge = Class.forName("com.extendedae_plus.integration.jei.JeiBookmarkBridge");
            Method m = bridge.getMethod("addBookmark", ItemStack.class);
            m.invoke(null, stack);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void addBookmark(FluidStack fluidStack) {
        try {
            Class<?> bridge = Class.forName("com.extendedae_plus.integration.jei.JeiBookmarkBridge");
            Method m = bridge.getMethod("addBookmark", FluidStack.class);
            m.invoke(null, fluidStack);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void addBookmark(Object chemicalStack) {
        try {
            Class<?> bridge = Class.forName("com.extendedae_plus.integration.jei.JeiBookmarkBridge");
            Method m = bridge.getMethod("addBookmark", Object.class);
            m.invoke(null, chemicalStack);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void removeBookmark(ItemStack stack) {
        try {
            Class<?> bridge = Class.forName("com.extendedae_plus.integration.jei.JeiBookmarkBridge");
            Method m = bridge.getMethod("removeBookmark", ItemStack.class);
            m.invoke(null, stack);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

