/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.network;

import com.extendedae_plus.ae.items.ChannelCardItem;
import com.extendedae_plus.init.ModItems;
import com.extendedae_plus.util.WirelessTeamUtil;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ChannelCardBindPacket {
    private final InteractionHand hand;

    public ChannelCardBindPacket(InteractionHand hand) {
        this.hand = hand;
    }

    public static void encode(ChannelCardBindPacket packet, FriendlyByteBuf buf) {
        buf.m_130068_((Enum)packet.hand);
    }

    public static ChannelCardBindPacket decode(FriendlyByteBuf buf) {
        return new ChannelCardBindPacket((InteractionHand)buf.m_130066_(InteractionHand.class));
    }

    public static void handle(ChannelCardBindPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            ItemStack stack = player.m_21120_(packet.hand);
            if (stack.m_41720_() != ModItems.CHANNEL_CARD.get()) {
                return;
            }
            ServerLevel level = player.m_284548_();
            UUID currentOwner = ChannelCardItem.getOwnerUUID(stack);
            if (currentOwner != null) {
                ChannelCardItem.clearOwner(stack);
                player.m_5661_((Component)Component.m_237115_((String)"item.extendedae_plus.channel_card.owner.cleared"), true);
            } else {
                UUID playerUUID = player.m_20148_();
                ChannelCardItem.setOwnerUUID(stack, playerUUID);
                Component teamName = WirelessTeamUtil.getNetworkOwnerName(level, playerUUID);
                ChannelCardItem.setTeamName(stack, teamName.getString());
                player.m_5661_((Component)Component.m_237110_((String)"item.extendedae_plus.channel_card.owner.bound", (Object[])new Object[]{teamName}), true);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

