/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.network;

import com.extendedae_plus.content.wireless.WirelessTransceiverBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class SetWirelessFrequencyC2SPacket {
    private final BlockPos pos;
    private final long frequency;

    public SetWirelessFrequencyC2SPacket(BlockPos pos, long frequency) {
        this.pos = pos;
        this.frequency = frequency;
    }

    public static void encode(SetWirelessFrequencyC2SPacket packet, FriendlyByteBuf buf) {
        buf.m_130064_(packet.pos);
        buf.writeLong(packet.frequency);
    }

    public static SetWirelessFrequencyC2SPacket decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        long frequency = buf.readLong();
        return new SetWirelessFrequencyC2SPacket(pos, frequency);
    }

    public static void handle(SetWirelessFrequencyC2SPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            long newFreq;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            ServerLevel level = player.m_284548_();
            if (!level.m_46805_(packet.pos)) {
                return;
            }
            BlockEntity blockEntity = level.m_7702_(packet.pos);
            if (!(blockEntity instanceof WirelessTransceiverBlockEntity)) {
                return;
            }
            WirelessTransceiverBlockEntity te = (WirelessTransceiverBlockEntity)blockEntity;
            boolean wasLocked = te.isLocked();
            if (wasLocked) {
                te.setLocked(false);
            }
            if ((newFreq = packet.frequency) < 0L) {
                newFreq = 0L;
            }
            te.setFrequency(newFreq);
            if (wasLocked) {
                te.setLocked(true);
            }
            player.m_5661_((Component)Component.m_237113_((String)("\u9891\u9053\u5df2\u8bbe\u7f6e\u4e3a\uff1a" + te.getFrequency())), true);
        });
        ctx.get().setPacketHandled(true);
    }
}

