/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.network.crafting;

import appeng.api.crafting.IPatternDetails;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingService;
import appeng.api.networking.security.IActionHost;
import appeng.api.stacks.AEKey;
import appeng.helpers.patternprovider.PatternProviderLogic;
import appeng.helpers.patternprovider.PatternProviderLogicHost;
import appeng.me.service.CraftingService;
import appeng.menu.locator.MenuLocators;
import appeng.menu.me.crafting.CraftingCPUMenu;
import appeng.parts.AEBasePart;
import com.extendedae_plus.init.ModNetwork;
import com.extendedae_plus.mixin.ae2.accessor.PatternProviderLogicAccessor;
import com.extendedae_plus.network.SetPatternHighlightS2CPacket;
import com.extendedae_plus.network.provider.SetProviderPageS2CPacket;
import com.extendedae_plus.util.PatternProviderDataUtil;
import com.glodblock.github.extendedae.client.render.EAEHighlightHandler;
import com.glodblock.github.extendedae.util.FCClientUtil;
import com.glodblock.github.glodium.util.GlodUtil;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class CraftingMonitorOpenProviderC2SPacket {
    private final AEKey what;

    public CraftingMonitorOpenProviderC2SPacket(AEKey what) {
        this.what = what;
    }

    public static void encode(CraftingMonitorOpenProviderC2SPacket msg, FriendlyByteBuf buf) {
        AEKey.writeKey((FriendlyByteBuf)buf, (AEKey)msg.what);
    }

    public static CraftingMonitorOpenProviderC2SPacket decode(FriendlyByteBuf buf) {
        AEKey key = AEKey.readKey((FriendlyByteBuf)buf);
        return new CraftingMonitorOpenProviderC2SPacket(key);
    }

    public static void handle(CraftingMonitorOpenProviderC2SPacket msg, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            IActionHost host;
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            AbstractContainerMenu patt0$temp = player.f_36096_;
            if (!(patt0$temp instanceof CraftingCPUMenu)) {
                return;
            }
            CraftingCPUMenu menu = (CraftingCPUMenu)patt0$temp;
            IGrid grid = null;
            Object target = menu.getTarget();
            if (target instanceof IActionHost && (host = (IActionHost)target).getActionableNode() != null) {
                grid = host.getActionableNode().getGrid();
            }
            if (grid == null) {
                return;
            }
            ICraftingService cs = grid.getCraftingService();
            if (!(cs instanceof CraftingService)) {
                return;
            }
            CraftingService craftingService = (CraftingService)cs;
            Collection patterns = craftingService.getCraftingFor(msg.what);
            if (patterns.isEmpty()) {
                return;
            }
            for (IPatternDetails pattern : patterns) {
                Iterable providers = craftingService.getProviders(pattern);
                for (ICraftingProvider provider : providers) {
                    BlockEntity pbe;
                    PatternProviderLogic ppl;
                    PatternProviderLogicHost host2;
                    if (!(provider instanceof PatternProviderLogic) || (host2 = ((PatternProviderLogicAccessor)(ppl = (PatternProviderLogic)provider)).eap$host()) == null || (pbe = host2.getBlockEntity()) == null || !PatternProviderDataUtil.isProviderAvailable(ppl, grid)) continue;
                    try {
                        int pageId;
                        if (host2 instanceof AEBasePart) {
                            AEBasePart part = (AEBasePart)host2;
                            host2.openMenu((Player)player, MenuLocators.forPart((AEBasePart)part));
                            CraftingMonitorOpenProviderC2SPacket.highlightWithMessage(pbe.m_58899_(), part.getSide(), (ResourceKey<Level>)Objects.requireNonNull(pbe.m_58904_()).m_46472_(), 1.0, (Player)player);
                        } else {
                            host2.openMenu((Player)player, MenuLocators.forBlockEntity((BlockEntity)pbe));
                            CraftingMonitorOpenProviderC2SPacket.highlightWithMessage(pbe.m_58899_(), null, (ResourceKey<Level>)Objects.requireNonNull(pbe.m_58904_()).m_46472_(), 1.0, (Player)player);
                        }
                        int foundSlot = PatternProviderDataUtil.findSlotForPattern(ppl, pattern.getDefinition());
                        if (foundSlot >= 0 && (pageId = foundSlot / 36) > 0) {
                            ModNetwork.CHANNEL.sendTo((Object)new SetProviderPageS2CPacket(pageId), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                        }
                        if (pattern.getOutputs() != null && pattern.getOutputs().length > 0 && pattern.getOutputs()[0] != null) {
                            AEKey key = pattern.getOutputs()[0].what();
                            ModNetwork.CHANNEL.sendTo((Object)new SetPatternHighlightS2CPacket(key, true), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                        }
                        return;
                    }
                    catch (Exception exception) {
                    }
                }
            }
        });
        context.setPacketHandled(true);
    }

    private static void highlightWithMessage(BlockPos pos, Direction face, ResourceKey<Level> dim, double multiplier, Player player) {
        if (pos == null || dim == null) {
            return;
        }
        long endTime = System.currentTimeMillis() + (long)(6000.0 * GlodUtil.clamp((double)multiplier, (double)1.0, (double)30.0));
        if (face == null) {
            EAEHighlightHandler.highlight((BlockPos)pos, dim, (long)endTime);
        } else {
            AABB origin = new AABB(0.125, 0.125, 0.0, 0.875, 0.875, 0.125).m_82338_(pos);
            Vec3 center = new AABB(pos).m_82399_();
            switch (face) {
                case WEST: {
                    origin = FCClientUtil.rotor((AABB)origin, (Vec3)center, (Direction.Axis)Direction.Axis.Y, (float)1.5707964f);
                    break;
                }
                case SOUTH: {
                    origin = FCClientUtil.rotor((AABB)origin, (Vec3)center, (Direction.Axis)Direction.Axis.Y, (float)((float)Math.PI));
                    break;
                }
                case EAST: {
                    origin = FCClientUtil.rotor((AABB)origin, (Vec3)center, (Direction.Axis)Direction.Axis.Y, (float)-1.5707964f);
                    break;
                }
                case UP: {
                    origin = FCClientUtil.rotor((AABB)origin, (Vec3)center, (Direction.Axis)Direction.Axis.X, (float)-1.5707964f);
                    break;
                }
                case DOWN: {
                    origin = FCClientUtil.rotor((AABB)origin, (Vec3)center, (Direction.Axis)Direction.Axis.X, (float)1.5707964f);
                }
            }
            EAEHighlightHandler.highlight((BlockPos)pos, (Direction)face, dim, (long)endTime, (AABB)origin);
        }
        if (player != null) {
            player.m_5661_((Component)Component.m_237110_((String)"chat.ex_pattern_access_terminal.pos", (Object[])new Object[]{pos.m_123344_(), dim.m_135782_().m_135815_()}), false);
        }
    }
}

