/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.util;

import java.lang.reflect.Method;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.Nullable;

public class WirelessTeamUtil {
    private static final boolean FTB_TEAMS_LOADED = ModList.get().isLoaded("ftbteams");

    public static UUID getNetworkOwnerUUID(@Nullable ServerLevel level, UUID playerUUID) {
        if (playerUUID == null) {
            return null;
        }
        if (!FTB_TEAMS_LOADED) {
            return playerUUID;
        }
        if (level == null) {
            return playerUUID;
        }
        try {
            return WirelessTeamUtil.getTeamUUID(level, playerUUID);
        }
        catch (Exception e) {
            return playerUUID;
        }
    }

    public static Component getNetworkOwnerName(@Nullable ServerLevel level, UUID playerUUID) {
        ServerPlayer player;
        if (FTB_TEAMS_LOADED && level != null) {
            try {
                return WirelessTeamUtil.getTeamName(level, playerUUID);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (level != null && (player = level.m_7654_().m_6846_().m_11259_(playerUUID)) != null) {
            return player.m_7755_();
        }
        return Component.m_237113_((String)playerUUID.toString());
    }

    public static boolean hasNetworkOwner(@Nullable ServerLevel level, UUID playerUUID) {
        if (FTB_TEAMS_LOADED && level != null) {
            try {
                return WirelessTeamUtil.hasTeamOwner(level, playerUUID);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (level != null) {
            return level.m_7654_().m_6846_().m_11259_(playerUUID) != null;
        }
        return false;
    }

    private static UUID getTeamUUID(ServerLevel level, UUID playerUUID) {
        try {
            Class<?> optionalClass;
            boolean isPresent;
            Class<?> apiClass = Class.forName("dev.ftb.mods.ftbteams.api.FTBTeamsAPI");
            Object api = apiClass.getMethod("api", new Class[0]).invoke(null, new Object[0]);
            Boolean isLoaded = (Boolean)api.getClass().getMethod("isManagerLoaded", new Class[0]).invoke(api, new Object[0]);
            if (!isLoaded.booleanValue()) {
                return playerUUID;
            }
            Object getManager = api.getClass().getMethod("getManager", new Class[0]).invoke(api, new Object[0]);
            if (getManager == null) {
                return playerUUID;
            }
            Class<?> managerClass = getManager.getClass();
            Method getTeamForPlayer = managerClass.getMethod("getTeamForPlayerID", UUID.class);
            Object teamOptional = getTeamForPlayer.invoke(getManager, playerUUID);
            if (teamOptional != null && (isPresent = ((Boolean)(optionalClass = teamOptional.getClass()).getMethod("isPresent", new Class[0]).invoke(teamOptional, new Object[0])).booleanValue())) {
                Object team = optionalClass.getMethod("get", new Class[0]).invoke(teamOptional, new Object[0]);
                Class<?> teamClass = team.getClass();
                return (UUID)teamClass.getMethod("getTeamId", new Class[0]).invoke(team, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return playerUUID;
    }

    private static Component getTeamName(ServerLevel level, UUID playerUUID) {
        try {
            Class<?> optionalClass;
            boolean isPresent;
            Class<?> apiClass = Class.forName("dev.ftb.mods.ftbteams.api.FTBTeamsAPI");
            Object api = apiClass.getMethod("api", new Class[0]).invoke(null, new Object[0]);
            Boolean isLoaded = (Boolean)api.getClass().getMethod("isManagerLoaded", new Class[0]).invoke(api, new Object[0]);
            if (!isLoaded.booleanValue()) {
                ServerPlayer player = level.m_7654_().m_6846_().m_11259_(playerUUID);
                if (player != null) {
                    return player.m_7755_();
                }
                return Component.m_237113_((String)playerUUID.toString());
            }
            Object getManager = api.getClass().getMethod("getManager", new Class[0]).invoke(api, new Object[0]);
            if (getManager == null) {
                return Component.m_237113_((String)playerUUID.toString());
            }
            Class<?> managerClass = getManager.getClass();
            Method getTeamForPlayer = managerClass.getMethod("getTeamForPlayerID", UUID.class);
            Object teamOptional = getTeamForPlayer.invoke(getManager, playerUUID);
            if (teamOptional != null && (isPresent = ((Boolean)(optionalClass = teamOptional.getClass()).getMethod("isPresent", new Class[0]).invoke(teamOptional, new Object[0])).booleanValue())) {
                Object team = optionalClass.getMethod("get", new Class[0]).invoke(teamOptional, new Object[0]);
                Class<?> teamClass = team.getClass();
                return (Component)teamClass.getMethod("getName", new Class[0]).invoke(team, new Object[0]);
            }
        }
        catch (Exception apiClass) {
            // empty catch block
        }
        ServerPlayer player = level.m_7654_().m_6846_().m_11259_(playerUUID);
        if (player != null) {
            return player.m_7755_();
        }
        return Component.m_237113_((String)playerUUID.toString());
    }

    private static boolean hasTeamOwner(ServerLevel level, UUID playerUUID) {
        try {
            Class<?> apiClass = Class.forName("dev.ftb.mods.ftbteams.api.FTBTeamsAPI");
            Object api = apiClass.getMethod("api", new Class[0]).invoke(null, new Object[0]);
            Boolean isLoaded = (Boolean)api.getClass().getMethod("isManagerLoaded", new Class[0]).invoke(api, new Object[0]);
            if (!isLoaded.booleanValue()) {
                return level.m_7654_().m_6846_().m_11259_(playerUUID) != null;
            }
            Object getManager = api.getClass().getMethod("getManager", new Class[0]).invoke(api, new Object[0]);
            if (getManager == null) {
                return level.m_7654_().m_6846_().m_11259_(playerUUID) != null;
            }
            Class<?> managerClass = getManager.getClass();
            Method getTeamForPlayer = managerClass.getMethod("getTeamForPlayerID", UUID.class);
            Object teamOptional = getTeamForPlayer.invoke(getManager, playerUUID);
            if (teamOptional != null) {
                Class<?> optionalClass = teamOptional.getClass();
                return (Boolean)optionalClass.getMethod("isPresent", new Class[0]).invoke(teamOptional, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return level.m_7654_().m_6846_().m_11259_(playerUUID) != null;
    }
}

