/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.util.command;

import com.extendedae_plus.ExtendedAEPlus;
import com.extendedae_plus.ae.items.InfinityBigIntegerCellItem;
import com.extendedae_plus.util.storage.InfinityStorageManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class InfinityDiskGiveCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"eap").then(Commands.m_82127_((String)"give_infinity_disks").executes(InfinityDiskGiveCommand::execute)));
    }

    private static int execute(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        try {
            ServerPlayer player = source.m_81375_();
            if (player.m_9236_() == null || !(player.m_9236_() instanceof ServerLevel)) {
                source.m_81352_((Component)Component.m_237113_((String)"This command must be run on server side."));
                return 0;
            }
            InfinityStorageManager mgr = ExtendedAEPlus.STORAGE_INSTANCE;
            if (mgr == null) {
                source.m_81352_((Component)Component.m_237113_((String)"InfinityStorageManager is not initialized."));
                return 0;
            }
            int given = 0;
            for (UUID id : mgr.getAllLoadedUUIDs()) {
                ItemStack stack = InfinityBigIntegerCellItem.withUUID(id);
                if (!player.m_150109_().m_36054_(stack)) {
                    player.m_36176_(stack, false);
                }
                ++given;
            }
            int finalGiven = given;
            source.m_288197_(() -> Component.m_237113_((String)("Gave " + finalGiven + " infinity disks.")), false);
            return given;
        }
        catch (Exception ex) {
            source.m_81352_((Component)Component.m_237113_((String)("Error: " + ex.getMessage())));
            return 0;
        }
    }
}

