/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.util.entitySpeed;

import appeng.api.upgrades.IUpgradeInventory;
import com.extendedae_plus.ae.definitions.upgrades.EntitySpeedCardItem;
import com.extendedae_plus.config.ModConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.ItemStack;

public final class PowerUtils {
    private static final int[] VALID_MULTIPLIERS = new int[]{2, 4, 8, 16, 32, 64, 128, 256, 512, 1024};
    private static final int[] VALID_ENERGY_CARD_COUNTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private static volatile Map<Integer, Map<Integer, Double>> powerCache = new HashMap<Integer, Map<Integer, Double>>();
    private static volatile Map<Integer, Double> ratioCache = new HashMap<Integer, Double>();

    private PowerUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeCaches() {
        Class<PowerUtils> clazz = PowerUtils.class;
        synchronized (PowerUtils.class) {
            powerCache.clear();
            ratioCache.clear();
            for (int energyCardCount : VALID_ENERGY_CARD_COUNTS) {
                double ratio = energyCardCount == 0 ? 1.0 : (energyCardCount == 1 ? 0.9 : (energyCardCount == 8 ? 0.5 : 1.0 - 0.5 * (1.0 - Math.pow(0.7, energyCardCount))));
                ratioCache.put(energyCardCount, ratio);
            }
            for (int product : VALID_MULTIPLIERS) {
                HashMap<Integer, Double> energyCardMap = new HashMap<Integer, Double>();
                for (int energyCardCount : VALID_ENERGY_CARD_COUNTS) {
                    double power = PowerUtils.computePowerForProduct(product, energyCardCount);
                    energyCardMap.put(energyCardCount, power);
                }
                powerCache.put(product, energyCardMap);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static double computePowerForProduct(int product, int energyCardCount) {
        double base = ModConfig.INSTANCE.entityTickerCost;
        int log2 = Integer.numberOfTrailingZeros(product);
        double raw = product == 2 ? base * 4.0 : (product <= 256 ? base * (double)(1L << (int)(1.5 * (double)log2)) * 2.0 : base * (double)(1L << (int)(2.5 * (double)log2)));
        double ratio = energyCardCount <= 0 ? 1.0 : (energyCardCount == 1 ? 0.9 : (energyCardCount >= 8 ? 0.5 : 1.0 - 0.5 * (1.0 - Math.pow(0.7, energyCardCount))));
        return raw * ratio / 8.0;
    }

    public static int computeProductWithCap(IUpgradeInventory upgrades, int maxCards) {
        ArrayList<Integer> multipliers = new ArrayList<Integer>();
        int considered = 0;
        for (ItemStack stack : upgrades) {
            if (considered >= maxCards) break;
            if (stack == null || stack.m_41619_() || !(stack.m_41720_() instanceof EntitySpeedCardItem)) continue;
            int multVal = EntitySpeedCardItem.readMultiplier(stack);
            int count = Math.min(stack.m_41613_(), maxCards - considered);
            for (int i = 0; i < count; ++i) {
                multipliers.add(multVal);
                ++considered;
            }
        }
        int product = 1;
        int highest = 1;
        for (Integer m : multipliers) {
            if (m == null || m <= 0) continue;
            product *= m.intValue();
            highest = Math.max(highest, m);
        }
        return Math.min(product, PowerUtils.capForHighestMultiplier(highest));
    }

    public static int capForHighestMultiplier(int highestMultiplier) {
        if (highestMultiplier >= 16) {
            return 1024;
        }
        if (highestMultiplier >= 8) {
            return 256;
        }
        if (highestMultiplier >= 4) {
            return 64;
        }
        if (highestMultiplier >= 2) {
            return 8;
        }
        return 1;
    }

    public static double getCachedPower(int product, int energyCardCount) {
        if (product <= 1) {
            return 0.0;
        }
        Map<Integer, Double> energyCardMap = powerCache.get(product);
        if (energyCardMap == null) {
            return 0.0;
        }
        Double cachedPower = energyCardMap.get(energyCardCount);
        if (cachedPower == null) {
            return 0.0;
        }
        return cachedPower;
    }

    public static double getCachedRatio(int energyCardCount) {
        Double cachedRatio = ratioCache.get(energyCardCount);
        if (cachedRatio == null) {
            return 1.0;
        }
        return cachedRatio;
    }

    public static String formatPercentage(double ratio) {
        double pct = ratio * 100.0;
        return Math.abs(pct - (double)Math.round(pct)) < 1.0E-9 ? String.format("%d%%", Math.round(pct)) : String.format("%.2f%%", pct);
    }

    static {
        PowerUtils.initializeCaches();
    }
}

