/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.client;

import com.extendedae_plus.config.ModConfigs;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ModConfigScreen
extends Screen {
    private final Screen parent;
    private EditBox pageMultiplierBox;
    private EditBox wirelessMaxRangeBox;
    private CycleButton<Boolean> crossDimToggle;
    private CycleButton<Boolean> providerRoundRobinToggle;
    private EditBox smartScalingMaxMulBox;
    private EditBox smartScalingMinBenefitBox;
    private CycleButton<Boolean> showEncoderToggle;
    private CycleButton<Boolean> patternTerminalShowSlotsToggle;

    public ModConfigScreen(Screen parent) {
        super((Component)Component.m_237115_((String)"screen.extendedae_plus.title"));
        this.parent = parent;
    }

    protected void m_7856_() {
        int centerX = this.f_96543_ / 2;
        int y = this.f_96544_ / 6 + 24;
        int row = 0;
        int rowHeight = 26;
        int boxWidth = 150;
        int leftX = centerX - 170;
        int rightX = centerX + 20;
        this.pageMultiplierBox = new EditBox(this.f_96547_, rightX, y + row * rowHeight, boxWidth, 20, (Component)Component.m_237115_((String)"config.extendedae_plus.pageMultiplier"));
        this.pageMultiplierBox.m_94144_(String.valueOf(ModConfigs.PAGE_MULTIPLIER.get()));
        this.pageMultiplierBox.m_94153_(s -> s.matches("\\d*") && ModConfigScreen.parseIntOrDefault(s, 1) >= 1 && ModConfigScreen.parseIntOrDefault(s, 64) <= 64);
        this.m_142416_((GuiEventListener)this.pageMultiplierBox);
        this.wirelessMaxRangeBox = new EditBox(this.f_96547_, rightX, y + ++row * rowHeight, boxWidth, 20, (Component)Component.m_237115_((String)"config.extendedae_plus.wirelessMaxRange"));
        this.wirelessMaxRangeBox.m_94144_(String.valueOf(ModConfigs.WIRELESS_MAX_RANGE.get()));
        this.wirelessMaxRangeBox.m_94153_(s -> s.isEmpty() || s.matches("\\d*(\\.\\d*)?"));
        this.m_142416_((GuiEventListener)this.wirelessMaxRangeBox);
        this.crossDimToggle = (CycleButton)this.m_142416_((GuiEventListener)this.createToggle(rightX, y + ++row * rowHeight, boxWidth, 20, (Boolean)ModConfigs.WIRELESS_CROSS_DIM_ENABLE.get()));
        this.providerRoundRobinToggle = (CycleButton)this.m_142416_((GuiEventListener)this.createToggle(rightX, y + ++row * rowHeight, boxWidth, 20, (Boolean)ModConfigs.PROVIDER_ROUND_ROBIN_ENABLE.get()));
        this.smartScalingMaxMulBox = new EditBox(this.f_96547_, rightX, y + ++row * rowHeight, boxWidth, 20, (Component)Component.m_237115_((String)"config.extendedae_plus.smartScalingMaxMultiplier"));
        this.smartScalingMaxMulBox.m_94144_(String.valueOf(ModConfigs.SMART_SCALING_MAX_MULTIPLIER.get()));
        this.smartScalingMaxMulBox.m_94153_(s -> s.matches("\\d*") && ModConfigScreen.parseIntOrDefault(s, 0) >= 0 && ModConfigScreen.parseIntOrDefault(s, 0x100000) <= 0x100000);
        this.m_142416_((GuiEventListener)this.smartScalingMaxMulBox);
        this.smartScalingMinBenefitBox = new EditBox(this.f_96547_, rightX, y + ++row * rowHeight, boxWidth, 20, (Component)Component.m_237115_((String)"config.extendedae_plus.smartScalingMinBenefitFactor"));
        this.smartScalingMinBenefitBox.m_94144_(String.valueOf(ModConfigs.SMART_SCALING_MIN_BENEFIT_FACTOR.get()));
        this.smartScalingMinBenefitBox.m_94153_(s -> s.matches("\\d*") && ModConfigScreen.parseIntOrDefault(s, 1) >= 1 && ModConfigScreen.parseIntOrDefault(s, 1024) <= 1024);
        this.m_142416_((GuiEventListener)this.smartScalingMinBenefitBox);
        this.showEncoderToggle = (CycleButton)this.m_142416_((GuiEventListener)this.createToggle(rightX, y + ++row * rowHeight, boxWidth, 20, (Boolean)ModConfigs.SHOW_ENCOD_PATTERN_PLAYER.get()));
        this.patternTerminalShowSlotsToggle = (CycleButton)this.m_142416_((GuiEventListener)this.createToggle(rightX, y + ++row * rowHeight, boxWidth, 20, (Boolean)ModConfigs.PATTERN_TERMINAL_SHOW_SLOTS_DEFAULT.get()));
        int btnW = 100;
        int gap = 8;
        int buttonsY = y + ++row * rowHeight + 18;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.done"), b -> this.saveAndClose()).m_252794_(centerX - btnW - gap / 2, buttonsY).m_253046_(btnW, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.cancel"), b -> this.m_7379_()).m_252794_(centerX + gap / 2, buttonsY).m_253046_(btnW, 20).m_253136_());
    }

    private void saveAndClose() {
        int pageMul = ModConfigScreen.clamp(ModConfigScreen.parseIntOrDefault(this.pageMultiplierBox.m_94155_(), (Integer)ModConfigs.PAGE_MULTIPLIER.get()), 1, 64);
        double maxRange = ModConfigScreen.clamp(ModConfigScreen.parseDoubleOrDefault(this.wirelessMaxRangeBox.m_94155_(), (Double)ModConfigs.WIRELESS_MAX_RANGE.get()), 1.0, 4096.0);
        boolean crossDim = (Boolean)this.crossDimToggle.m_168883_();
        boolean providerRoundRobin = (Boolean)this.providerRoundRobinToggle.m_168883_();
        int smartMaxMul = ModConfigScreen.clamp(ModConfigScreen.parseIntOrDefault(this.smartScalingMaxMulBox.m_94155_(), (Integer)ModConfigs.SMART_SCALING_MAX_MULTIPLIER.get()), 0, 0x100000);
        int smartMinBenefit = ModConfigScreen.clamp(ModConfigScreen.parseIntOrDefault(this.smartScalingMinBenefitBox.m_94155_(), (Integer)ModConfigs.SMART_SCALING_MIN_BENEFIT_FACTOR.get()), 1, 1024);
        boolean showEncoder = (Boolean)this.showEncoderToggle.m_168883_();
        boolean patternShowSlots = (Boolean)this.patternTerminalShowSlotsToggle.m_168883_();
        ModConfigs.PAGE_MULTIPLIER.set((Object)pageMul);
        ModConfigs.WIRELESS_MAX_RANGE.set((Object)maxRange);
        ModConfigs.WIRELESS_CROSS_DIM_ENABLE.set((Object)crossDim);
        ModConfigs.PROVIDER_ROUND_ROBIN_ENABLE.set((Object)providerRoundRobin);
        ModConfigs.SMART_SCALING_MAX_MULTIPLIER.set((Object)smartMaxMul);
        ModConfigs.SMART_SCALING_MIN_BENEFIT_FACTOR.set((Object)smartMinBenefit);
        ModConfigs.SHOW_ENCOD_PATTERN_PLAYER.set((Object)showEncoder);
        ModConfigs.PATTERN_TERMINAL_SHOW_SLOTS_DEFAULT.set((Object)patternShowSlots);
        this.m_7379_();
    }

    private CycleButton<Boolean> createToggle(int x, int y, int width, int height, boolean initial) {
        CycleButton btn = CycleButton.m_168916_((boolean)initial).m_168936_(x, y, width, height, (Component)Component.m_237119_(), (b, v) -> b.m_93666_((Component)Component.m_237115_((String)(v != false ? "config.extendedae_plus.state_on" : "config.extendedae_plus.state_off"))));
        btn.m_93666_((Component)Component.m_237115_((String)(initial ? "config.extendedae_plus.state_on" : "config.extendedae_plus.state_off")));
        return btn;
    }

    public void m_7379_() {
        Minecraft.m_91087_().m_91152_(this.parent);
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(g);
        super.m_88315_(g, mouseX, mouseY, partialTick);
        int centerX = this.f_96543_ / 2;
        int y = this.f_96544_ / 6 + 24;
        int rowHeight = 26;
        int labelColor = 0xFFFFFF;
        int leftX = centerX - 170;
        g.m_280653_(this.f_96547_, this.f_96539_, centerX, y - 28, 0xFFFFFF);
        g.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"config.extendedae_plus.pageMultiplier_with_range"), leftX, y + 0 * rowHeight + 6, labelColor, false);
        g.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"config.extendedae_plus.wirelessMaxRange_with_range"), leftX, y + 1 * rowHeight + 6, labelColor, false);
        g.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"config.extendedae_plus.wirelessCrossDimEnable"), leftX, y + 2 * rowHeight + 6, labelColor, false);
        g.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"config.extendedae_plus.providerRoundRobinEnable"), leftX, y + 3 * rowHeight + 6, labelColor, false);
        g.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"config.extendedae_plus.smartScalingMaxMultiplier_with_range"), leftX, y + 4 * rowHeight + 6, labelColor, false);
        g.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"config.extendedae_plus.smartScalingMinBenefitFactor"), leftX, y + 5 * rowHeight + 6, labelColor, false);
        g.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"config.extendedae_plus.showEncoderPatternPlayer"), leftX, y + 6 * rowHeight + 6, labelColor, false);
        g.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"config.extendedae_plus.patternTerminalShowSlotsDefault"), leftX, y + 7 * rowHeight + 6, labelColor, false);
    }

    private static int parseIntOrDefault(String s, int def) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return def;
        }
    }

    private static double parseDoubleOrDefault(String s, double def) {
        try {
            return Double.parseDouble(s);
        }
        catch (Exception e) {
            return def;
        }
    }

    private static int clamp(int v, int min, int max) {
        return Math.max(min, Math.min(max, v));
    }

    private static double clamp(double v, double min, double max) {
        return Math.max(min, Math.min(max, v));
    }
}

