/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.client.ui;

import com.extendedae_plus.network.ModNetwork;
import com.extendedae_plus.network.UploadEncodedPatternToProviderC2SPacket;
import com.extendedae_plus.util.ExtendedAEPatternUploadUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;

public class ProviderSelectScreen
extends Screen {
    private final Screen parent;
    private final List<Long> ids;
    private final List<String> names;
    private final List<Integer> emptySlots;
    private final List<Long> gIds = new ArrayList<Long>();
    private final List<String> gNames = new ArrayList<String>();
    private final List<Integer> gTotalSlots = new ArrayList<Integer>();
    private final List<Integer> gCount = new ArrayList<Integer>();
    private final List<Long> fIds = new ArrayList<Long>();
    private final List<String> fNames = new ArrayList<String>();
    private final List<Integer> fTotalSlots = new ArrayList<Integer>();
    private final List<Integer> fCount = new ArrayList<Integer>();
    private EditBox searchBox;
    private EditBox cnInput;
    private String query = "";
    private boolean needsRefresh = false;
    private int page = 0;
    private static final int PAGE_SIZE = 6;
    private final List<Button> entryButtons = new ArrayList<Button>();
    private static Boolean JEC_AVAILABLE = null;
    private static Method JEC_CONTAINS = null;

    public ProviderSelectScreen(Screen parent, List<Long> ids, List<String> names, List<Integer> emptySlots) {
        super((Component)Component.m_237115_((String)"extendedae_plus.screen.choose_provider.title"));
        this.parent = parent;
        this.ids = ids;
        this.names = names;
        this.emptySlots = emptySlots;
        try {
            String recent = ExtendedAEPatternUploadUtil.lastProcessingName;
            if (recent != null && !recent.isBlank()) {
                this.query = recent;
                ExtendedAEPatternUploadUtil.lastProcessingName = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.buildGroups();
        this.applyFilter();
    }

    protected void m_7856_() {
        this.m_169413_();
        this.entryButtons.clear();
        int centerX = this.f_96543_ / 2;
        int startY = this.f_96544_ / 2 - 70;
        if (this.searchBox == null) {
            this.searchBox = new EditBox(this.f_96547_, centerX - 120, startY - 25, 240, 18, (Component)Component.m_237115_((String)"extendedae_plus.screen.search"));
        } else {
            this.searchBox.m_252865_(centerX - 120);
            this.searchBox.m_253211_(startY - 25);
            this.searchBox.m_93674_(240);
        }
        this.searchBox.m_94144_(this.query);
        this.searchBox.m_94151_(text -> {
            if (Objects.equals(text, this.query)) {
                return;
            }
            this.query = text;
            this.page = 0;
            this.applyFilter();
            this.needsRefresh = true;
        });
        this.m_142416_((GuiEventListener)this.searchBox);
        int start = this.page * 6;
        int end = Math.min(start + 6, this.fIds.size());
        int buttonWidth = 240;
        int buttonHeight = 20;
        int gap = 5;
        for (int i = start; i < end; ++i) {
            int idx = i;
            String label = this.buildLabel(idx);
            Button btn = Button.m_253074_((Component)Component.m_237113_((String)label), b -> this.onChoose(idx)).m_252987_(centerX - buttonWidth / 2, startY + (i - start) * (buttonHeight + gap), buttonWidth, buttonHeight).m_253136_();
            this.entryButtons.add(btn);
            this.m_142416_((GuiEventListener)btn);
        }
        int navY = startY + 6 * (buttonHeight + gap) + 10;
        Button prev = Button.m_253074_((Component)Component.m_237113_((String)"<"), b -> this.changePage(-1)).m_252987_(centerX - 60, navY, 20, 20).m_253136_();
        Button next = Button.m_253074_((Component)Component.m_237113_((String)">"), b -> this.changePage(1)).m_252987_(centerX + 40, navY, 20, 20).m_253136_();
        prev.f_93623_ = this.page > 0;
        next.f_93623_ = (this.page + 1) * 6 < this.fIds.size();
        this.m_142416_((GuiEventListener)prev);
        this.m_142416_((GuiEventListener)next);
        Button reload = Button.m_253074_((Component)Component.m_237115_((String)"extendedae_plus.screen.reload_mapping"), b -> this.reloadMapping()).m_252987_(centerX - 130, navY + 30, 80, 20).m_253136_();
        this.m_142416_((GuiEventListener)reload);
        if (this.cnInput == null) {
            this.cnInput = new EditBox(this.f_96547_, centerX + 50, navY + 30, 120, 20, (Component)Component.m_237115_((String)"extendedae_plus.screen.cn_name"));
        } else {
            this.cnInput.m_252865_(centerX + 50);
            this.cnInput.m_253211_(navY + 30);
            this.cnInput.m_93674_(120);
        }
        this.m_142416_((GuiEventListener)this.cnInput);
        Button addMap = Button.m_253074_((Component)Component.m_237115_((String)"extendedae_plus.screen.add_mapping"), b -> this.addMappingFromUI()).m_252987_(centerX + 175, navY + 30, 60, 20).m_253136_();
        this.m_142416_((GuiEventListener)addMap);
        Button delByCn = Button.m_253074_((Component)Component.m_237113_((String)"\u5220\u9664\u6620\u5c04"), b -> this.deleteMappingByCnFromUI()).m_252987_(centerX + 240, navY + 30, 60, 20).m_253136_();
        this.m_142416_((GuiEventListener)delByCn);
        Button close = Button.m_253074_((Component)Component.m_237115_((String)"gui.cancel"), b -> this.m_7379_()).m_252987_(centerX - 40, navY + 30, 80, 20).m_253136_();
        this.m_142416_((GuiEventListener)close);
    }

    private void changePage(int delta) {
        int newPage = this.page + delta;
        if (newPage < 0) {
            return;
        }
        if (newPage * 6 >= this.fIds.size()) {
            return;
        }
        this.page = newPage;
        this.needsRefresh = true;
    }

    private void reloadMapping() {
        block3: {
            try {
                ExtendedAEPatternUploadUtil.loadRecipeTypeNames();
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player != null) {
                    player.m_213846_((Component)Component.m_237113_((String)"ExtendedAE Plus: \u5df2\u91cd\u8f7d\u6620\u5c04\u8868"));
                }
            }
            catch (Throwable t) {
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player == null) break block3;
                player.m_213846_((Component)Component.m_237113_((String)("ExtendedAE Plus: \u91cd\u8f7d\u6620\u5c04\u8868\u5931\u8d25: " + t.getClass().getSimpleName())));
            }
        }
    }

    private String buildLabel(int idx) {
        String name = this.fNames.get(idx);
        int totalSlots = this.fTotalSlots.get(idx);
        int count = this.fCount.get(idx);
        return name + "  (" + totalSlots + ")  x" + count;
    }

    private void onChoose(int idx) {
        if (idx < 0 || idx >= this.fIds.size()) {
            return;
        }
        long providerId = this.fIds.get(idx);
        ModNetwork.CHANNEL.sendToServer((Object)new UploadEncodedPatternToProviderC2SPacket(providerId));
        this.m_7379_();
    }

    public void m_7379_() {
        Minecraft.m_91087_().m_91152_(this.parent);
    }

    public boolean m_7043_() {
        return false;
    }

    private void buildGroups() {
        LinkedHashMap<String, Group> map = new LinkedHashMap<String, Group>();
        for (int i = 0; i < this.names.size(); ++i) {
            String name = this.names.get(i);
            long id = this.ids.get(i);
            int slots = this.emptySlots.get(i);
            Group g = map.computeIfAbsent(name, k -> new Group());
            ++g.count;
            g.totalSlots += Math.max(0, slots);
            if (slots <= g.bestSlots) continue;
            g.bestSlots = slots;
            g.bestId = id;
        }
        for (Map.Entry e : map.entrySet()) {
            String name = (String)e.getKey();
            Group g = (Group)e.getValue();
            this.gNames.add(name);
            this.gIds.add(g.bestId);
            this.gTotalSlots.add(g.totalSlots);
            this.gCount.add(g.count);
        }
    }

    private void applyFilter() {
        int i;
        this.fIds.clear();
        this.fNames.clear();
        this.fTotalSlots.clear();
        this.fCount.clear();
        String q = this.query == null ? "" : this.query.trim();
        for (i = 0; i < this.gIds.size(); ++i) {
            String name = this.gNames.get(i);
            if (!q.isEmpty() && !ProviderSelectScreen.nameMatches(name, q)) continue;
            this.fIds.add(this.gIds.get(i));
            this.fNames.add(name);
            this.fTotalSlots.add(this.gTotalSlots.get(i));
            this.fCount.add(this.gCount.get(i));
        }
        if (!q.isEmpty() && this.fIds.isEmpty()) {
            for (i = 0; i < this.gIds.size(); ++i) {
                this.fIds.add(this.gIds.get(i));
                this.fNames.add(this.gNames.get(i));
                this.fTotalSlots.add(this.gTotalSlots.get(i));
                this.fCount.add(this.gCount.get(i));
            }
        }
    }

    private static boolean nameMatches(String name, String key) {
        if (name == null) {
            return false;
        }
        if (key == null || key.isEmpty()) {
            return true;
        }
        try {
            if (JEC_AVAILABLE == null) {
                try {
                    Class<?> cls = Class.forName("me.towdium.jecharacters.utils.Match");
                    JEC_CONTAINS = cls.getMethod("contains", CharSequence.class, CharSequence.class);
                    JEC_AVAILABLE = true;
                }
                catch (Throwable t) {
                    JEC_AVAILABLE = false;
                }
            }
            if (Boolean.TRUE.equals(JEC_AVAILABLE) && JEC_CONTAINS != null) {
                String kL;
                Object r = JEC_CONTAINS.invoke(null, name, key);
                if (r instanceof Boolean && ((Boolean)r).booleanValue()) {
                    return true;
                }
                String nL = name.toLowerCase();
                Object r2 = JEC_CONTAINS.invoke(null, nL, kL = key.toLowerCase());
                if (r2 instanceof Boolean && ((Boolean)r2).booleanValue()) {
                    return true;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return name.toLowerCase().contains(key.toLowerCase());
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.searchBox != null && this.searchBox.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.searchBox != null && this.searchBox.m_5534_(codePoint, modifiers)) {
            return true;
        }
        return super.m_5534_(codePoint, modifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 1 && this.searchBox != null) {
            int x = this.searchBox.m_252754_();
            int y = this.searchBox.m_252907_();
            int w = this.searchBox.m_5711_();
            int h = this.searchBox.m_93694_();
            if (mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h)) {
                if (!this.searchBox.m_94155_().isEmpty()) {
                    this.searchBox.m_94144_("");
                }
                this.query = "";
                this.page = 0;
                this.applyFilter();
                this.needsRefresh = true;
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.searchBox != null) {
            this.searchBox.m_94120_();
        }
        if (this.cnInput != null) {
            this.cnInput.m_94120_();
        }
        if (this.needsRefresh) {
            this.needsRefresh = false;
            this.m_7856_();
        }
    }

    private void addMappingFromUI() {
        String key = this.query == null ? "" : this.query.trim();
        String val = this.cnInput == null ? "" : this.cnInput.m_94155_().trim();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (key.isEmpty()) {
            if (player != null) {
                player.m_213846_((Component)Component.m_237113_((String)"\u8bf7\u8f93\u5165\u641c\u7d22\u5173\u952e\u5b57\u540e\u518d\u6dfb\u52a0\u6620\u5c04"));
            }
            return;
        }
        if (val.isEmpty()) {
            if (player != null) {
                player.m_213846_((Component)Component.m_237113_((String)"\u8bf7\u8f93\u5165\u4e2d\u6587\u540d\u79f0"));
            }
            return;
        }
        boolean ok = ExtendedAEPatternUploadUtil.addOrUpdateAliasMapping(key, val);
        if (ok) {
            if (player != null) {
                player.m_213846_((Component)Component.m_237113_((String)("\u5df2\u6dfb\u52a0/\u66f4\u65b0\u6620\u5c04: " + key + " -> " + val)));
            }
            this.query = val;
            if (this.searchBox != null) {
                this.searchBox.m_94144_(val);
            }
            this.applyFilter();
            this.page = 0;
            this.needsRefresh = true;
        } else if (player != null) {
            player.m_213846_((Component)Component.m_237113_((String)"\u5199\u5165\u6620\u5c04\u5931\u8d25"));
        }
    }

    private void deleteMappingByCnFromUI() {
        String val = this.cnInput == null ? "" : this.cnInput.m_94155_().trim();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (val.isEmpty()) {
            if (player != null) {
                player.m_213846_((Component)Component.m_237113_((String)"\u8bf7\u8f93\u5165\u4e2d\u6587\u540d\u79f0\u540e\u518d\u5220\u9664\u6620\u5c04"));
            }
            return;
        }
        int removed = ExtendedAEPatternUploadUtil.removeMappingsByCnValue(val);
        if (removed > 0) {
            if (player != null) {
                player.m_213846_((Component)Component.m_237113_((String)("\u5df2\u5220\u9664 " + removed + " \u6761\u6620\u5c04\uff0c\u4e2d\u6587= " + val)));
            }
            this.applyFilter();
            this.needsRefresh = true;
        } else if (player != null) {
            player.m_213846_((Component)Component.m_237113_((String)("\u672a\u627e\u5230\u4e2d\u6587\u4e3a '" + val + "' \u7684\u6620\u5c04")));
        }
    }

    private static class Group {
        long bestId = Long.MIN_VALUE;
        int bestSlots = Integer.MIN_VALUE;
        int totalSlots = 0;
        int count = 0;

        private Group() {
        }
    }
}

