/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus;

import appeng.block.AEBaseEntityBlock;
import appeng.blockentity.crafting.CraftingBlockEntity;
import com.extendedae_plus.config.ModConfigs;
import com.extendedae_plus.init.ModBlockEntities;
import com.extendedae_plus.init.ModBlocks;
import com.extendedae_plus.init.ModCapabilities;
import com.extendedae_plus.init.ModCreativeTabs;
import com.extendedae_plus.init.ModItems;
import com.extendedae_plus.init.ModMenuTypes;
import com.extendedae_plus.network.ModNetwork;
import com.mojang.logging.LogUtils;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.slf4j.Logger;

@Mod(value="extendedae_plus")
public class ExtendedAEPlus {
    public static final String MODID = "extendedae_plus";
    public static final Logger LOGGER = LogUtils.getLogger();

    public ExtendedAEPlus(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(ModNetwork::registerPayloadHandlers);
        modEventBus.addListener(ModCapabilities::onRegisterCapabilities);
        ModBlocks.BLOCKS.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        ModBlockEntities.BLOCK_ENTITY_TYPES.register(modEventBus);
        ModCreativeTabs.TABS.register(modEventBus);
        ModMenuTypes.MENUS.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ModConfigs.COMMON_SPEC);
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM COMMON SETUP");
        LOGGER.info("DIRT BLOCK >> {}", (Object)BuiltInRegistries.BLOCK.getKey((Object)Blocks.DIRT));
        event.enqueueWork(() -> {
            try {
                AEBaseEntityBlock b4 = (AEBaseEntityBlock)ModBlocks.ACCELERATOR_4x.get();
                AEBaseEntityBlock b16 = (AEBaseEntityBlock)ModBlocks.ACCELERATOR_16x.get();
                AEBaseEntityBlock b64 = (AEBaseEntityBlock)ModBlocks.ACCELERATOR_64x.get();
                AEBaseEntityBlock b256 = (AEBaseEntityBlock)ModBlocks.ACCELERATOR_256x.get();
                AEBaseEntityBlock b1024 = (AEBaseEntityBlock)ModBlocks.ACCELERATOR_1024x.get();
                BlockEntityType type = (BlockEntityType)ModBlockEntities.EPLUS_CRAFTING_UNIT_BE.get();
                b4.setBlockEntity(CraftingBlockEntity.class, type, null, null);
                b16.setBlockEntity(CraftingBlockEntity.class, type, null, null);
                b64.setBlockEntity(CraftingBlockEntity.class, type, null, null);
                b256.setBlockEntity(CraftingBlockEntity.class, type, null, null);
                b1024.setBlockEntity(CraftingBlockEntity.class, type, null, null);
                LOGGER.info("Bound AE2 CraftingBlockEntity to ExtendedAE Plus accelerators.");
            }
            catch (Throwable t) {
                LOGGER.warn("Failed to bind CraftingBlockEntity to accelerators: {}", (Object)t.toString());
            }
        });
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }
}

