/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.network;

import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingService;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.items.tools.powered.WirelessTerminalItem;
import appeng.menu.locator.MenuHostLocator;
import appeng.menu.locator.MenuLocators;
import appeng.menu.me.crafting.CraftAmountMenu;
import com.extendedae_plus.menu.locator.CuriosItemLocator;
import com.extendedae_plus.util.WirelessTerminalLocator;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class OpenCraftFromJeiC2SPacket
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<OpenCraftFromJeiC2SPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"extendedae_plus", (String)"open_craft_from_jei"));
    public static final StreamCodec<RegistryFriendlyByteBuf, OpenCraftFromJeiC2SPacket> STREAM_CODEC = StreamCodec.of((buf, pkt) -> GenericStack.writeBuffer((GenericStack)pkt.stack, (RegistryFriendlyByteBuf)buf), buf -> new OpenCraftFromJeiC2SPacket(GenericStack.readBuffer((RegistryFriendlyByteBuf)buf)));
    private final GenericStack stack;

    public OpenCraftFromJeiC2SPacket(GenericStack stack) {
        this.stack = stack;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(OpenCraftFromJeiC2SPacket msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player patt0$temp = ctx.player();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)patt0$temp;
            if (player == null || msg.stack == null) {
                return;
            }
            AEKey what = msg.stack.what();
            WirelessTerminalLocator.LocatedTerminal located = WirelessTerminalLocator.find((Player)player);
            if (located.isEmpty()) {
                return;
            }
            String curiosSlotId = located.getCuriosSlotId();
            int curiosIndex = located.getCuriosIndex();
            if (curiosSlotId != null && curiosIndex >= 0) {
                int initial = 1;
                CraftAmountMenu.open((ServerPlayer)player, (MenuHostLocator)new CuriosItemLocator(curiosSlotId, curiosIndex), (AEKey)what, (int)initial);
                return;
            }
            Item patt1$temp = located.stack.getItem();
            if (!(patt1$temp instanceof WirelessTerminalItem)) {
                return;
            }
            WirelessTerminalItem wt = (WirelessTerminalItem)patt1$temp;
            IGrid grid = wt.getLinkedGrid(located.stack, player.level(), null);
            if (grid == null) {
                return;
            }
            if (!wt.hasPower((Player)player, 0.5, located.stack)) {
                return;
            }
            ICraftingService craftingService = grid.getCraftingService();
            if (!craftingService.isCraftable(what)) {
                return;
            }
            InteractionHand hand = located.getHand();
            int slot = located.getSlotIndex();
            if (hand != null) {
                int initial = 1;
                CraftAmountMenu.open((ServerPlayer)player, (MenuHostLocator)MenuLocators.forHand((Player)player, (InteractionHand)hand), (AEKey)what, (int)initial);
            } else if (slot >= 0) {
                int initial = 1;
                CraftAmountMenu.open((ServerPlayer)player, (MenuHostLocator)MenuLocators.forInventorySlot((int)slot), (AEKey)what, (int)initial);
            }
        });
    }
}

