/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.network;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class OpenProviderUiC2SPacket
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<OpenProviderUiC2SPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"extendedae_plus", (String)"open_provider_ui"));
    public static final StreamCodec<FriendlyByteBuf, OpenProviderUiC2SPacket> STREAM_CODEC = StreamCodec.of((buf, pkt) -> {
        buf.writeLong(pkt.posLong);
        buf.writeResourceLocation(pkt.dimId);
        buf.writeVarInt(pkt.faceOrd);
    }, buf -> new OpenProviderUiC2SPacket(buf.readLong(), buf.readResourceLocation(), buf.readVarInt()));
    private final long posLong;
    private final ResourceLocation dimId;
    private final int faceOrd;

    public OpenProviderUiC2SPacket(long posLong, ResourceLocation dimId, int faceOrd) {
        this.posLong = posLong;
        this.dimId = dimId;
        this.faceOrd = faceOrd;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(OpenProviderUiC2SPacket msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Direction[] tries;
            Direction[] directionArray;
            Player patt0$temp = ctx.player();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)patt0$temp;
            ResourceKey levelKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)msg.dimId);
            ServerLevel level = player.server.getLevel(levelKey);
            if (level == null) {
                return;
            }
            BlockPos pos = BlockPos.of((long)msg.posLong);
            if (!level.isLoaded(pos)) {
                return;
            }
            BlockEntity be = level.getBlockEntity(pos);
            BlockState stateAtPos = level.getBlockState(pos);
            if (msg.faceOrd >= 0 && msg.faceOrd < Direction.values().length) {
                Direction[] directionArray2 = new Direction[1];
                directionArray = directionArray2;
                directionArray2[0] = Direction.values()[msg.faceOrd];
            } else {
                directionArray = Direction.values();
            }
            for (Direction dir : tries = directionArray) {
                BlockPos targetPos = pos.relative(dir);
                BlockEntity tbe = level.getBlockEntity(targetPos);
                if (tbe instanceof MenuProvider) {
                    MenuProvider provider = (MenuProvider)tbe;
                    player.openMenu(provider, targetPos);
                    return;
                }
                BlockState tstate = level.getBlockState(targetPos);
                MenuProvider provider2 = tstate.getMenuProvider((Level)level, targetPos);
                if (provider2 == null) continue;
                player.openMenu(provider2, targetPos);
                return;
            }
        });
    }
}

