/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.util;

import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.stacks.GenericStack;
import appeng.client.gui.me.patternaccess.PatternContainerRecord;
import appeng.client.gui.me.patternaccess.PatternSlot;
import com.extendedae_plus.util.NumberFormatUtil;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class GuiUtil {
    private GuiUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static String getPatternOutputText(ItemStack pattern) {
        if (pattern.isEmpty()) {
            return "";
        }
        IPatternDetails details = PatternDetailsHelper.decodePattern((ItemStack)pattern, (Level)Minecraft.getInstance().level);
        if (details == null) {
            return "";
        }
        List outputs = details.getOutputs();
        if (outputs == null || outputs.isEmpty()) {
            return "";
        }
        GenericStack out = (GenericStack)outputs.get(0);
        long amount = out.amount();
        long perUnit = out.what().getAmountPerUnit();
        if (amount <= 0L || perUnit <= 0L) {
            return "";
        }
        double units = (double)amount / (double)perUnit;
        if (units <= 0.0) {
            return "";
        }
        String autoSuffix = "";
        if (perUnit > 1L) {
            autoSuffix = "B";
        }
        return NumberFormatUtil.formatNumberWithDecimal(units) + autoSuffix;
    }

    public static void drawAmountText(GuiGraphics guiGraphics, Font font, String text, int slotX, int slotY, float scale) {
        if (text.isEmpty()) {
            return;
        }
        int scaledWidth = (int)((float)font.width(text) * scale);
        int textX = slotX + 16 - scaledWidth;
        int textY = slotY + 11;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 300.0f);
        guiGraphics.pose().scale(scale, scale, 1.0f);
        guiGraphics.drawString(font, text, (int)((float)textX / scale), (int)((float)textY / scale), -1, true);
        guiGraphics.pose().popPose();
    }

    private static int withAlpha(int rgb, int alpha255) {
        return (alpha255 & 0xFF) << 24 | rgb & 0xFFFFFF;
    }

    private static int hsvToRgb(float h, float s, float v) {
        float g;
        float r;
        if (s <= 0.0f) {
            int g2 = Math.round(v * 255.0f);
            return g2 << 16 | g2 << 8 | g2;
        }
        float hh = (h - (float)Math.floor(h)) * 6.0f;
        int sector = (int)Math.floor(hh);
        float f = hh - (float)sector;
        float p = v * (1.0f - s);
        float q = v * (1.0f - s * f);
        float t = v * (1.0f - s * (1.0f - f));
        float b = switch (sector) {
            case 0 -> {
                r = v;
                g = t;
                yield p;
            }
            case 1 -> {
                r = q;
                g = v;
                yield p;
            }
            case 2 -> {
                r = p;
                g = v;
                yield t;
            }
            case 3 -> {
                r = p;
                g = q;
                yield v;
            }
            case 4 -> {
                r = t;
                g = p;
                yield v;
            }
            default -> {
                r = v;
                g = p;
                yield q;
            }
        };
        int ri = Math.round(r * 255.0f);
        int gi = Math.round(g * 255.0f);
        int bi = Math.round(b * 255.0f);
        return ri << 16 | gi << 8 | bi;
    }

    private static int getRainbowRgb() {
        long now = System.currentTimeMillis();
        long rainbowPeriodMs = 4000L;
        float hue = (float)(now % 4000L) / 4000.0f;
        return GuiUtil.hsvToRgb(hue, 1.0f, 1.0f);
    }

    private static void drawSlotBox(GuiGraphics guiGraphics, int sx, int sy, int borderColor, int backgroundColor) {
        guiGraphics.fill(sx - 1, sy - 1, sx + 17, sy, borderColor);
        guiGraphics.fill(sx - 1, sy + 16, sx + 17, sy + 17, borderColor);
        guiGraphics.fill(sx - 1, sy, sx, sy + 16, borderColor);
        guiGraphics.fill(sx + 16, sy, sx + 17, sy + 16, borderColor);
        guiGraphics.fill(sx, sy, sx + 16, sy + 16, backgroundColor);
    }

    public static void drawPatternSlotHighlights(GuiGraphics guiGraphics, List<Slot> slots, Set<ItemStack> matchedStack, Set<PatternContainerRecord> matchedProvider) {
        if (slots == null) {
            return;
        }
        int rainbowRgb = GuiUtil.getRainbowRgb();
        for (Slot slot : slots) {
            int backgroundColor;
            int borderColor;
            if (!(slot instanceof PatternSlot)) continue;
            PatternSlot ps = (PatternSlot)slot;
            int sx = slot.x;
            int sy = slot.y;
            boolean isMatchedSlot = matchedStack != null && matchedStack.contains(slot.getItem());
            boolean isMatchedProvider = false;
            try {
                PatternContainerRecord container = ps.getMachineInv();
                isMatchedProvider = matchedProvider != null && matchedProvider.contains(container);
            }
            catch (Throwable container) {
                // empty catch block
            }
            if (isMatchedSlot) {
                borderColor = GuiUtil.withAlpha(rainbowRgb, 160);
                backgroundColor = GuiUtil.withAlpha(rainbowRgb, 60);
            } else if (!isMatchedProvider) {
                borderColor = GuiUtil.withAlpha(0xFFFFFF, 64);
                backgroundColor = GuiUtil.withAlpha(0, 24);
            } else {
                borderColor = GuiUtil.withAlpha(0xFFFFFF, 48);
                backgroundColor = GuiUtil.withAlpha(0xFFFFFF, 20);
            }
            GuiUtil.drawSlotBox(guiGraphics, sx, sy, borderColor, backgroundColor);
        }
    }

    public static void drawSlotRainbowHighlight(GuiGraphics guiGraphics, int sx, int sy) {
        int rainbowRgb = GuiUtil.getRainbowRgb();
        int borderColor = GuiUtil.withAlpha(rainbowRgb, 160);
        int backgroundColor = GuiUtil.withAlpha(rainbowRgb, 60);
        GuiUtil.drawSlotBox(guiGraphics, sx, sy, borderColor, backgroundColor);
    }
}

