/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.mixin;

import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.stacks.GenericStack;
import appeng.crafting.pattern.AEProcessingPattern;
import appeng.crafting.pattern.EncodedPatternItem;
import appeng.helpers.patternprovider.PatternProviderLogicHost;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.PatternProviderMenu;
import appeng.menu.slot.AppEngSlot;
import com.glodblock.github.extendedae.container.ContainerExPatternProvider;
import com.glodblock.github.glodium.network.packet.sync.IActionHolder;
import com.glodblock.github.glodium.network.packet.sync.Paras;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ContainerExPatternProvider.class}, priority=3000)
public abstract class ContainerExPatternProviderMixin
extends PatternProviderMenu
implements IActionHolder {
    @GuiSync(value=11451)
    @Unique
    public int page = 0;
    @Unique
    public int maxPage = 0;
    @Unique
    private static final int SLOTS_PER_PAGE = 36;
    @Unique
    private final Map<String, Consumer<Paras>> actions = this.createHolder();

    public ContainerExPatternProviderMixin(MenuType<? extends PatternProviderMenu> menuType, int id, Inventory playerInventory, PatternProviderLogicHost host) {
        super(menuType, id, playerInventory, host);
    }

    @Unique
    public void showPage() {
        List slots = this.getSlots(SlotSemantics.ENCODED_PATTERN);
        int totalSlots = slots.size();
        if (totalSlots <= 36) {
            for (Slot s : slots) {
                ((AppEngSlot)s).setActive(true);
            }
            return;
        }
        int slot_id = 0;
        for (Slot s : slots) {
            int page_id = slot_id / 36;
            if (page_id == this.page) {
                ((AppEngSlot)s).setActive(true);
            } else {
                ((AppEngSlot)s).setActive(false);
            }
            ++slot_id;
        }
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void init(int id, Inventory playerInventory, PatternProviderLogicHost host, CallbackInfo ci) {
        int maxSlots = this.getSlots(SlotSemantics.ENCODED_PATTERN).size();
        this.maxPage = (maxSlots + 36 - 1) / 36;
        this.actions.put("multiply2", p -> {
            System.out.println("[EAE+][Server] multiply2");
            this.modifyPatterns(2, false);
        });
        this.actions.put("divide2", p -> {
            System.out.println("[EAE+][Server] divide2");
            this.modifyPatterns(2, true);
        });
        this.actions.put("multiply5", p -> {
            System.out.println("[EAE+][Server] multiply5");
            this.modifyPatterns(5, false);
        });
        this.actions.put("divide5", p -> {
            System.out.println("[EAE+][Server] divide5");
            this.modifyPatterns(5, true);
        });
        this.actions.put("multiply10", p -> {
            System.out.println("[EAE+][Server] multiply10");
            this.modifyPatterns(10, false);
        });
        this.actions.put("divide10", p -> {
            System.out.println("[EAE+][Server] divide10");
            this.modifyPatterns(10, true);
        });
        System.out.println("[EAE+][Server] ContainerExPatternProvider actions registered: " + String.valueOf(this.actions.keySet()));
    }

    @Unique
    public int getPage() {
        return this.page;
    }

    @Unique
    public void setPage(int page) {
        this.page = page;
    }

    @Unique
    private void modifyPatterns(int scale, boolean div) {
        if (scale <= 0) {
            return;
        }
        for (Slot slot : this.getSlots(SlotSemantics.ENCODED_PATTERN)) {
            EncodedPatternItem pattern;
            IPatternDetails detail;
            ItemStack stack = slot.m_7993_();
            Item item = stack.m_41720_();
            if (!(item instanceof EncodedPatternItem) || !((detail = (pattern = (EncodedPatternItem)item).decode(stack, this.getPlayer().m_9236_(), false)) instanceof AEProcessingPattern)) continue;
            AEProcessingPattern process = (AEProcessingPattern)detail;
            GenericStack[] input = process.getSparseInputs();
            GenericStack[] output = process.getOutputs();
            if (!this.checkModify(input, scale, div) || !this.checkModify(output, scale, div)) continue;
            GenericStack[] mulInput = new GenericStack[input.length];
            GenericStack[] mulOutput = new GenericStack[output.length];
            this.modifyStacks(input, mulInput, scale, div);
            this.modifyStacks(output, mulOutput, scale, div);
            ItemStack newPattern = PatternDetailsHelper.encodeProcessingPattern((GenericStack[])mulInput, (GenericStack[])mulOutput);
            slot.m_5852_(newPattern);
        }
    }

    @Unique
    private boolean checkModify(GenericStack[] stacks, int scale, boolean div) {
        if (stacks == null) {
            return false;
        }
        if (div) {
            for (GenericStack stack : stacks) {
                if (stack == null || stack.amount() % (long)scale == 0L) continue;
                return false;
            }
            return true;
        }
        for (GenericStack stack : stacks) {
            if (stack == null) continue;
            long upper = 999999L * (long)stack.what().getAmountPerUnit();
            if (stack.amount() * (long)scale <= upper) continue;
            return false;
        }
        return true;
    }

    @Unique
    private void modifyStacks(GenericStack[] src, GenericStack[] dst, int scale, boolean div) {
        for (int i = 0; i < src.length; ++i) {
            GenericStack stack = src[i];
            if (stack != null) {
                long amt = stack.amount();
                long newAmt = div ? amt / (long)scale : amt * (long)scale;
                dst[i] = new GenericStack(stack.what(), newAmt);
                continue;
            }
            dst[i] = null;
        }
    }

    @NotNull
    public Map<String, Consumer<Paras>> getActionMap() {
        return this.actions;
    }
}

