/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.util;

import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.implementations.blockentities.PatternContainerGroup;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.crafting.pattern.AECraftingPattern;
import appeng.helpers.patternprovider.PatternContainer;
import appeng.menu.implementations.PatternAccessTermMenu;
import appeng.menu.me.items.PatternEncodingTermMenu;
import appeng.menu.slot.RestrictedInputSlot;
import appeng.util.inv.FilteredInternalInventory;
import appeng.util.inv.filter.IAEItemFilter;
import com.extendedae_plus.mixin.accessor.PatternEncodingTermMenuAccessor;
import com.glodblock.github.extendedae.common.tileentities.matrix.TileAssemblerMatrixBase;
import com.glodblock.github.extendedae.common.tileentities.matrix.TileAssemblerMatrixPattern;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class ExtendedAEPatternUploadUtil {
    public static PatternAccessTermMenu getPatternAccessMenu(ServerPlayer player) {
        if (player == null || player.f_36096_ == null) {
            return null;
        }
        String containerClassName = player.f_36096_.getClass().getName();
        if (containerClassName.equals("com.glodblock.github.extendedae.container.ContainerExPatternTerminal")) {
            return (PatternAccessTermMenu)player.f_36096_;
        }
        if (player.f_36096_ instanceof PatternAccessTermMenu) {
            return (PatternAccessTermMenu)player.f_36096_;
        }
        return null;
    }

    public static boolean uploadFromEncodingMenuToMatrix(ServerPlayer player, PatternEncodingTermMenu menu) {
        if (player == null || menu == null) {
            System.out.println("[EAE+][Server] uploadFromEncodingMenuToMatrix: player or menu is null");
            return false;
        }
        RestrictedInputSlot encodedSlot = ((PatternEncodingTermMenuAccessor)menu).epp$getEncodedPatternSlot();
        ItemStack stack = encodedSlot.m_7993_();
        System.out.println("[EAE+][Server] Encoded slot stack: " + String.valueOf(stack) + ", count=" + stack.m_41613_());
        if (stack.m_41619_() || !PatternDetailsHelper.isEncodedPattern((ItemStack)stack)) {
            ExtendedAEPatternUploadUtil.sendMessage(player, "ExtendedAE Plus: \u6ca1\u6709\u53ef\u4e0a\u4f20\u7684\u7f16\u7801\u6837\u677f");
            System.out.println("[EAE+][Server] Fail: stack empty or not encoded pattern");
            return false;
        }
        IPatternDetails details = PatternDetailsHelper.decodePattern((ItemStack)stack, (Level)player.m_9236_());
        System.out.println("[EAE+][Server] Decoded details: " + (details == null ? "null" : details.getClass().getName()));
        if (!(details instanceof AECraftingPattern)) {
            ExtendedAEPatternUploadUtil.sendMessage(player, "extendedae_plus.upload_to_matrix.fail_not_crafting");
            System.out.println("[EAE+][Server] Fail: not AECraftingPattern");
            return false;
        }
        IGridNode node = menu.getNetworkNode();
        System.out.println("[EAE+][Server] Grid node: " + String.valueOf(node));
        if (node == null) {
            ExtendedAEPatternUploadUtil.sendMessage(player, "ExtendedAE Plus: \u5f53\u524d\u4e0d\u5728\u6709\u6548\u7684 AE \u7f51\u7edc\u4e2d");
            System.out.println("[EAE+][Server] Fail: grid node null");
            return false;
        }
        IGrid grid = node.getGrid();
        System.out.println("[EAE+][Server] Grid: " + String.valueOf(grid));
        if (grid == null) {
            ExtendedAEPatternUploadUtil.sendMessage(player, "ExtendedAE Plus: \u5f53\u524d\u4e0d\u5728\u6709\u6548\u7684 AE \u7f51\u7edc\u4e2d");
            System.out.println("[EAE+][Server] Fail: grid null");
            return false;
        }
        List<InternalInventory> inventories = ExtendedAEPatternUploadUtil.findAllMatrixPatternInventories(grid);
        System.out.println("[EAE+][Server] Matrix internal inventories count: " + inventories.size());
        if (!inventories.isEmpty()) {
            for (int i = 0; i < inventories.size(); ++i) {
                InternalInventory inv = inventories.get(i);
                ItemStack toInsert = stack.m_41777_();
                System.out.println("[EAE+][Server] Try insert via internal inventory[" + i + "], count=" + toInsert.m_41613_());
                ItemStack remain = inv.addItems(toInsert);
                System.out.println("[EAE+][Server] Internal inventory[" + i + "] remain count=" + remain.m_41613_());
                if (remain.m_41613_() >= stack.m_41613_()) continue;
                int inserted = stack.m_41613_() - remain.m_41613_();
                stack.m_41774_(inserted);
                if (stack.m_41619_()) {
                    encodedSlot.m_5852_(ItemStack.f_41583_);
                }
                ExtendedAEPatternUploadUtil.sendMessage(player, "extendedae_plus.upload_to_matrix.success");
                System.out.println("[EAE+][Server] Success via internal inventory[" + i + "]: inserted=" + inserted);
                return true;
            }
            System.out.println("[EAE+][Server] All internal inventories refused or full. Trying capability fallback.");
        }
        List<IItemHandler> handlers = ExtendedAEPatternUploadUtil.findAllMatrixPatternHandlers(grid);
        System.out.println("[EAE+][Server] Fallback Matrix item handlers count: " + handlers.size());
        if (!handlers.isEmpty()) {
            for (int i = 0; i < handlers.size(); ++i) {
                IItemHandler cap = handlers.get(i);
                ItemStack toInsert = stack.m_41777_();
                System.out.println("[EAE+][Server] Try insert via capability[" + i + "], count=" + toInsert.m_41613_());
                ItemStack remain = ExtendedAEPatternUploadUtil.insertIntoAnySlot(cap, toInsert);
                System.out.println("[EAE+][Server] Capability[" + i + "] remain count=" + remain.m_41613_());
                if (remain.m_41613_() >= stack.m_41613_()) continue;
                int inserted = stack.m_41613_() - remain.m_41613_();
                stack.m_41774_(inserted);
                if (stack.m_41619_()) {
                    encodedSlot.m_5852_(ItemStack.f_41583_);
                }
                ExtendedAEPatternUploadUtil.sendMessage(player, "extendedae_plus.upload_to_matrix.success");
                System.out.println("[EAE+][Server] Success via capability[" + i + "]: inserted=" + inserted);
                return true;
            }
        }
        if (inventories.isEmpty() && handlers.isEmpty()) {
            ExtendedAEPatternUploadUtil.sendMessage(player, "extendedae_plus.upload_to_matrix.fail_no_matrix");
            System.out.println("[EAE+][Server] Fail: no formed matrix found");
        } else {
            ExtendedAEPatternUploadUtil.sendMessage(player, "extendedae_plus.upload_to_matrix.fail_full");
            System.out.println("[EAE+][Server] Fail: all matrices full or cannot accept pattern");
        }
        return false;
    }

    private static List<InternalInventory> findAllMatrixPatternInventories(IGrid grid) {
        ArrayList<InternalInventory> result = new ArrayList<InternalInventory>();
        try {
            Set tiles = grid.getMachines(TileAssemblerMatrixPattern.class);
            int idx = 0;
            for (TileAssemblerMatrixPattern tile : tiles) {
                FilteredInternalInventory inv;
                if (tile != null && tile.isFormed() && tile.getMainNode().isActive() && (inv = tile.getExposedInventory()) != null) {
                    result.add((InternalInventory)inv);
                    System.out.println("[EAE+][Server] Found matrix internal inventory at index " + idx);
                }
                ++idx;
            }
        }
        catch (Throwable t) {
            System.out.println("[EAE+][Server] findAllMatrixPatternInventories exception: " + String.valueOf(t));
        }
        return result;
    }

    private static List<IItemHandler> findAllMatrixPatternHandlers(IGrid grid) {
        ArrayList<IItemHandler> result = new ArrayList<IItemHandler>();
        try {
            Set matrices = grid.getMachines(TileAssemblerMatrixBase.class);
            int idx = 0;
            for (TileAssemblerMatrixBase tile : matrices) {
                IItemHandler handler;
                LazyOptional capOpt;
                if (tile != null && tile.isFormed() && (capOpt = tile.getCapability(ForgeCapabilities.ITEM_HANDLER, null)) != null && (handler = (IItemHandler)capOpt.orElse(null)) != null) {
                    result.add(handler);
                    System.out.println("[EAE+][Server] Found matrix capability handler at index " + idx);
                }
                ++idx;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    private static ItemStack insertIntoAnySlot(IItemHandler handler, ItemStack stack) {
        ItemStack remaining = stack.m_41777_();
        if (handler == null || remaining.m_41619_()) {
            return remaining;
        }
        for (int i = 0; i < handler.getSlots() && !(remaining = handler.insertItem(i, remaining, false)).m_41619_(); ++i) {
        }
        return remaining;
    }

    public static boolean isExtendedAETerminal(ServerPlayer player) {
        if (player == null || player.f_36096_ == null) {
            return false;
        }
        String containerClassName = player.f_36096_.getClass().getName();
        return containerClassName.equals("com.glodblock.github.extendedae.container.ContainerExPatternTerminal");
    }

    public static boolean uploadPatternToProvider(ServerPlayer player, int playerSlotIndex, long providerId) {
        PatternAccessTermMenu menu = ExtendedAEPatternUploadUtil.getPatternAccessMenu(player);
        if (menu == null) {
            ExtendedAEPatternUploadUtil.sendMessage(player, "ExtendedAE Plus: \u8bf7\u5148\u6253\u5f00\u6837\u677f\u8bbf\u95ee\u7ec8\u7aef\u6216\u6269\u5c55\u6837\u677f\u7ba1\u7406\u7ec8\u7aef");
            return false;
        }
        ItemStack playerItem = player.m_150109_().m_8020_(playerSlotIndex);
        if (playerItem.m_41619_()) {
            ExtendedAEPatternUploadUtil.sendMessage(player, "ExtendedAE Plus: \u80cc\u5305\u69fd\u4f4d\u4e3a\u7a7a");
            return false;
        }
        if (!PatternDetailsHelper.isEncodedPattern((ItemStack)playerItem)) {
            ExtendedAEPatternUploadUtil.sendMessage(player, "ExtendedAE Plus: \u8be5\u7269\u54c1\u4e0d\u662f\u6709\u6548\u7684\u7f16\u7801\u6837\u677f");
            return false;
        }
        PatternContainer patternContainer = ExtendedAEPatternUploadUtil.getPatternContainerById(menu, providerId);
        if (patternContainer == null) {
            ExtendedAEPatternUploadUtil.sendMessage(player, "ExtendedAE Plus: \u627e\u4e0d\u5230\u6307\u5b9a\u7684\u6837\u677f\u4f9b\u5e94\u5668 (ID: " + providerId + ")");
            return false;
        }
        InternalInventory patternInventory = patternContainer.getTerminalPatternInventory();
        if (patternInventory == null) {
            ExtendedAEPatternUploadUtil.sendMessage(player, "ExtendedAE Plus: \u65e0\u6cd5\u8bbf\u95ee\u6837\u677f\u4f9b\u5e94\u5668\u7684\u5e93\u5b58");
            return false;
        }
        ExtendedAEPatternFilter patternFilter = new ExtendedAEPatternFilter();
        FilteredInternalInventory filteredInventory = new FilteredInternalInventory(patternInventory, (IAEItemFilter)patternFilter);
        ItemStack itemToInsert = playerItem.m_41777_();
        ItemStack remaining = filteredInventory.addItems(itemToInsert);
        if (remaining.m_41613_() < itemToInsert.m_41613_()) {
            int insertedCount = itemToInsert.m_41613_() - remaining.m_41613_();
            playerItem.m_41774_(insertedCount);
            if (playerItem.m_41619_()) {
                player.m_150109_().m_6836_(playerSlotIndex, ItemStack.f_41583_);
            }
            String terminalType = ExtendedAEPatternUploadUtil.isExtendedAETerminal(player) ? "\u6269\u5c55\u6837\u677f\u7ba1\u7406\u7ec8\u7aef" : "\u6837\u677f\u8bbf\u95ee\u7ec8\u7aef";
            ExtendedAEPatternUploadUtil.sendMessage(player, "ExtendedAE Plus: \u901a\u8fc7" + terminalType + "\u6210\u529f\u4e0a\u4f20 " + insertedCount + " \u4e2a\u6837\u677f");
            return true;
        }
        ExtendedAEPatternUploadUtil.sendMessage(player, "ExtendedAE Plus: \u4e0a\u4f20\u5931\u8d25 - \u6837\u677f\u4f9b\u5e94\u5668\u5df2\u6ee1\u6216\u6837\u677f\u65e0\u6548");
        return false;
    }

    public static int uploadMultiplePatterns(ServerPlayer player, int[] playerSlotIndices, long providerId) {
        int successCount = 0;
        for (int slotIndex : playerSlotIndices) {
            if (!ExtendedAEPatternUploadUtil.uploadPatternToProvider(player, slotIndex, providerId)) continue;
            ++successCount;
        }
        String terminalType = ExtendedAEPatternUploadUtil.isExtendedAETerminal(player) ? "\u6269\u5c55\u6837\u677f\u7ba1\u7406\u7ec8\u7aef" : "\u6837\u677f\u8bbf\u95ee\u7ec8\u7aef";
        ExtendedAEPatternUploadUtil.sendMessage(player, "ExtendedAE Plus: \u901a\u8fc7" + terminalType + "\u6279\u91cf\u4e0a\u4f20\u5b8c\u6210\uff0c\u6210\u529f\u4e0a\u4f20 " + successCount + " \u4e2a\u6837\u677f");
        return successCount;
    }

    public static boolean hasEnoughSlots(long providerId, PatternAccessTermMenu menu, int requiredSlots) {
        PatternContainer container = ExtendedAEPatternUploadUtil.getPatternContainerById(menu, providerId);
        if (container == null) {
            return false;
        }
        InternalInventory inventory = container.getTerminalPatternInventory();
        if (inventory == null) {
            return false;
        }
        int availableSlots = 0;
        for (int i = 0; i < inventory.size(); ++i) {
            if (!inventory.getStackInSlot(i).m_41619_() || ++availableSlots < requiredSlots) continue;
            return true;
        }
        return false;
    }

    public static int getAvailableSlots(long providerId, PatternAccessTermMenu menu) {
        PatternContainer container = ExtendedAEPatternUploadUtil.getPatternContainerById(menu, providerId);
        if (container == null) {
            return -1;
        }
        InternalInventory inventory = container.getTerminalPatternInventory();
        if (inventory == null) {
            return -1;
        }
        int availableSlots = 0;
        for (int i = 0; i < inventory.size(); ++i) {
            if (!inventory.getStackInSlot(i).m_41619_()) continue;
            ++availableSlots;
        }
        return availableSlots;
    }

    private static PatternContainer getPatternContainerById(PatternAccessTermMenu menu, long providerId) {
        try {
            Field byIdField = ExtendedAEPatternUploadUtil.findByIdField(menu.getClass());
            if (byIdField == null) {
                System.err.println("ExtendedAE Plus: \u65e0\u6cd5\u627e\u5230byId\u5b57\u6bb5");
                return null;
            }
            byIdField.setAccessible(true);
            Map byId = (Map)byIdField.get(menu);
            Object containerTracker = byId.get(providerId);
            if (containerTracker == null) {
                return null;
            }
            Field containerField = ExtendedAEPatternUploadUtil.findContainerField(containerTracker.getClass());
            if (containerField == null) {
                System.err.println("ExtendedAE Plus: \u65e0\u6cd5\u627e\u5230container\u5b57\u6bb5");
                return null;
            }
            containerField.setAccessible(true);
            return (PatternContainer)containerField.get(containerTracker);
        }
        catch (Exception e) {
            System.err.println("ExtendedAE Plus: \u65e0\u6cd5\u83b7\u53d6PatternContainer\uff0c\u9519\u8bef: " + e.getMessage());
            return null;
        }
    }

    private static Field findByIdField(Class<?> clazz) {
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            try {
                return currentClass.getDeclaredField("byId");
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        return null;
    }

    private static Field findContainerField(Class<?> clazz) {
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            try {
                return currentClass.getDeclaredField("container");
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        return null;
    }

    private static void sendMessage(ServerPlayer player, String message) {
    }

    public static String getProviderDisplayName(long providerId, PatternAccessTermMenu menu) {
        PatternContainer container = ExtendedAEPatternUploadUtil.getPatternContainerById(menu, providerId);
        if (container == null) {
            return "\u672a\u77e5\u4f9b\u5e94\u5668";
        }
        try {
            PatternContainerGroup group = container.getTerminalGroup();
            if (group != null) {
                return group.name().getString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "\u6837\u677f\u4f9b\u5e94\u5668 #" + providerId;
    }

    public static boolean isProviderAvailable(long providerId, PatternAccessTermMenu menu) {
        PatternContainer container = ExtendedAEPatternUploadUtil.getPatternContainerById(menu, providerId);
        if (container == null) {
            return false;
        }
        if (!container.isVisibleInTerminal()) {
            return false;
        }
        return container.getGrid() != null;
    }

    public static String getTerminalTypeDescription(ServerPlayer player) {
        if (ExtendedAEPatternUploadUtil.isExtendedAETerminal(player)) {
            return "ExtendedAE\u6269\u5c55\u6837\u677f\u7ba1\u7406\u7ec8\u7aef";
        }
        if (ExtendedAEPatternUploadUtil.getPatternAccessMenu(player) != null) {
            return "AE2\u6837\u677f\u8bbf\u95ee\u7ec8\u7aef";
        }
        return "\u672a\u77e5\u7ec8\u7aef\u7c7b\u578b";
    }

    private static class ExtendedAEPatternFilter
    implements IAEItemFilter {
        private ExtendedAEPatternFilter() {
        }

        public boolean allowExtract(InternalInventory inv, int slot, int amount) {
            return true;
        }

        public boolean allowInsert(InternalInventory inv, int slot, ItemStack stack) {
            return !stack.m_41619_() && PatternDetailsHelper.isEncodedPattern((ItemStack)stack);
        }
    }
}

