/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.content.wireless;

import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.IManagedGridNode;
import com.extendedae_plus.init.ModBlockEntities;
import com.extendedae_plus.init.ModItems;
import com.extendedae_plus.wireless.IWirelessEndpoint;
import com.extendedae_plus.wireless.WirelessMasterLink;
import com.extendedae_plus.wireless.WirelessSlaveLink;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class WirelessTransceiverBlockEntity
extends BlockEntity
implements IWirelessEndpoint,
IInWorldGridNodeHost {
    private IManagedGridNode managedNode = GridHelper.createManagedNode((Object)this, (IGridNodeListener)NodeListener.INSTANCE);
    private long frequency = 0L;
    private boolean masterMode = true;
    private WirelessMasterLink masterLink;
    private WirelessSlaveLink slaveLink;

    public WirelessTransceiverBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.WIRELESS_TRANSCEIVER_BE.get(), pos, state);
        this.managedNode.setIdlePowerUsage(1.0);
        this.managedNode.setTagName("wireless_node");
        this.managedNode.setInWorldNode(true);
        this.managedNode.setExposedOnSides(EnumSet.allOf(Direction.class));
        this.managedNode.setVisualRepresentation(((Item)ModItems.WIRELESS_TRANSCEIVER.get()).m_7968_());
        this.masterLink = new WirelessMasterLink(this);
        this.slaveLink = new WirelessSlaveLink(this);
    }

    @Nullable
    public IGridNode getGridNode(Direction dir) {
        return this.getGridNode();
    }

    @Override
    public ServerLevel getServerLevel() {
        ServerLevel sl;
        Level lvl = super.m_58904_();
        return lvl instanceof ServerLevel ? (sl = (ServerLevel)lvl) : null;
    }

    @Override
    public BlockPos m_58899_() {
        return this.f_58858_;
    }

    @Override
    public IGridNode getGridNode() {
        return this.managedNode == null ? null : this.managedNode.getNode();
    }

    @Override
    public boolean isEndpointRemoved() {
        return super.m_58901_();
    }

    public long getFrequency() {
        return this.frequency;
    }

    public void setFrequency(long frequency) {
        if (this.frequency == frequency) {
            return;
        }
        this.frequency = frequency;
        if (this.isMasterMode()) {
            this.masterLink.setFrequency(frequency);
        } else {
            this.slaveLink.setFrequency(frequency);
        }
        this.m_6596_();
    }

    public boolean isMasterMode() {
        return this.masterMode;
    }

    public void setMasterMode(boolean masterMode) {
        if (this.masterMode == masterMode) {
            return;
        }
        if (this.masterMode) {
            this.masterLink.onUnloadOrRemove();
        } else {
            this.slaveLink.onUnloadOrRemove();
        }
        this.masterMode = masterMode;
        if (this.masterMode) {
            this.masterLink.setFrequency(this.frequency);
        } else {
            this.slaveLink.setFrequency(this.frequency);
        }
        this.m_6596_();
    }

    public void onRemoved() {
        if (this.masterMode) {
            this.masterLink.onUnloadOrRemove();
        } else {
            this.slaveLink.onUnloadOrRemove();
        }
        if (this.managedNode != null) {
            this.managedNode.destroy();
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, WirelessTransceiverBlockEntity be) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        if (!be.masterMode) {
            be.slaveLink.updateStatus();
        }
    }

    public void onLoad() {
        super.onLoad();
        ServerLevel sl = this.getServerLevel();
        if (sl == null) {
            return;
        }
        GridHelper.onFirstTick((BlockEntity)this, be -> {
            be.managedNode.create(be.m_58904_(), be.m_58899_());
            if (be.masterMode) {
                be.masterLink.setFrequency(be.frequency);
            } else {
                be.slaveLink.setFrequency(be.frequency);
            }
        });
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128356_("frequency", this.frequency);
        tag.m_128379_("master", this.masterMode);
        if (this.managedNode != null) {
            this.managedNode.saveToNBT(tag);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.frequency = tag.m_128454_("frequency");
        this.masterMode = tag.m_128471_("master");
        if (this.managedNode != null) {
            this.managedNode.loadFromNBT(tag);
        }
        if (this.masterMode) {
            this.masterLink.setFrequency(this.frequency);
        } else {
            this.slaveLink.setFrequency(this.frequency);
        }
    }

    static enum NodeListener implements IGridNodeListener<WirelessTransceiverBlockEntity>
    {
        INSTANCE;


        public void onSaveChanges(WirelessTransceiverBlockEntity host, IGridNode node) {
            host.m_6596_();
        }

        public void onStateChanged(WirelessTransceiverBlockEntity host, IGridNode node, IGridNodeListener.State state) {
        }

        public void onInWorldConnectionChanged(WirelessTransceiverBlockEntity host, IGridNode node) {
        }

        public void onGridChanged(WirelessTransceiverBlockEntity host, IGridNode node) {
        }

        public void onOwnerChanged(WirelessTransceiverBlockEntity host, IGridNode node) {
        }
    }
}

