/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.integration.jei;

import java.util.Optional;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IBookmarkOverlay;
import mezz.jei.api.runtime.IIngredientListOverlay;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;

public final class JeiRuntimeProxy {
    private static volatile IJeiRuntime RUNTIME;

    private JeiRuntimeProxy() {
    }

    static void setRuntime(IJeiRuntime runtime) {
        RUNTIME = runtime;
    }

    @Nullable
    public static IJeiRuntime get() {
        return RUNTIME;
    }

    public static Optional<ITypedIngredient<?>> getIngredientUnderMouse() {
        Optional ing;
        Optional ing2;
        IJeiRuntime rt = RUNTIME;
        if (rt == null) {
            return Optional.empty();
        }
        IIngredientListOverlay list = rt.getIngredientListOverlay();
        if (list != null && (ing2 = list.getIngredientUnderMouse()).isPresent()) {
            return ing2.map(i -> i);
        }
        IBookmarkOverlay bm = rt.getBookmarkOverlay();
        if (bm != null && (ing = bm.getIngredientUnderMouse()).isPresent()) {
            return ing.map(i -> i);
        }
        return Optional.empty();
    }

    public static Optional<ITypedIngredient<?>> getIngredientUnderMouse(double mouseX, double mouseY) {
        IJeiRuntime rt = RUNTIME;
        if (rt == null || rt.getRecipesGui() == null) {
            return Optional.empty();
        }
        IIngredientManager ingredientManager = rt.getIngredientManager();
        Optional<ITypedIngredient> item = rt.getRecipesGui().getIngredientUnderMouse((IIngredientType)VanillaTypes.ITEM_STACK).flatMap(v -> ingredientManager.createTypedIngredient((IIngredientType)VanillaTypes.ITEM_STACK, v)).map(x -> x);
        if (item.isPresent()) {
            return Optional.of(item.get());
        }
        return Optional.empty();
    }
}

