/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.wireless;

import com.extendedae_plus.wireless.IWirelessEndpoint;
import com.extendedae_plus.wireless.WirelessMasterRegistry;
import net.minecraft.server.level.ServerLevel;

public class WirelessMasterLink {
    private final IWirelessEndpoint host;
    private long frequency;
    private boolean registered;

    public WirelessMasterLink(IWirelessEndpoint host) {
        this.host = host;
    }

    public long getFrequency() {
        return this.frequency;
    }

    public void setFrequency(long frequency) {
        if (this.frequency != frequency) {
            if (this.registered) {
                this.unregister();
            }
            this.frequency = frequency;
        }
        if (frequency != 0L && !this.host.isEndpointRemoved()) {
            if (!this.registered) {
                this.register();
            }
        } else if (this.registered) {
            this.unregister();
        }
    }

    public boolean register() {
        boolean ok;
        ServerLevel level = this.host.getServerLevel();
        if (level == null || this.frequency == 0L) {
            return false;
        }
        this.registered = ok = WirelessMasterRegistry.register(level, this.frequency, this.host);
        return ok;
    }

    public void unregister() {
        ServerLevel level = this.host.getServerLevel();
        if (!this.registered || level == null || this.frequency == 0L) {
            return;
        }
        WirelessMasterRegistry.unregister(level, this.frequency, this.host);
        this.registered = false;
    }

    public void onUnloadOrRemove() {
        this.unregister();
    }
}

