/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.mixin;

import appeng.client.gui.Icon;
import appeng.client.gui.implementations.PatternProviderScreen;
import appeng.client.gui.style.PaletteColor;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.VerticalButtonBar;
import appeng.menu.SlotSemantics;
import appeng.menu.implementations.PatternProviderMenu;
import com.glodblock.github.extendedae.client.button.ActionEPPButton;
import com.glodblock.github.extendedae.client.gui.GuiExPatternProvider;
import com.glodblock.github.extendedae.container.ContainerExPatternProvider;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiExPatternProvider.class})
public abstract class GuiExPatternProviderMixin
extends PatternProviderScreen<ContainerExPatternProvider> {
    @Unique
    ScreenStyle screenStyle;
    @Unique
    private VerticalButtonBar rightToolbar;
    @Unique
    private static final int SLOTS_PER_PAGE = 36;
    public ActionEPPButton nextPage;
    public ActionEPPButton prevPage;

    public GuiExPatternProviderMixin(ContainerExPatternProvider menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super((PatternProviderMenu)menu, playerInventory, title, style);
    }

    @Unique
    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        int maxSlots = ((ContainerExPatternProvider)this.m_6262_()).getSlots(SlotSemantics.ENCODED_PATTERN).size();
        if (maxSlots > 36) {
            Font fontRenderer = Minecraft.m_91087_().f_91062_;
            int currentPage = this.getCurrentPage();
            int maxPage = this.getMaxPage();
            int color = this.screenStyle.getColor(PaletteColor.DEFAULT_TEXT_COLOR).toARGB();
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)("\u7b2c " + (currentPage + 1) + "/" + maxPage + " \u9875")), this.f_97735_ + 8 + 50, this.f_97736_ + 30, color, false);
        }
    }

    @Unique
    public void updateBeforeRender() {
        super.updateBeforeRender();
        try {
            ContainerExPatternProvider menu1 = (ContainerExPatternProvider)this.m_6262_();
            Method showPageMethod = menu1.getClass().getMethod("showPage", new Class[0]);
            showPageMethod.invoke((Object)menu1, new Object[0]);
            Field fieldPage = menu1.getClass().getDeclaredField("page");
            fieldPage.setAccessible(true);
            Integer page = (Integer)fieldPage.get(menu1);
            Field fieldMaxPage = menu1.getClass().getDeclaredField("maxPage");
            fieldMaxPage.setAccessible(true);
            Integer maxPage = (Integer)fieldMaxPage.get(menu1);
            if (this.nextPage != null && this.prevPage != null) {
                this.nextPage.setVisibility(true);
                this.prevPage.setVisibility(true);
            }
            this.adjustSlotPositions(page);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Unique
    private void adjustSlotPositions(int currentPage) {
        try {
            List slots = ((ContainerExPatternProvider)this.m_6262_()).getSlots(SlotSemantics.ENCODED_PATTERN);
            int totalSlots = slots.size();
            if (totalSlots <= 36) {
                return;
            }
            int slot_id = 0;
            for (Slot s : slots) {
                int page_id = slot_id / 36;
                if (page_id == currentPage) {
                    int slotInPage = slot_id % 36;
                    int row = slotInPage / 9;
                    int col = slotInPage % 9;
                    int x = 8 + col * 18;
                    int y = 42 + row * 18;
                    Field xField = null;
                    Field yField = null;
                    String[] xFieldNames = new String[]{"x", "field_75262_c"};
                    String[] yFieldNames = new String[]{"y", "field_75263_d"};
                    for (String fieldName : xFieldNames) {
                        try {
                            xField = Slot.class.getDeclaredField(fieldName);
                            xField.setAccessible(true);
                            break;
                        }
                        catch (NoSuchFieldException noSuchFieldException) {
                        }
                    }
                    for (String fieldName : yFieldNames) {
                        try {
                            yField = Slot.class.getDeclaredField(fieldName);
                            yField.setAccessible(true);
                            break;
                        }
                        catch (NoSuchFieldException noSuchFieldException) {
                        }
                    }
                    if (xField != null && yField != null) {
                        xField.set(s, x);
                        yField.set(s, y);
                    }
                }
                ++slot_id;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Unique
    private int getCurrentPage() {
        try {
            ContainerExPatternProvider menu1 = (ContainerExPatternProvider)this.m_6262_();
            Field fieldPage = menu1.getClass().getDeclaredField("page");
            fieldPage.setAccessible(true);
            return (Integer)fieldPage.get(menu1);
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Unique
    private int getMaxPage() {
        try {
            ContainerExPatternProvider menu1 = (ContainerExPatternProvider)this.m_6262_();
            Field fieldMaxPage = menu1.getClass().getDeclaredField("maxPage");
            fieldMaxPage.setAccessible(true);
            return (Integer)fieldMaxPage.get(menu1);
        }
        catch (Exception e) {
            return 1;
        }
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")}, remap=false)
    private void injectInit(ContainerExPatternProvider menu, Inventory playerInventory, Component title, ScreenStyle style, CallbackInfo ci) {
        this.screenStyle = style;
        this.rightToolbar = new VerticalButtonBar();
        int maxSlots = ((ContainerExPatternProvider)this.m_6262_()).getSlots(SlotSemantics.ENCODED_PATTERN).size();
        if (maxSlots > 36) {
            this.prevPage = new ActionEPPButton(b -> {
                int currentPage = this.getCurrentPage();
                int maxPage = this.getMaxPage();
                int newPage = (currentPage - 1 + maxPage) % maxPage;
                try {
                    ContainerExPatternProvider menu1 = (ContainerExPatternProvider)this.m_6262_();
                    Method setPageMethod = menu1.getClass().getMethod("setPage", Integer.TYPE);
                    setPageMethod.invoke((Object)menu1, newPage);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }, Icon.ARROW_LEFT);
            this.nextPage = new ActionEPPButton(b -> {
                int currentPage = this.getCurrentPage();
                int maxPage = this.getMaxPage();
                int newPage = (currentPage + 1) % maxPage;
                try {
                    ContainerExPatternProvider menu1 = (ContainerExPatternProvider)this.m_6262_();
                    Method setPageMethod = menu1.getClass().getMethod("setPage", Integer.TYPE);
                    setPageMethod.invoke((Object)menu1, newPage);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }, Icon.ARROW_RIGHT);
            this.addToLeftToolbar((Button)this.nextPage);
            this.addToLeftToolbar((Button)this.prevPage);
        }
    }
}

