/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.network;

import com.extendedae_plus.network.NetworkHandler;
import com.extendedae_plus.network.PatternUploadResultPacket;
import com.extendedae_plus.util.ExtendedAEPatternUploadUtil;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class PatternUploadPacket {
    private final int playerSlotIndex;
    private final long providerId;

    public PatternUploadPacket(int playerSlotIndex, long providerId) {
        this.playerSlotIndex = playerSlotIndex;
        this.providerId = providerId;
    }

    public static void encode(PatternUploadPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.playerSlotIndex);
        buffer.writeLong(packet.providerId);
    }

    public static PatternUploadPacket decode(FriendlyByteBuf buffer) {
        int playerSlotIndex = buffer.readInt();
        long providerId = buffer.readLong();
        return new PatternUploadPacket(playerSlotIndex, providerId);
    }

    public static void handle(PatternUploadPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                boolean success = ExtendedAEPatternUploadUtil.uploadPatternToProvider(player, packet.playerSlotIndex, packet.providerId);
                if (success) {
                    PatternUploadResultPacket resultPacket = new PatternUploadResultPacket(true, "\u6837\u677f\u4e0a\u4f20\u6210\u529f\uff01");
                    NetworkHandler.sendToClient(resultPacket, player);
                } else {
                    PatternUploadResultPacket resultPacket = new PatternUploadResultPacket(false, "\u6837\u677f\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u4f9b\u5e94\u5668\u72b6\u6001");
                    NetworkHandler.sendToClient(resultPacket, player);
                }
            }
        });
        context.setPacketHandled(true);
    }
}

