/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraftforge.network.NetworkEvent;

public class PatternUploadResultPacket {
    private final boolean success;
    private final String message;

    public PatternUploadResultPacket(boolean success, String message) {
        this.success = success;
        this.message = message;
    }

    public static void encode(PatternUploadResultPacket packet, FriendlyByteBuf buffer) {
        buffer.writeBoolean(packet.success);
        buffer.m_130070_(packet.message);
    }

    public static PatternUploadResultPacket decode(FriendlyByteBuf buffer) {
        boolean success = buffer.readBoolean();
        String message = buffer.m_130277_();
        return new PatternUploadResultPacket(success, message);
    }

    public static void handle(PatternUploadResultPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91074_ != null) {
                String prefix = packet.success ? "\u2705 ExtendedAE Plus: " : "\u274c ExtendedAE Plus: ";
                minecraft.f_91074_.m_5661_((Component)Component.m_237113_((String)(prefix + packet.message)), true);
            }
        });
        context.setPacketHandled(true);
    }
}

