/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.test;

import appeng.menu.implementations.PatternAccessTermMenu;
import com.extendedae_plus.util.ExtendedAEPatternUploadUtil;
import com.glodblock.github.extendedae.container.ContainerExPatternTerminal;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ExtendedAEPatternUploadUtilTest {
    private static final List<TestResult> testResults = new ArrayList<TestResult>();

    public static void runAllTests() {
        System.out.println("=== ExtendedAEPatternUploadUtil \u529f\u80fd\u6d4b\u8bd5\u5f00\u59cb ===");
        testResults.clear();
        ExtendedAEPatternUploadUtilTest.testGetPatternAccessMenu();
        ExtendedAEPatternUploadUtilTest.testIsExtendedAETerminal();
        ExtendedAEPatternUploadUtilTest.testUploadPatternToProvider();
        ExtendedAEPatternUploadUtilTest.testUploadMultiplePatterns();
        ExtendedAEPatternUploadUtilTest.testHasEnoughSlots();
        ExtendedAEPatternUploadUtilTest.testGetAvailableSlots();
        ExtendedAEPatternUploadUtilTest.testGetProviderDisplayName();
        ExtendedAEPatternUploadUtilTest.testIsProviderAvailable();
        ExtendedAEPatternUploadUtilTest.testGetTerminalTypeDescription();
        ExtendedAEPatternUploadUtilTest.printTestResults();
        System.out.println("=== ExtendedAEPatternUploadUtil \u529f\u80fd\u6d4b\u8bd5\u5b8c\u6210 ===");
    }

    private static void testGetPatternAccessMenu() {
        System.out.println("\n[\u6d4b\u8bd5] getPatternAccessMenu()");
        try {
            TestResult result1 = new TestResult("getPatternAccessMenu - null player");
            try {
                PatternAccessTermMenu menu = ExtendedAEPatternUploadUtil.getPatternAccessMenu(null);
                result1.success = menu == null;
                result1.message = "\u7a7a\u73a9\u5bb6\u6d4b\u8bd5: " + (result1.success ? "\u901a\u8fc7" : "\u5931\u8d25");
            }
            catch (Exception e) {
                result1.success = false;
                result1.message = "\u7a7a\u73a9\u5bb6\u6d4b\u8bd5\u5f02\u5e38: " + e.getMessage();
            }
            testResults.add(result1);
            TestResult result2 = new TestResult("getPatternAccessMenu - no container");
            try {
                MockServerPlayer mockPlayer = new MockServerPlayer();
                mockPlayer.containerMenu = null;
                PatternAccessTermMenu menu = ExtendedAEPatternUploadUtil.getPatternAccessMenu(mockPlayer);
                result2.success = menu == null;
                result2.message = "\u65e0\u5bb9\u5668\u83dc\u5355\u6d4b\u8bd5: " + (result2.success ? "\u901a\u8fc7" : "\u5931\u8d25");
            }
            catch (Exception e) {
                result2.success = false;
                result2.message = "\u65e0\u5bb9\u5668\u83dc\u5355\u6d4b\u8bd5\u5f02\u5e38: " + e.getMessage();
            }
            testResults.add(result2);
            TestResult result3 = new TestResult("getPatternAccessMenu - ExtendedAE terminal");
            try {
                MockServerPlayer mockPlayer = new MockServerPlayer();
                mockPlayer.containerMenu = new MockContainerExPatternTerminal();
                PatternAccessTermMenu menu = ExtendedAEPatternUploadUtil.getPatternAccessMenu(mockPlayer);
                result3.success = menu != null && menu instanceof ContainerExPatternTerminal;
                result3.message = "ExtendedAE\u7ec8\u7aef\u6d4b\u8bd5: " + (result3.success ? "\u901a\u8fc7" : "\u5931\u8d25");
            }
            catch (Exception e) {
                result3.success = false;
                result3.message = "ExtendedAE\u7ec8\u7aef\u6d4b\u8bd5\u5f02\u5e38: " + e.getMessage();
            }
            testResults.add(result3);
            System.out.println("getPatternAccessMenu() \u6d4b\u8bd5\u5b8c\u6210");
        }
        catch (Exception e) {
            TestResult errorResult = new TestResult("getPatternAccessMenu - \u603b\u4f53\u6d4b\u8bd5");
            errorResult.success = false;
            errorResult.message = "\u6d4b\u8bd5\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38: " + e.getMessage();
            testResults.add(errorResult);
        }
    }

    private static void testIsExtendedAETerminal() {
        System.out.println("\n[\u6d4b\u8bd5] isExtendedAETerminal()");
        try {
            TestResult result1 = new TestResult("isExtendedAETerminal - ExtendedAE");
            try {
                boolean isExtended;
                MockServerPlayer mockPlayer = new MockServerPlayer();
                mockPlayer.containerMenu = new MockContainerExPatternTerminal();
                result1.success = isExtended = ExtendedAEPatternUploadUtil.isExtendedAETerminal(mockPlayer);
                result1.message = "ExtendedAE\u7ec8\u7aef\u68c0\u6d4b: " + (result1.success ? "\u901a\u8fc7" : "\u5931\u8d25");
            }
            catch (Exception e) {
                result1.success = false;
                result1.message = "ExtendedAE\u7ec8\u7aef\u68c0\u6d4b\u5f02\u5e38: " + e.getMessage();
            }
            testResults.add(result1);
            TestResult result2 = new TestResult("isExtendedAETerminal - vanilla AE2");
            try {
                MockServerPlayer mockPlayer = new MockServerPlayer();
                mockPlayer.containerMenu = new MockPatternAccessTermMenu();
                boolean isExtended = ExtendedAEPatternUploadUtil.isExtendedAETerminal(mockPlayer);
                result2.success = !isExtended;
                result2.message = "\u539f\u7248AE2\u7ec8\u7aef\u68c0\u6d4b: " + (result2.success ? "\u901a\u8fc7" : "\u5931\u8d25");
            }
            catch (Exception e) {
                result2.success = false;
                result2.message = "\u539f\u7248AE2\u7ec8\u7aef\u68c0\u6d4b\u5f02\u5e38: " + e.getMessage();
            }
            testResults.add(result2);
            System.out.println("isExtendedAETerminal() \u6d4b\u8bd5\u5b8c\u6210");
        }
        catch (Exception e) {
            TestResult errorResult = new TestResult("isExtendedAETerminal - \u603b\u4f53\u6d4b\u8bd5");
            errorResult.success = false;
            errorResult.message = "\u6d4b\u8bd5\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38: " + e.getMessage();
            testResults.add(errorResult);
        }
    }

    private static void testUploadPatternToProvider() {
        System.out.println("\n[\u6d4b\u8bd5] uploadPatternToProvider()");
        TestResult result = new TestResult("uploadPatternToProvider");
        try {
            MockServerPlayer mockPlayer = new MockServerPlayer();
            mockPlayer.containerMenu = new MockContainerExPatternTerminal();
            ItemStack testItem = new ItemStack((ItemLike)Items.f_42516_);
            mockPlayer.m_150109_().m_6836_(0, testItem);
            boolean uploadResult = ExtendedAEPatternUploadUtil.uploadPatternToProvider(mockPlayer, 0, 1L);
            result.success = true;
            result.message = "\u6837\u677f\u4e0a\u4f20\u6d4b\u8bd5: \u53c2\u6570\u9a8c\u8bc1\u901a\u8fc7\uff0c\u65e0\u5f02\u5e38\u629b\u51fa";
        }
        catch (Exception e) {
            result.success = false;
            result.message = "\u6837\u677f\u4e0a\u4f20\u6d4b\u8bd5\u5f02\u5e38: " + e.getMessage();
        }
        testResults.add(result);
        System.out.println("uploadPatternToProvider() \u6d4b\u8bd5\u5b8c\u6210");
    }

    private static void testUploadMultiplePatterns() {
        System.out.println("\n[\u6d4b\u8bd5] uploadMultiplePatterns()");
        TestResult result = new TestResult("uploadMultiplePatterns");
        try {
            MockServerPlayer mockPlayer = new MockServerPlayer();
            mockPlayer.containerMenu = new MockContainerExPatternTerminal();
            int[] slotIndices = new int[]{0, 1, 2};
            int uploadCount = ExtendedAEPatternUploadUtil.uploadMultiplePatterns(mockPlayer, slotIndices, 1L);
            result.success = true;
            result.message = "\u6279\u91cf\u4e0a\u4f20\u6d4b\u8bd5: \u53c2\u6570\u9a8c\u8bc1\u901a\u8fc7\uff0c\u8fd4\u56de\u7ed3\u679c: " + uploadCount;
        }
        catch (Exception e) {
            result.success = false;
            result.message = "\u6279\u91cf\u4e0a\u4f20\u6d4b\u8bd5\u5f02\u5e38: " + e.getMessage();
        }
        testResults.add(result);
        System.out.println("uploadMultiplePatterns() \u6d4b\u8bd5\u5b8c\u6210");
    }

    private static void testHasEnoughSlots() {
        System.out.println("\n[\u6d4b\u8bd5] hasEnoughSlots()");
        TestResult result = new TestResult("hasEnoughSlots");
        try {
            MockPatternAccessTermMenu mockMenu = new MockPatternAccessTermMenu();
            boolean hasSlots = ExtendedAEPatternUploadUtil.hasEnoughSlots(1L, mockMenu, 5);
            result.success = true;
            result.message = "\u69fd\u4f4d\u68c0\u67e5\u6d4b\u8bd5: \u53c2\u6570\u9a8c\u8bc1\u901a\u8fc7\uff0c\u7ed3\u679c: " + hasSlots;
        }
        catch (Exception e) {
            result.success = false;
            result.message = "\u69fd\u4f4d\u68c0\u67e5\u6d4b\u8bd5\u5f02\u5e38: " + e.getMessage();
        }
        testResults.add(result);
        System.out.println("hasEnoughSlots() \u6d4b\u8bd5\u5b8c\u6210");
    }

    private static void testGetAvailableSlots() {
        System.out.println("\n[\u6d4b\u8bd5] getAvailableSlots()");
        TestResult result = new TestResult("getAvailableSlots");
        try {
            MockPatternAccessTermMenu mockMenu = new MockPatternAccessTermMenu();
            int availableSlots = ExtendedAEPatternUploadUtil.getAvailableSlots(1L, mockMenu);
            result.success = true;
            result.message = "\u83b7\u53d6\u53ef\u7528\u69fd\u4f4d\u6d4b\u8bd5: \u53c2\u6570\u9a8c\u8bc1\u901a\u8fc7\uff0c\u7ed3\u679c: " + availableSlots;
        }
        catch (Exception e) {
            result.success = false;
            result.message = "\u83b7\u53d6\u53ef\u7528\u69fd\u4f4d\u6d4b\u8bd5\u5f02\u5e38: " + e.getMessage();
        }
        testResults.add(result);
        System.out.println("getAvailableSlots() \u6d4b\u8bd5\u5b8c\u6210");
    }

    private static void testGetProviderDisplayName() {
        System.out.println("\n[\u6d4b\u8bd5] getProviderDisplayName()");
        TestResult result = new TestResult("getProviderDisplayName");
        try {
            MockPatternAccessTermMenu mockMenu = new MockPatternAccessTermMenu();
            String displayName = ExtendedAEPatternUploadUtil.getProviderDisplayName(1L, mockMenu);
            result.success = displayName != null && !displayName.isEmpty();
            result.message = "\u83b7\u53d6\u663e\u793a\u540d\u79f0\u6d4b\u8bd5: " + (result.success ? "\u901a\u8fc7" : "\u5931\u8d25") + "\uff0c\u7ed3\u679c: " + displayName;
        }
        catch (Exception e) {
            result.success = false;
            result.message = "\u83b7\u53d6\u663e\u793a\u540d\u79f0\u6d4b\u8bd5\u5f02\u5e38: " + e.getMessage();
        }
        testResults.add(result);
        System.out.println("getProviderDisplayName() \u6d4b\u8bd5\u5b8c\u6210");
    }

    private static void testIsProviderAvailable() {
        System.out.println("\n[\u6d4b\u8bd5] isProviderAvailable()");
        TestResult result = new TestResult("isProviderAvailable");
        try {
            MockPatternAccessTermMenu mockMenu = new MockPatternAccessTermMenu();
            boolean isAvailable = ExtendedAEPatternUploadUtil.isProviderAvailable(1L, mockMenu);
            result.success = true;
            result.message = "\u4f9b\u5e94\u5668\u53ef\u7528\u6027\u6d4b\u8bd5: \u53c2\u6570\u9a8c\u8bc1\u901a\u8fc7\uff0c\u7ed3\u679c: " + isAvailable;
        }
        catch (Exception e) {
            result.success = false;
            result.message = "\u4f9b\u5e94\u5668\u53ef\u7528\u6027\u6d4b\u8bd5\u5f02\u5e38: " + e.getMessage();
        }
        testResults.add(result);
        System.out.println("isProviderAvailable() \u6d4b\u8bd5\u5b8c\u6210");
    }

    private static void testGetTerminalTypeDescription() {
        System.out.println("\n[\u6d4b\u8bd5] getTerminalTypeDescription()");
        try {
            TestResult result1 = new TestResult("getTerminalTypeDescription - ExtendedAE");
            try {
                MockServerPlayer mockPlayer = new MockServerPlayer();
                mockPlayer.containerMenu = new MockContainerExPatternTerminal();
                String description = ExtendedAEPatternUploadUtil.getTerminalTypeDescription(mockPlayer);
                result1.success = description.contains("ExtendedAE");
                result1.message = "ExtendedAE\u7ec8\u7aef\u63cf\u8ff0: " + description;
            }
            catch (Exception e) {
                result1.success = false;
                result1.message = "ExtendedAE\u7ec8\u7aef\u63cf\u8ff0\u5f02\u5e38: " + e.getMessage();
            }
            testResults.add(result1);
            TestResult result2 = new TestResult("getTerminalTypeDescription - AE2");
            try {
                MockServerPlayer mockPlayer = new MockServerPlayer();
                mockPlayer.containerMenu = new MockPatternAccessTermMenu();
                String description = ExtendedAEPatternUploadUtil.getTerminalTypeDescription(mockPlayer);
                result2.success = description.contains("AE2");
                result2.message = "AE2\u7ec8\u7aef\u63cf\u8ff0: " + description;
            }
            catch (Exception e) {
                result2.success = false;
                result2.message = "AE2\u7ec8\u7aef\u63cf\u8ff0\u5f02\u5e38: " + e.getMessage();
            }
            testResults.add(result2);
            System.out.println("getTerminalTypeDescription() \u6d4b\u8bd5\u5b8c\u6210");
        }
        catch (Exception e) {
            TestResult errorResult = new TestResult("getTerminalTypeDescription - \u603b\u4f53\u6d4b\u8bd5");
            errorResult.success = false;
            errorResult.message = "\u6d4b\u8bd5\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38: " + e.getMessage();
            testResults.add(errorResult);
        }
    }

    private static void printTestResults() {
        System.out.println("\n=== \u6d4b\u8bd5\u7ed3\u679c\u6c47\u603b ===");
        int totalTests = testResults.size();
        int passedTests = 0;
        int failedTests = 0;
        for (TestResult result : testResults) {
            String status = result.success ? "\u2705 \u901a\u8fc7" : "\u274c \u5931\u8d25";
            System.out.println(String.format("%-40s %s - %s", result.testName, status, result.message));
            if (result.success) {
                ++passedTests;
                continue;
            }
            ++failedTests;
        }
        System.out.println("\n=== \u7edf\u8ba1\u4fe1\u606f ===");
        System.out.println("\u603b\u6d4b\u8bd5\u6570: " + totalTests);
        System.out.println("\u901a\u8fc7: " + passedTests);
        System.out.println("\u5931\u8d25: " + failedTests);
        System.out.println("\u901a\u8fc7\u7387: " + String.format("%.1f%%", (double)passedTests / (double)totalTests * 100.0));
        if (failedTests == 0) {
            System.out.println("\ud83c\udf89 \u6240\u6709\u6d4b\u8bd5\u901a\u8fc7\uff01");
        } else {
            System.out.println("\u26a0\ufe0f  \u6709 " + failedTests + " \u4e2a\u6d4b\u8bd5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u529f\u80fd");
        }
    }

    public static void main(String[] args) {
        ExtendedAEPatternUploadUtilTest.runAllTests();
    }

    private static class TestResult {
        String testName;
        boolean success;
        String message;

        TestResult(String testName) {
            this.testName = testName;
            this.success = false;
            this.message = "";
        }
    }

    private static class MockServerPlayer
    extends ServerPlayer {
        public AbstractContainerMenu containerMenu;
        private Inventory inventory = new Inventory(null);

        public MockServerPlayer() {
            super(null, null, null);
        }

        public Inventory m_150109_() {
            return this.inventory;
        }

        public void m_213846_(Component message) {
            System.out.println("[\u6a21\u62df\u6d88\u606f] " + message.getString());
        }
    }

    private static class MockContainerExPatternTerminal
    extends ContainerExPatternTerminal {
        public MockContainerExPatternTerminal() {
            super(-1, null, null);
        }

        public boolean m_6875_(Player player) {
            return true;
        }
    }

    private static class MockPatternAccessTermMenu
    extends PatternAccessTermMenu {
        public MockPatternAccessTermMenu() {
            super(-1, null, null);
        }
    }
}

