/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.test;

import appeng.menu.implementations.PatternAccessTermMenu;
import com.extendedae_plus.util.ExtendedAEPatternUploadUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;

public class PatternUploadUtilTestRunner {
    private static final List<String> testResults = new ArrayList<String>();
    private static int passedTests = 0;
    private static int totalTests = 0;

    public static void runTests(ServerPlayer player) {
        System.out.println("=== ExtendedAEPatternUploadUtil \u6d4b\u8bd5\u5f00\u59cb ===");
        System.out.println("\u6ce8\u610f: \u67d0\u4e9b\u6d4b\u8bd5\u9700\u8981\u771f\u5b9e\u7684\u6e38\u620f\u73af\u5883\u624d\u80fd\u5b8c\u5168\u9a8c\u8bc1");
        testResults.clear();
        passedTests = 0;
        totalTests = 0;
        PatternUploadUtilTestRunner.testNullSafety();
        PatternUploadUtilTestRunner.testTerminalTypeDetection(player);
        PatternUploadUtilTestRunner.testUtilityMethods(player);
        PatternUploadUtilTestRunner.testParameterValidation();
        PatternUploadUtilTestRunner.printResults();
        System.out.println("=== ExtendedAEPatternUploadUtil \u6d4b\u8bd5\u5b8c\u6210 ===");
    }

    private static void testNullSafety() {
        System.out.println("\n[\u6d4b\u8bd5\u7ec4] \u7a7a\u503c\u5b89\u5168\u6027\u6d4b\u8bd5");
        PatternUploadUtilTestRunner.runTest("getPatternAccessMenu(null)", () -> {
            try {
                PatternAccessTermMenu result = ExtendedAEPatternUploadUtil.getPatternAccessMenu(null);
                return result == null;
            }
            catch (Exception e) {
                return false;
            }
        });
        PatternUploadUtilTestRunner.runTest("isExtendedAETerminal(null)", () -> {
            try {
                boolean result = ExtendedAEPatternUploadUtil.isExtendedAETerminal(null);
                return !result;
            }
            catch (Exception e) {
                return false;
            }
        });
        PatternUploadUtilTestRunner.runTest("getTerminalTypeDescription(null)", () -> {
            try {
                String result = ExtendedAEPatternUploadUtil.getTerminalTypeDescription(null);
                return result != null && result.contains("\u672a\u77e5");
            }
            catch (Exception e) {
                return false;
            }
        });
    }

    private static void testTerminalTypeDetection(ServerPlayer player) {
        System.out.println("\n[\u6d4b\u8bd5\u7ec4] \u7ec8\u7aef\u7c7b\u578b\u68c0\u6d4b\u6d4b\u8bd5");
        if (player == null) {
            PatternUploadUtilTestRunner.addTestResult("\u7ec8\u7aef\u7c7b\u578b\u68c0\u6d4b", false, "\u9700\u8981\u771f\u5b9e\u73a9\u5bb6\u5bf9\u8c61");
            return;
        }
        PatternUploadUtilTestRunner.runTest("\u5f53\u524d\u7ec8\u7aef\u7c7b\u578b\u68c0\u6d4b", () -> {
            try {
                boolean isExtended = ExtendedAEPatternUploadUtil.isExtendedAETerminal(player);
                String description = ExtendedAEPatternUploadUtil.getTerminalTypeDescription(player);
                PatternAccessTermMenu menu = ExtendedAEPatternUploadUtil.getPatternAccessMenu(player);
                System.out.println("  - \u662f\u5426ExtendedAE\u7ec8\u7aef: " + isExtended);
                System.out.println("  - \u7ec8\u7aef\u7c7b\u578b\u63cf\u8ff0: " + description);
                System.out.println("  - \u83b7\u53d6\u5230\u7684\u83dc\u5355: " + (menu != null ? menu.getClass().getSimpleName() : "null"));
                return true;
            }
            catch (Exception e) {
                System.out.println("  - \u5f02\u5e38: " + e.getMessage());
                return false;
            }
        });
    }

    private static void testUtilityMethods(ServerPlayer player) {
        System.out.println("\n[\u6d4b\u8bd5\u7ec4] \u5de5\u5177\u65b9\u6cd5\u6d4b\u8bd5");
        if (player == null) {
            PatternUploadUtilTestRunner.addTestResult("\u5de5\u5177\u65b9\u6cd5\u6d4b\u8bd5", false, "\u9700\u8981\u771f\u5b9e\u73a9\u5bb6\u5bf9\u8c61");
            return;
        }
        PatternUploadUtilTestRunner.runTest("\u83b7\u53d6\u6837\u677f\u8bbf\u95ee\u83dc\u5355", () -> {
            try {
                PatternAccessTermMenu menu = ExtendedAEPatternUploadUtil.getPatternAccessMenu(player);
                System.out.println("  - \u83dc\u5355\u7c7b\u578b: " + (menu != null ? menu.getClass().getSimpleName() : "\u65e0\u83dc\u5355"));
                return true;
            }
            catch (Exception e) {
                System.out.println("  - \u5f02\u5e38: " + e.getMessage());
                return false;
            }
        });
        PatternUploadUtilTestRunner.runTest("\u83b7\u53d6\u4f9b\u5e94\u5668\u663e\u793a\u540d\u79f0", () -> {
            try {
                PatternAccessTermMenu menu = ExtendedAEPatternUploadUtil.getPatternAccessMenu(player);
                if (menu != null) {
                    String displayName = ExtendedAEPatternUploadUtil.getProviderDisplayName(1L, menu);
                    System.out.println("  - \u663e\u793a\u540d\u79f0: " + displayName);
                    return displayName != null && !displayName.isEmpty();
                }
                System.out.println("  - \u8df3\u8fc7: \u65e0\u53ef\u7528\u83dc\u5355");
                return true;
            }
            catch (Exception e) {
                System.out.println("  - \u5f02\u5e38: " + e.getMessage());
                return false;
            }
        });
        PatternUploadUtilTestRunner.runTest("\u68c0\u67e5\u4f9b\u5e94\u5668\u53ef\u7528\u6027", () -> {
            try {
                PatternAccessTermMenu menu = ExtendedAEPatternUploadUtil.getPatternAccessMenu(player);
                if (menu != null) {
                    boolean isAvailable = ExtendedAEPatternUploadUtil.isProviderAvailable(1L, menu);
                    System.out.println("  - \u4f9b\u5e94\u5668\u53ef\u7528\u6027: " + isAvailable);
                    return true;
                }
                System.out.println("  - \u8df3\u8fc7: \u65e0\u53ef\u7528\u83dc\u5355");
                return true;
            }
            catch (Exception e) {
                System.out.println("  - \u5f02\u5e38: " + e.getMessage());
                return false;
            }
        });
    }

    private static void testParameterValidation() {
        System.out.println("\n[\u6d4b\u8bd5\u7ec4] \u53c2\u6570\u9a8c\u8bc1\u6d4b\u8bd5");
        PatternUploadUtilTestRunner.runTest("\u65e0\u6548\u69fd\u4f4d\u7d22\u5f15\u5904\u7406", () -> {
            try {
                boolean result1 = ExtendedAEPatternUploadUtil.uploadPatternToProvider(null, -1, 1L);
                boolean result2 = ExtendedAEPatternUploadUtil.uploadPatternToProvider(null, 999, 1L);
                return !result1 && !result2;
            }
            catch (Exception e) {
                System.out.println("  - \u5f02\u5e38: " + e.getMessage());
                return false;
            }
        });
        PatternUploadUtilTestRunner.runTest("\u65e0\u6548\u4f9b\u5e94\u5668ID\u5904\u7406", () -> {
            try {
                boolean result = ExtendedAEPatternUploadUtil.uploadPatternToProvider(null, 0, -1L);
                return !result;
            }
            catch (Exception e) {
                System.out.println("  - \u5f02\u5e38: " + e.getMessage());
                return false;
            }
        });
        PatternUploadUtilTestRunner.runTest("\u6279\u91cf\u4e0a\u4f20\u7a7a\u6570\u7ec4", () -> {
            try {
                int[] emptyArray = new int[]{};
                int result = ExtendedAEPatternUploadUtil.uploadMultiplePatterns(null, emptyArray, 1L);
                return result == 0;
            }
            catch (Exception e) {
                System.out.println("  - \u5f02\u5e38: " + e.getMessage());
                return false;
            }
        });
    }

    private static void runTest(String testName, TestFunction test) {
        ++totalTests;
        try {
            boolean passed = test.run();
            if (passed) {
                ++passedTests;
                PatternUploadUtilTestRunner.addTestResult(testName, true, "\u901a\u8fc7");
            } else {
                PatternUploadUtilTestRunner.addTestResult(testName, false, "\u5931\u8d25");
            }
        }
        catch (Exception e) {
            PatternUploadUtilTestRunner.addTestResult(testName, false, "\u5f02\u5e38: " + e.getMessage());
        }
    }

    private static void addTestResult(String testName, boolean passed, String message) {
        String status = passed ? "\u2705" : "\u274c";
        String result = String.format("  %s %-30s - %s", status, testName, message);
        testResults.add(result);
        System.out.println(result);
    }

    private static void printResults() {
        System.out.println("\n=== \u6d4b\u8bd5\u7ed3\u679c\u6c47\u603b ===");
        double successRate = totalTests > 0 ? (double)passedTests / (double)totalTests * 100.0 : 0.0;
        System.out.println("\u603b\u6d4b\u8bd5\u6570: " + totalTests);
        System.out.println("\u901a\u8fc7\u6570: " + passedTests);
        System.out.println("\u5931\u8d25\u6570: " + (totalTests - passedTests));
        System.out.println("\u6210\u529f\u7387: " + String.format("%.1f%%", successRate));
        if (passedTests == totalTests) {
            System.out.println("\ud83c\udf89 \u6240\u6709\u6d4b\u8bd5\u901a\u8fc7\uff01");
        } else {
            System.out.println("\u26a0\ufe0f \u6709\u6d4b\u8bd5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u4e0a\u8ff0\u8be6\u7ec6\u4fe1\u606f");
        }
        System.out.println("\n=== \u4f7f\u7528\u5efa\u8bae ===");
        System.out.println("1. \u5728\u6e38\u620f\u4e2d\u6253\u5f00\u6837\u677f\u8bbf\u95ee\u7ec8\u7aef\u540e\u8fd0\u884c\u6d4b\u8bd5\u4ee5\u83b7\u5f97\u66f4\u5b8c\u6574\u7684\u7ed3\u679c");
        System.out.println("2. \u786e\u4fdd\u80cc\u5305\u4e2d\u6709\u7f16\u7801\u6837\u677f\u8fdb\u884c\u4e0a\u4f20\u6d4b\u8bd5");
        System.out.println("3. \u8fde\u63a5\u5230AE2\u7f51\u7edc\u4ee5\u6d4b\u8bd5\u4f9b\u5e94\u5668\u76f8\u5173\u529f\u80fd");
    }

    public static void runInGameTest(ServerPlayer player) {
        System.out.println("\u5f00\u59cb\u6e38\u620f\u5185\u6d4b\u8bd5...");
        System.out.println("\u73a9\u5bb6: " + (player != null ? player.m_7755_().getString() : "null"));
        System.out.println("\u5f53\u524d\u5bb9\u5668: " + (player != null && player.f_36096_ != null ? player.f_36096_.getClass().getSimpleName() : "\u65e0"));
        PatternUploadUtilTestRunner.runTests(player);
    }

    public static void runOfflineTest() {
        System.out.println("\u5f00\u59cb\u79bb\u7ebf\u6d4b\u8bd5\uff08\u529f\u80fd\u6709\u9650\uff09...");
        PatternUploadUtilTestRunner.runTests(null);
    }

    @FunctionalInterface
    private static interface TestFunction {
        public boolean run() throws Exception;
    }
}

