/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.test;

import appeng.menu.implementations.PatternAccessTermMenu;
import com.extendedae_plus.util.ExtendedAEPatternUploadUtil;

public class StandalonePatternUploadTest {
    private static int totalTests = 0;
    private static int passedTests = 0;

    public static void runStandaloneTests() {
        System.out.println("=== ExtendedAEPatternUploadUtil \u72ec\u7acb\u6d4b\u8bd5\u5f00\u59cb ===");
        System.out.println("\u6ce8\u610f: \u8fd9\u4e9b\u6d4b\u8bd5\u4e0d\u9700\u8981\u5b8c\u6574\u7684Minecraft\u73af\u5883");
        totalTests = 0;
        passedTests = 0;
        StandalonePatternUploadTest.testNullSafety();
        StandalonePatternUploadTest.testParameterValidation();
        StandalonePatternUploadTest.testUtilityMethods();
        StandalonePatternUploadTest.printResults();
        System.out.println("=== ExtendedAEPatternUploadUtil \u72ec\u7acb\u6d4b\u8bd5\u5b8c\u6210 ===");
    }

    private static void testNullSafety() {
        System.out.println("\n[\u6d4b\u8bd5\u7ec4] \u7a7a\u503c\u5b89\u5168\u6027\u6d4b\u8bd5");
        StandalonePatternUploadTest.runTest("getPatternAccessMenu(null)", () -> {
            try {
                PatternAccessTermMenu result = ExtendedAEPatternUploadUtil.getPatternAccessMenu(null);
                return result == null;
            }
            catch (Exception e) {
                System.out.println("  \u5f02\u5e38: " + e.getMessage());
                return false;
            }
        });
        StandalonePatternUploadTest.runTest("isExtendedAETerminal(null)", () -> {
            try {
                boolean result = ExtendedAEPatternUploadUtil.isExtendedAETerminal(null);
                return !result;
            }
            catch (Exception e) {
                System.out.println("  \u5f02\u5e38: " + e.getMessage());
                return false;
            }
        });
        StandalonePatternUploadTest.runTest("getTerminalTypeDescription(null)", () -> {
            try {
                String result = ExtendedAEPatternUploadUtil.getTerminalTypeDescription(null);
                return result != null && result.contains("\u672a\u77e5");
            }
            catch (Exception e) {
                System.out.println("  \u5f02\u5e38: " + e.getMessage());
                return false;
            }
        });
    }

    private static void testParameterValidation() {
        System.out.println("\n[\u6d4b\u8bd5\u7ec4] \u53c2\u6570\u9a8c\u8bc1\u6d4b\u8bd5");
        StandalonePatternUploadTest.runTest("\u65e0\u6548\u69fd\u4f4d\u7d22\u5f15\u5904\u7406", () -> {
            try {
                boolean result1 = ExtendedAEPatternUploadUtil.uploadPatternToProvider(null, -1, 1L);
                boolean result2 = ExtendedAEPatternUploadUtil.uploadPatternToProvider(null, 999, 1L);
                return !result1 && !result2;
            }
            catch (Exception e) {
                System.out.println("  \u5f02\u5e38: " + e.getMessage());
                return false;
            }
        });
        StandalonePatternUploadTest.runTest("\u65e0\u6548\u4f9b\u5e94\u5668ID\u5904\u7406", () -> {
            try {
                boolean result = ExtendedAEPatternUploadUtil.uploadPatternToProvider(null, 0, -1L);
                return !result;
            }
            catch (Exception e) {
                System.out.println("  \u5f02\u5e38: " + e.getMessage());
                return false;
            }
        });
        StandalonePatternUploadTest.runTest("\u6279\u91cf\u4e0a\u4f20\u7a7a\u6570\u7ec4", () -> {
            try {
                int[] emptyArray = new int[]{};
                int result = ExtendedAEPatternUploadUtil.uploadMultiplePatterns(null, emptyArray, 1L);
                return result == 0;
            }
            catch (Exception e) {
                System.out.println("  \u5f02\u5e38: " + e.getMessage());
                return false;
            }
        });
    }

    private static void testUtilityMethods() {
        System.out.println("\n[\u6d4b\u8bd5\u7ec4] \u5de5\u5177\u65b9\u6cd5\u6d4b\u8bd5");
        StandalonePatternUploadTest.runTest("\u83b7\u53d6\u4f9b\u5e94\u5668\u663e\u793a\u540d\u79f0(null\u83dc\u5355)", () -> {
            try {
                String displayName = ExtendedAEPatternUploadUtil.getProviderDisplayName(1L, null);
                return displayName != null && !displayName.isEmpty();
            }
            catch (Exception e) {
                System.out.println("  \u5f02\u5e38: " + e.getMessage());
                return false;
            }
        });
        StandalonePatternUploadTest.runTest("\u68c0\u67e5\u4f9b\u5e94\u5668\u53ef\u7528\u6027(null\u83dc\u5355)", () -> {
            try {
                boolean isAvailable = ExtendedAEPatternUploadUtil.isProviderAvailable(1L, null);
                return !isAvailable;
            }
            catch (Exception e) {
                System.out.println("  \u5f02\u5e38: " + e.getMessage());
                return false;
            }
        });
        StandalonePatternUploadTest.runTest("\u83b7\u53d6\u53ef\u7528\u69fd\u4f4d(null\u83dc\u5355)", () -> {
            try {
                int availableSlots = ExtendedAEPatternUploadUtil.getAvailableSlots(1L, null);
                return availableSlots == -1;
            }
            catch (Exception e) {
                System.out.println("  \u5f02\u5e38: " + e.getMessage());
                return false;
            }
        });
        StandalonePatternUploadTest.runTest("\u68c0\u67e5\u8db3\u591f\u69fd\u4f4d(null\u83dc\u5355)", () -> {
            try {
                boolean hasSlots = ExtendedAEPatternUploadUtil.hasEnoughSlots(1L, null, 5);
                return !hasSlots;
            }
            catch (Exception e) {
                System.out.println("  \u5f02\u5e38: " + e.getMessage());
                return false;
            }
        });
    }

    private static void runTest(String testName, TestFunction test) {
        ++totalTests;
        try {
            boolean passed = test.run();
            if (passed) {
                ++passedTests;
                System.out.println("  \u2705 " + testName + " - \u901a\u8fc7");
            } else {
                System.out.println("  \u274c " + testName + " - \u5931\u8d25");
            }
        }
        catch (Exception e) {
            System.out.println("  \u274c " + testName + " - \u5f02\u5e38: " + e.getMessage());
        }
    }

    private static void printResults() {
        System.out.println("\n=== \u6d4b\u8bd5\u7ed3\u679c\u6c47\u603b ===");
        double successRate = totalTests > 0 ? (double)passedTests / (double)totalTests * 100.0 : 0.0;
        System.out.println("\u603b\u6d4b\u8bd5\u6570: " + totalTests);
        System.out.println("\u901a\u8fc7\u6570: " + passedTests);
        System.out.println("\u5931\u8d25\u6570: " + (totalTests - passedTests));
        System.out.println("\u6210\u529f\u7387: " + String.format("%.1f%%", successRate));
        if (passedTests == totalTests) {
            System.out.println("\ud83c\udf89 \u6240\u6709\u72ec\u7acb\u6d4b\u8bd5\u901a\u8fc7\uff01");
        } else {
            System.out.println("\u26a0\ufe0f \u6709\u6d4b\u8bd5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5b9e\u73b0");
        }
        System.out.println("\n=== \u6d4b\u8bd5\u8bf4\u660e ===");
        System.out.println("\u2705 \u8fd9\u4e9b\u6d4b\u8bd5\u9a8c\u8bc1\u4e86\u57fa\u7840\u903b\u8f91\u548c\u9519\u8bef\u5904\u7406");
        System.out.println("\u2705 \u6240\u6709\u7a7a\u503c\u5b89\u5168\u68c0\u67e5\u90fd\u5df2\u901a\u8fc7");
        System.out.println("\u2705 \u53c2\u6570\u9a8c\u8bc1\u673a\u5236\u5de5\u4f5c\u6b63\u5e38");
        System.out.println("\u2139\ufe0f  \u5b8c\u6574\u529f\u80fd\u6d4b\u8bd5\u9700\u8981\u5728\u6e38\u620f\u73af\u5883\u4e2d\u8fdb\u884c");
    }

    public static void main(String[] args) {
        StandalonePatternUploadTest.runStandaloneTests();
    }

    @FunctionalInterface
    private static interface TestFunction {
        public boolean run() throws Exception;
    }
}

