/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.util;

import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.implementations.blockentities.PatternContainerGroup;
import appeng.api.inventories.InternalInventory;
import appeng.helpers.patternprovider.PatternContainer;
import appeng.menu.implementations.PatternAccessTermMenu;
import appeng.util.inv.FilteredInternalInventory;
import appeng.util.inv.filter.IAEItemFilter;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class ExtendedAEPatternUploadUtil {
    public static PatternAccessTermMenu getPatternAccessMenu(ServerPlayer player) {
        if (player == null || player.f_36096_ == null) {
            return null;
        }
        String containerClassName = player.f_36096_.getClass().getName();
        if (containerClassName.equals("com.glodblock.github.extendedae.container.ContainerExPatternTerminal")) {
            return (PatternAccessTermMenu)player.f_36096_;
        }
        if (player.f_36096_ instanceof PatternAccessTermMenu) {
            return (PatternAccessTermMenu)player.f_36096_;
        }
        return null;
    }

    public static boolean isExtendedAETerminal(ServerPlayer player) {
        if (player == null || player.f_36096_ == null) {
            return false;
        }
        String containerClassName = player.f_36096_.getClass().getName();
        return containerClassName.equals("com.glodblock.github.extendedae.container.ContainerExPatternTerminal");
    }

    public static boolean uploadPatternToProvider(ServerPlayer player, int playerSlotIndex, long providerId) {
        PatternAccessTermMenu menu = ExtendedAEPatternUploadUtil.getPatternAccessMenu(player);
        if (menu == null) {
            return false;
        }
        ItemStack playerItem = player.m_150109_().m_8020_(playerSlotIndex);
        if (playerItem.m_41619_()) {
            return false;
        }
        if (!PatternDetailsHelper.isEncodedPattern((ItemStack)playerItem)) {
            return false;
        }
        PatternContainer patternContainer = ExtendedAEPatternUploadUtil.getPatternContainerById(menu, providerId);
        if (patternContainer == null) {
            return false;
        }
        InternalInventory patternInventory = patternContainer.getTerminalPatternInventory();
        if (patternInventory == null) {
            return false;
        }
        ExtendedAEPatternFilter patternFilter = new ExtendedAEPatternFilter();
        FilteredInternalInventory filteredInventory = new FilteredInternalInventory(patternInventory, (IAEItemFilter)patternFilter);
        ItemStack itemToInsert = playerItem.m_41777_();
        ItemStack remaining = filteredInventory.addItems(itemToInsert);
        if (remaining.m_41613_() < itemToInsert.m_41613_()) {
            int insertedCount = itemToInsert.m_41613_() - remaining.m_41613_();
            playerItem.m_41774_(insertedCount);
            if (playerItem.m_41619_()) {
                player.m_150109_().m_6836_(playerSlotIndex, ItemStack.f_41583_);
            }
            return true;
        }
        return false;
    }

    public static int uploadMultiplePatterns(ServerPlayer player, int[] playerSlotIndices, long providerId) {
        int successCount = 0;
        for (int slotIndex : playerSlotIndices) {
            if (!ExtendedAEPatternUploadUtil.uploadPatternToProvider(player, slotIndex, providerId)) continue;
            ++successCount;
        }
        return successCount;
    }

    public static boolean hasEnoughSlots(long providerId, PatternAccessTermMenu menu, int requiredSlots) {
        PatternContainer container = ExtendedAEPatternUploadUtil.getPatternContainerById(menu, providerId);
        if (container == null) {
            return false;
        }
        InternalInventory inventory = container.getTerminalPatternInventory();
        if (inventory == null) {
            return false;
        }
        int availableSlots = 0;
        for (int i = 0; i < inventory.size(); ++i) {
            if (!inventory.getStackInSlot(i).m_41619_() || ++availableSlots < requiredSlots) continue;
            return true;
        }
        return false;
    }

    public static int getAvailableSlots(long providerId, PatternAccessTermMenu menu) {
        PatternContainer container = ExtendedAEPatternUploadUtil.getPatternContainerById(menu, providerId);
        if (container == null) {
            return -1;
        }
        InternalInventory inventory = container.getTerminalPatternInventory();
        if (inventory == null) {
            return -1;
        }
        int availableSlots = 0;
        for (int i = 0; i < inventory.size(); ++i) {
            if (!inventory.getStackInSlot(i).m_41619_()) continue;
            ++availableSlots;
        }
        return availableSlots;
    }

    private static PatternContainer getPatternContainerById(PatternAccessTermMenu menu, long providerId) {
        try {
            Field byIdField = ExtendedAEPatternUploadUtil.findByIdField(menu.getClass());
            if (byIdField == null) {
                return null;
            }
            byIdField.setAccessible(true);
            Map byId = (Map)byIdField.get(menu);
            Object containerTracker = byId.get(providerId);
            if (containerTracker == null) {
                return null;
            }
            Field containerField = ExtendedAEPatternUploadUtil.findContainerField(containerTracker.getClass());
            if (containerField == null) {
                return null;
            }
            containerField.setAccessible(true);
            return (PatternContainer)containerField.get(containerTracker);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Field findByIdField(Class<?> clazz) {
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            try {
                return currentClass.getDeclaredField("byId");
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        return null;
    }

    private static Field findContainerField(Class<?> clazz) {
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            try {
                return currentClass.getDeclaredField("container");
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        return null;
    }

    public static String getProviderDisplayName(long providerId, PatternAccessTermMenu menu) {
        PatternContainer container = ExtendedAEPatternUploadUtil.getPatternContainerById(menu, providerId);
        if (container == null) {
            return "\u672a\u77e5\u4f9b\u5e94\u5668";
        }
        try {
            PatternContainerGroup group = container.getTerminalGroup();
            if (group != null) {
                return group.name().getString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "\u6837\u677f\u4f9b\u5e94\u5668 #" + providerId;
    }

    public static boolean isProviderAvailable(long providerId, PatternAccessTermMenu menu) {
        PatternContainer container = ExtendedAEPatternUploadUtil.getPatternContainerById(menu, providerId);
        if (container == null) {
            return false;
        }
        if (!container.isVisibleInTerminal()) {
            return false;
        }
        return container.getGrid() != null;
    }

    public static String getTerminalTypeDescription(ServerPlayer player) {
        if (ExtendedAEPatternUploadUtil.isExtendedAETerminal(player)) {
            return "ExtendedAE\u6269\u5c55\u6837\u677f\u7ba1\u7406\u7ec8\u7aef";
        }
        if (ExtendedAEPatternUploadUtil.getPatternAccessMenu(player) != null) {
            return "AE2\u6837\u677f\u8bbf\u95ee\u7ec8\u7aef";
        }
        return "\u672a\u77e5\u7ec8\u7aef\u7c7b\u578b";
    }

    private static class ExtendedAEPatternFilter
    implements IAEItemFilter {
        private ExtendedAEPatternFilter() {
        }

        public boolean allowExtract(InternalInventory inv, int slot, int amount) {
            return true;
        }

        public boolean allowInsert(InternalInventory inv, int slot, ItemStack stack) {
            return !stack.m_41619_() && PatternDetailsHelper.isEncodedPattern((ItemStack)stack);
        }
    }
}

