/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.compat;

import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.upgrades.Upgrades;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.ToolboxPanel;
import appeng.client.gui.widgets.UpgradesPanel;
import appeng.core.localization.GuiText;
import appeng.helpers.patternprovider.PatternProviderLogicHost;
import appeng.menu.AEBaseMenu;
import appeng.menu.SlotSemantics;
import appeng.menu.ToolboxMenu;
import com.extendedae_plus.util.ExtendedAELogger;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.ModList;

public class UpgradeSlotCompat {
    private static final String APPFLUX_MOD_ID = "appflux";

    public static boolean isAppfluxPresent() {
        return ModList.get().isLoaded(APPFLUX_MOD_ID);
    }

    public static boolean shouldEnableUpgradeSlots() {
        boolean appfluxExists = UpgradeSlotCompat.isAppfluxPresent();
        return !appfluxExists;
    }

    public static boolean shouldEnableChannelCard() {
        return true;
    }

    public static boolean shouldAddUpgradePanelToScreen() {
        return UpgradeSlotCompat.shouldEnableUpgradeSlots();
    }

    public static boolean initMenuUpgrades(AEBaseMenu menu, PatternProviderLogicHost host) {
        block6: {
            if (!UpgradeSlotCompat.shouldEnableUpgradeSlots()) {
                return false;
            }
            try {
                ToolboxMenu toolbox = new ToolboxMenu(menu);
                if (!(host instanceof IUpgradeableObject)) break block6;
                IUpgradeableObject upgradeableHost = (IUpgradeableObject)host;
                try {
                    Method setupUpgradesMethod = AEBaseMenu.class.getDeclaredMethod("setupUpgrades", IUpgradeInventory.class);
                    setupUpgradesMethod.setAccessible(true);
                    setupUpgradesMethod.invoke((Object)menu, upgradeableHost.getUpgrades());
                }
                catch (Exception e) {
                    ExtendedAELogger.LOGGER.error("\u53cd\u5c04\u8c03\u7528setupUpgrades\u5931\u8d25", (Throwable)e);
                    return false;
                }
                if (menu instanceof IUpgradeableMenuCompat) {
                    IUpgradeableMenuCompat compatMenu = (IUpgradeableMenuCompat)menu;
                    compatMenu.setCompatToolbox(toolbox);
                }
                ExtendedAELogger.LOGGER.debug("\u6210\u529f\u4e3aPatternProviderMenu\u521d\u59cb\u5316\u5347\u7ea7\u529f\u80fd");
                return true;
            }
            catch (Exception e) {
                ExtendedAELogger.LOGGER.error("\u521d\u59cb\u5316PatternProviderMenu\u5347\u7ea7\u529f\u80fd\u65f6\u51fa\u9519", (Throwable)e);
            }
        }
        return false;
    }

    public static boolean addUpgradePanelToScreen(Object widgets, Object menu, ScreenStyle style) {
        if (!UpgradeSlotCompat.shouldAddUpgradePanelToScreen()) {
            return false;
        }
        try {
            if (menu instanceof IUpgradeableMenuCompat) {
                IUpgradeableMenuCompat compatMenu = (IUpgradeableMenuCompat)menu;
                try {
                    Class<?> widgetsClass = widgets.getClass();
                    Method addMethod = widgetsClass.getDeclaredMethod("add", String.class, Object.class);
                    addMethod.setAccessible(true);
                    Class<?> menuClass = menu.getClass();
                    Method getSlotsMethod = menuClass.getMethod("getSlots", SlotSemantics.class);
                    List upgradeSlots = (List)getSlotsMethod.invoke(menu, SlotSemantics.UPGRADE);
                    UpgradesPanel upgradesPanel = new UpgradesPanel(upgradeSlots, () -> UpgradeSlotCompat.getCompatibleUpgrades(compatMenu));
                    addMethod.invoke(widgets, "upgrades", upgradesPanel);
                    ToolboxMenu toolbox = compatMenu.getCompatToolbox();
                    if (toolbox != null && toolbox.isPresent()) {
                        ToolboxPanel toolboxPanel = new ToolboxPanel(style, toolbox.getName());
                        addMethod.invoke(widgets, "toolbox", toolboxPanel);
                    }
                    ExtendedAELogger.LOGGER.debug("\u6210\u529f\u4e3aPatternProviderScreen\u6dfb\u52a0\u5347\u7ea7\u9762\u677f");
                    return true;
                }
                catch (NoSuchMethodException e) {
                    try {
                        Class<?> widgetsClass = widgets.getClass();
                        Method putMethod = widgetsClass.getDeclaredMethod("put", String.class, Object.class);
                        putMethod.setAccessible(true);
                        Class<?> menuClass = menu.getClass();
                        Method getSlotsMethod = menuClass.getMethod("getSlots", SlotSemantics.class);
                        List upgradeSlots = (List)getSlotsMethod.invoke(menu, SlotSemantics.UPGRADE);
                        UpgradesPanel upgradesPanel = new UpgradesPanel(upgradeSlots, () -> UpgradeSlotCompat.getCompatibleUpgrades(compatMenu));
                        putMethod.invoke(widgets, "upgrades", upgradesPanel);
                        ToolboxMenu toolbox = compatMenu.getCompatToolbox();
                        if (toolbox != null && toolbox.isPresent()) {
                            ToolboxPanel toolboxPanel = new ToolboxPanel(style, toolbox.getName());
                            putMethod.invoke(widgets, "toolbox", toolboxPanel);
                        }
                        ExtendedAELogger.LOGGER.debug("\u6210\u529f\u4e3aPatternProviderScreen\u6dfb\u52a0\u5347\u7ea7\u9762\u677f\uff08\u4f7f\u7528put\u65b9\u6cd5\uff09");
                        return true;
                    }
                    catch (Exception e2) {
                        ExtendedAELogger.LOGGER.error("\u53cd\u5c04\u8c03\u7528widgets\u65b9\u6cd5\u5931\u8d25", (Throwable)e2);
                        return false;
                    }
                }
            }
        }
        catch (Exception e) {
            ExtendedAELogger.LOGGER.error("\u4e3aPatternProviderScreen\u6dfb\u52a0\u5347\u7ea7\u9762\u677f\u65f6\u51fa\u9519", (Throwable)e);
        }
        return false;
    }

    private static List<Component> getCompatibleUpgrades(IUpgradeableMenuCompat menu) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)GuiText.CompatibleUpgrades.text());
        try {
            IUpgradeInventory upgrades = menu.getCompatUpgrades();
            if (upgrades != null) {
                list.addAll(Upgrades.getTooltipLinesForMachine((ItemLike)upgrades.getUpgradableItem()));
            }
        }
        catch (Exception e) {
            ExtendedAELogger.LOGGER.error("\u83b7\u53d6\u517c\u5bb9\u5347\u7ea7\u5217\u8868\u65f6\u51fa\u9519", (Throwable)e);
        }
        return list;
    }

    public static interface IUpgradeableMenuCompat {
        public ToolboxMenu getCompatToolbox();

        public void setCompatToolbox(ToolboxMenu var1);

        public IUpgradeInventory getCompatUpgrades();
    }
}

