/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.integration.jei;

import com.extendedae_plus.mixin.jei.accessor.BookmarkOverlayAccessor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IBookmarkOverlay;
import mezz.jei.api.runtime.IIngredientListOverlay;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.common.Internal;
import mezz.jei.gui.bookmarks.BookmarkList;
import mezz.jei.gui.bookmarks.IBookmark;
import mezz.jei.gui.bookmarks.IngredientBookmark;
import mezz.jei.gui.overlay.elements.IElement;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModList;
import org.spongepowered.asm.mixin.Pseudo;

@Pseudo
public final class JeiRuntimeProxy {
    private static volatile IJeiRuntime RUNTIME;

    private JeiRuntimeProxy() {
    }

    static void setRuntime(IJeiRuntime runtime) {
        RUNTIME = runtime;
    }

    @Nullable
    public static IJeiRuntime get() {
        return RUNTIME;
    }

    public static Optional<ITypedIngredient<?>> getIngredientUnderMouse() {
        Optional ing;
        Optional ing2;
        IJeiRuntime rt = RUNTIME;
        if (rt == null) {
            return Optional.empty();
        }
        IIngredientListOverlay list = rt.getIngredientListOverlay();
        if (list != null && (ing2 = list.getIngredientUnderMouse()).isPresent()) {
            return ing2.map(i -> i);
        }
        IBookmarkOverlay bm = rt.getBookmarkOverlay();
        if (bm != null && (ing = bm.getIngredientUnderMouse()).isPresent()) {
            return ing.map(i -> i);
        }
        return Optional.empty();
    }

    public static Optional<ITypedIngredient<?>> getIngredientUnderMouse(double mouseX, double mouseY) {
        IJeiRuntime rt = RUNTIME;
        if (rt == null || rt.getRecipesGui() == null) {
            return Optional.empty();
        }
        IIngredientManager ingredientManager = rt.getIngredientManager();
        Optional<ITypedIngredient> item = rt.getRecipesGui().getIngredientUnderMouse((IIngredientType)VanillaTypes.ITEM_STACK).flatMap(v -> ingredientManager.createTypedIngredient((IIngredientType)VanillaTypes.ITEM_STACK, v)).map(x -> x);
        if (item.isPresent()) {
            return Optional.of(item.get());
        }
        return Optional.empty();
    }

    public static boolean isJeiCheatModeEnabled() {
        try {
            return Internal.getClientToggleState().isCheatItemsEnabled();
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static void setIngredientFilterText(String text) {
        IJeiRuntime rt = RUNTIME;
        if (rt == null) {
            return;
        }
        try {
            rt.getIngredientFilter().setFilterText(text == null ? "" : text);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static <T> String getTypedIngredientDisplayName(ITypedIngredient<T> typed) {
        IJeiRuntime rt = RUNTIME;
        if (rt == null || typed == null) {
            return "";
        }
        try {
            IIngredientManager manager = rt.getIngredientManager();
            IIngredientHelper helper = manager.getIngredientHelper(typed.getType());
            String display = helper.getDisplayName(typed.getIngredient());
            if (display == null) {
                return "";
            }
            if (display instanceof Component) {
                Component comp = (Component)display;
                String s = comp.getString();
                return s == null ? "" : s;
            }
            String s = display.toString();
            return s == null ? "" : s;
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    public static List<? extends ITypedIngredient<?>> getBookmarkList() {
        IJeiRuntime rt = RUNTIME;
        if (rt == null) {
            return Collections.emptyList();
        }
        IBookmarkOverlay bookmarkOverlay = rt.getBookmarkOverlay();
        if (bookmarkOverlay instanceof BookmarkOverlayAccessor) {
            BookmarkOverlayAccessor accessor = (BookmarkOverlayAccessor)bookmarkOverlay;
            BookmarkList bookmarkList = accessor.eap$getBookmarkList();
            return bookmarkList.getElements().stream().map(IElement::getTypedIngredient).toList();
        }
        return Collections.emptyList();
    }

    public static void addBookmark(ItemStack stack) {
        IJeiRuntime rt = RUNTIME;
        if (rt == null) {
            return;
        }
        IBookmarkOverlay overlay = rt.getBookmarkOverlay();
        if (overlay instanceof BookmarkOverlayAccessor) {
            BookmarkOverlayAccessor accessor = (BookmarkOverlayAccessor)overlay;
            BookmarkList list = accessor.eap$getBookmarkList();
            Optional typedOpt = rt.getIngredientManager().createTypedIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)stack);
            typedOpt.ifPresent(typed -> {
                IngredientBookmark bookmark = IngredientBookmark.create((ITypedIngredient)typed, (IIngredientManager)rt.getIngredientManager());
                list.add((IBookmark)bookmark);
            });
        }
    }

    public static void addBookmark(FluidStack fluidStack) {
        IJeiRuntime rt = RUNTIME;
        if (rt == null) {
            return;
        }
        IBookmarkOverlay overlay = rt.getBookmarkOverlay();
        if (overlay instanceof BookmarkOverlayAccessor) {
            BookmarkOverlayAccessor accessor = (BookmarkOverlayAccessor)overlay;
            BookmarkList list = accessor.eap$getBookmarkList();
            Optional typedOpt = rt.getIngredientManager().createTypedIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)fluidStack);
            typedOpt.ifPresent(typed -> {
                IngredientBookmark bookmark = IngredientBookmark.create((ITypedIngredient)typed, (IIngredientManager)rt.getIngredientManager());
                list.add((IBookmark)bookmark);
            });
        }
    }

    public static void addBookmark(Object chemicalStack) {
        if (!ModList.get().isLoaded("mekanism") && !ModList.get().isLoaded("appmek")) {
            return;
        }
        IJeiRuntime rt = RUNTIME;
        if (rt == null) {
            return;
        }
        IBookmarkOverlay overlay = rt.getBookmarkOverlay();
        if (overlay instanceof BookmarkOverlayAccessor) {
            BookmarkOverlayAccessor accessor = (BookmarkOverlayAccessor)overlay;
            BookmarkList list = accessor.eap$getBookmarkList();
            try {
                String mekanismJeiClass;
                Class<?> jeiCls;
                if (chemicalStack == null) {
                    return;
                }
                String clsName = chemicalStack.getClass().getName();
                Field typeField = JeiRuntimeProxy.getField(clsName, jeiCls = Class.forName(mekanismJeiClass = "mekanism.client.jei.MekanismJEI"));
                if (typeField == null) {
                    return;
                }
                Object typeConst = typeField.get(null);
                IIngredientManager ingredientManager = rt.getIngredientManager();
                Method createTypedIngredient = ingredientManager.getClass().getMethod("createTypedIngredient", IIngredientType.class, Object.class);
                Object opt = createTypedIngredient.invoke((Object)ingredientManager, typeConst, chemicalStack);
                if (!(opt instanceof Optional)) {
                    return;
                }
                Optional typedOpt = (Optional)opt;
                if (typedOpt.isPresent()) {
                    Object bookmark;
                    Object typed = typedOpt.get();
                    Method createMethod = null;
                    for (Method m : IngredientBookmark.class.getMethods()) {
                        Class<?>[] params;
                        if (!m.getName().equals("create") || (params = m.getParameterTypes()).length != 2) continue;
                        boolean firstOk = params[0].isAssignableFrom(typed.getClass()) || params[0].isAssignableFrom(ITypedIngredient.class);
                        boolean secondOk = params[1].isAssignableFrom(ingredientManager.getClass());
                        if (!firstOk || !secondOk) continue;
                        createMethod = m;
                        break;
                    }
                    if (createMethod != null && (bookmark = createMethod.invoke(null, typed, ingredientManager)) != null) {
                        list.add((IBookmark)((IngredientBookmark)bookmark));
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    @Nullable
    private static Field getField(String clsName, Class<?> jeiCls) throws NoSuchFieldException {
        Field typeField = null;
        if ("mekanism.api.chemical.gas.GasStack".equals(clsName)) {
            typeField = jeiCls.getField("TYPE_GAS");
        } else if ("mekanism.api.chemical.infuse.InfusionStack".equals(clsName)) {
            typeField = jeiCls.getField("TYPE_INFUSION");
        } else if ("mekanism.api.chemical.pigment.PigmentStack".equals(clsName)) {
            typeField = jeiCls.getField("TYPE_PIGMENT");
        } else if ("mekanism.api.chemical.slurry.SlurryStack".equals(clsName)) {
            typeField = jeiCls.getField("TYPE_SLURRY");
        }
        return typeField;
    }

    public static void removeBookmark(ItemStack stack) {
        IJeiRuntime rt = RUNTIME;
        if (rt == null) {
            return;
        }
        IBookmarkOverlay overlay = rt.getBookmarkOverlay();
        if (overlay instanceof BookmarkOverlayAccessor) {
            BookmarkOverlayAccessor accessor = (BookmarkOverlayAccessor)overlay;
            BookmarkList list = accessor.eap$getBookmarkList();
            Optional typedOpt = rt.getIngredientManager().createTypedIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)stack);
            typedOpt.ifPresent(typed -> {
                IngredientBookmark bookmark = IngredientBookmark.create((ITypedIngredient)typed, (IIngredientManager)rt.getIngredientManager());
                list.remove((IBookmark)bookmark);
            });
        }
    }
}

