/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.mixin.ae2.compat;

import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.security.IActionSource;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.upgrades.UpgradeInventories;
import appeng.helpers.patternprovider.PatternProviderLogic;
import appeng.helpers.patternprovider.PatternProviderLogicHost;
import com.extendedae_plus.ae.items.ChannelCardItem;
import com.extendedae_plus.bridge.InterfaceWirelessLinkBridge;
import com.extendedae_plus.compat.UpgradeSlotCompat;
import com.extendedae_plus.init.ModItems;
import com.extendedae_plus.util.ExtendedAELogger;
import com.extendedae_plus.wireless.WirelessSlaveLink;
import com.extendedae_plus.wireless.endpoint.GenericNodeEndpointImpl;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PatternProviderLogic.class}, priority=500, remap=false)
public abstract class PatternProviderLogicCompatMixin
implements IUpgradeableObject,
InterfaceWirelessLinkBridge {
    @Unique
    private IUpgradeInventory eap$compatUpgrades = UpgradeInventories.empty();
    @Unique
    private WirelessSlaveLink eap$compatLink;
    @Unique
    private long eap$compatLastChannel = -1L;
    @Unique
    private boolean eap$compatClientConnected = false;
    @Unique
    private boolean eap$compatHasInitialized = false;
    @Unique
    private int eap$compatDelayedInitTicks = 0;
    @Final
    @Shadow
    private PatternProviderLogicHost host;
    @Final
    @Shadow
    private IManagedGridNode mainNode;
    @Final
    @Shadow
    private IActionSource actionSource;

    @Unique
    private void eap$compatOnUpgradesChanged() {
        try {
            this.host.saveChanges();
            if (UpgradeSlotCompat.shouldEnableChannelCard()) {
                this.eap$compatLastChannel = -1L;
                this.eap$compatHasInitialized = false;
                this.eap$compatInitializeChannelLink();
            }
        }
        catch (Exception e) {
            ExtendedAELogger.LOGGER.error("\u517c\u5bb9\u6027\u5347\u7ea7\u53d8\u66f4\u5904\u7406\u5931\u8d25", (Throwable)e);
        }
    }

    @Inject(method={"af_$onUpgradesChanged"}, at={@At(value="TAIL")}, remap=false, require=0)
    private void eap$onAppfluxUpgradesChanged(CallbackInfo ci) {
        try {
            if (UpgradeSlotCompat.shouldEnableChannelCard()) {
                this.eap$compatLastChannel = -1L;
                this.eap$compatHasInitialized = false;
                this.eap$compatInitializeChannelLink();
            }
        }
        catch (Exception e) {
            ExtendedAELogger.LOGGER.error("\u76d1\u542cappflux\u5347\u7ea7\u53d8\u5316\u5931\u8d25", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Inject(method={"<init>(Lappeng/api/networking/IManagedGridNode;Lappeng/helpers/patternprovider/PatternProviderLogicHost;I)V"}, at={@At(value="TAIL")})
    private void eap$compatInitUpgrades(IManagedGridNode mainNode, PatternProviderLogicHost host, int patternInventorySize, CallbackInfo ci) {
        try {
            boolean upgradeSlots = UpgradeSlotCompat.shouldEnableUpgradeSlots();
            boolean channelCard = UpgradeSlotCompat.shouldEnableChannelCard();
            if (upgradeSlots) {
                this.eap$compatUpgrades = UpgradeInventories.forMachine((ItemLike)host.getTerminalIcon().getItem(), (int)1, this::eap$compatOnUpgradesChanged);
                return;
            }
            if (!channelCard) return;
        }
        catch (Exception e) {
            ExtendedAELogger.LOGGER.error("\u517c\u5bb9\u6027\u5347\u7ea7\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
        }
    }

    @Inject(method={"writeToNBT"}, at={@At(value="TAIL")})
    private void eap$compatSaveUpgrades(CompoundTag tag, CallbackInfo ci) {
        try {
            if (UpgradeSlotCompat.shouldEnableUpgradeSlots() || UpgradeSlotCompat.shouldEnableChannelCard()) {
                this.eap$compatUpgrades.writeToNBT(tag, "compat_upgrades");
            }
        }
        catch (Exception e) {
            ExtendedAELogger.LOGGER.error("\u517c\u5bb9\u6027\u5347\u7ea7\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
        }
    }

    @Inject(method={"readFromNBT"}, at={@At(value="TAIL")})
    private void eap$compatLoadUpgrades(CompoundTag tag, CallbackInfo ci) {
        try {
            if (UpgradeSlotCompat.shouldEnableUpgradeSlots() || UpgradeSlotCompat.shouldEnableChannelCard()) {
                this.eap$compatUpgrades.readFromNBT(tag, "compat_upgrades");
                if (UpgradeSlotCompat.shouldEnableChannelCard()) {
                    this.eap$compatLastChannel = -1L;
                    this.eap$compatHasInitialized = false;
                    this.eap$compatInitializeChannelLink();
                }
            }
        }
        catch (Exception e) {
            ExtendedAELogger.LOGGER.error("\u517c\u5bb9\u6027\u5347\u7ea7\u52a0\u8f7d\u5931\u8d25", (Throwable)e);
        }
    }

    @Inject(method={"addDrops"}, at={@At(value="TAIL")})
    private void eap$compatDropUpgrades(List<ItemStack> drops, CallbackInfo ci) {
        try {
            if (UpgradeSlotCompat.shouldEnableUpgradeSlots() || UpgradeSlotCompat.shouldEnableChannelCard()) {
                for (ItemStack stack : this.eap$compatUpgrades) {
                    if (stack.m_41619_()) continue;
                    drops.add(stack);
                }
            }
        }
        catch (Exception e) {
            ExtendedAELogger.LOGGER.error("\u517c\u5bb9\u6027\u5347\u7ea7\u6389\u843d\u5931\u8d25", (Throwable)e);
        }
    }

    @Inject(method={"clearContent"}, at={@At(value="TAIL")})
    private void eap$compatClearUpgrades(CallbackInfo ci) {
        try {
            if (UpgradeSlotCompat.shouldEnableUpgradeSlots() || UpgradeSlotCompat.shouldEnableChannelCard()) {
                this.eap$compatUpgrades.clear();
            }
        }
        catch (Exception e) {
            ExtendedAELogger.LOGGER.error("\u517c\u5bb9\u6027\u5347\u7ea7\u6e05\u7406\u5931\u8d25", (Throwable)e);
        }
    }

    public IUpgradeInventory getUpgrades() {
        if (UpgradeSlotCompat.shouldEnableUpgradeSlots()) {
            return this.eap$compatUpgrades != null ? this.eap$compatUpgrades : UpgradeInventories.empty();
        }
        ExtendedAELogger.LOGGER.debug("\u88c5\u4e86appflux\u65f6getUpgrades\u88ab\u8c03\u7528\uff0c\u8fd9\u4e0d\u5e94\u8be5\u53d1\u751f");
        return UpgradeInventories.empty();
    }

    @Override
    public void eap$updateWirelessLink() {
        if (!UpgradeSlotCompat.shouldEnableChannelCard()) {
            return;
        }
        try {
            if (this.eap$compatLink != null) {
                this.eap$compatLink.updateStatus();
            }
        }
        catch (Exception e) {
            ExtendedAELogger.LOGGER.error("\u517c\u5bb9\u6027\u65e0\u7ebf\u94fe\u63a5\u66f4\u65b0\u5931\u8d25", (Throwable)e);
        }
    }

    @Unique
    public void eap$compatInitializeChannelLink() {
        if (!UpgradeSlotCompat.shouldEnableChannelCard()) {
            return;
        }
        try {
            if (this.host.getBlockEntity() != null && this.host.getBlockEntity().m_58904_() != null && this.host.getBlockEntity().m_58904_().f_46443_) {
                return;
            }
            if (this.eap$compatHasInitialized) {
                return;
            }
            if (!this.mainNode.hasGridBooted()) {
                this.eap$compatDelayedInitTicks = Math.max(this.eap$compatDelayedInitTicks, 5);
                try {
                    this.mainNode.ifPresent((grid, node) -> {
                        try {
                            grid.getTickManager().wakeDevice(node);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    });
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return;
            }
            long channel = 0L;
            boolean found = false;
            IUpgradeInventory upgrades = null;
            if (UpgradeSlotCompat.shouldEnableUpgradeSlots()) {
                upgrades = this.eap$compatUpgrades;
            } else if (UpgradeSlotCompat.shouldEnableChannelCard()) {
                try {
                    if (this instanceof IUpgradeableObject) {
                        PatternProviderLogicCompatMixin upgradeableThis = this;
                        upgrades = upgradeableThis.getUpgrades();
                        ExtendedAELogger.LOGGER.debug("\u4eceappflux\u83b7\u53d6\u5230\u5347\u7ea7\u69fd: {}", (Object)(upgrades != null ? 1 : 0));
                    }
                }
                catch (Exception e) {
                    ExtendedAELogger.LOGGER.error("\u83b7\u53d6appflux\u5347\u7ea7\u69fd\u5931\u8d25", (Throwable)e);
                }
            }
            if (upgrades != null) {
                for (ItemStack stack : upgrades) {
                    if (stack.m_41619_() || stack.m_41720_() != ModItems.CHANNEL_CARD.get()) continue;
                    channel = ChannelCardItem.getChannel(stack);
                    found = true;
                    break;
                }
            }
            if (!found) {
                if (this.eap$compatLink != null) {
                    this.eap$compatLink.setFrequency(0L);
                    this.eap$compatLink.updateStatus();
                }
                this.eap$compatHasInitialized = true;
                return;
            }
            if (this.eap$compatLink == null) {
                GenericNodeEndpointImpl endpoint = new GenericNodeEndpointImpl(() -> this.host.getBlockEntity(), () -> this.mainNode.getNode());
                this.eap$compatLink = new WirelessSlaveLink(endpoint);
            }
            this.eap$compatLink.setFrequency(channel);
            this.eap$compatLink.updateStatus();
            if (this.eap$compatLink.isConnected()) {
                this.eap$compatHasInitialized = true;
            } else {
                this.eap$compatHasInitialized = false;
                this.eap$compatDelayedInitTicks = Math.max(this.eap$compatDelayedInitTicks, 5);
                try {
                    this.mainNode.ifPresent((grid, node) -> {
                        try {
                            grid.getTickManager().wakeDevice(node);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    });
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Exception e) {
            ExtendedAELogger.LOGGER.error("\u517c\u5bb9\u6027\u9891\u9053\u94fe\u63a5\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public void eap$setClientWirelessState(boolean connected) {
        if (UpgradeSlotCompat.shouldEnableChannelCard()) {
            this.eap$compatClientConnected = connected;
        }
    }

    @Override
    public boolean eap$isWirelessConnected() {
        if (!UpgradeSlotCompat.shouldEnableChannelCard()) {
            return false;
        }
        try {
            if (this.host.getBlockEntity() != null && this.host.getBlockEntity().m_58904_() != null && this.host.getBlockEntity().m_58904_().f_46443_) {
                return this.eap$compatClientConnected;
            }
            return this.eap$compatLink != null && this.eap$compatLink.isConnected();
        }
        catch (Exception e) {
            ExtendedAELogger.LOGGER.error("\u68c0\u67e5\u517c\u5bb9\u6027\u65e0\u7ebf\u8fde\u63a5\u72b6\u6001\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean eap$hasTickInitialized() {
        if (UpgradeSlotCompat.shouldEnableChannelCard()) {
            return this.eap$compatHasInitialized;
        }
        return true;
    }

    @Override
    public void eap$setTickInitialized(boolean initialized) {
        if (UpgradeSlotCompat.shouldEnableChannelCard()) {
            this.eap$compatHasInitialized = initialized;
        }
    }

    @Override
    public void eap$handleDelayedInit() {
        if (!UpgradeSlotCompat.shouldEnableChannelCard()) {
            return;
        }
        try {
            if (this.host.getBlockEntity() != null && this.host.getBlockEntity().m_58904_() != null && this.host.getBlockEntity().m_58904_().f_46443_) {
                return;
            }
            if (!this.eap$compatHasInitialized) {
                if (!this.mainNode.hasGridBooted()) {
                    if (this.eap$compatDelayedInitTicks > 0) {
                        --this.eap$compatDelayedInitTicks;
                    }
                    if (this.eap$compatDelayedInitTicks == 0) {
                        this.eap$compatDelayedInitTicks = 5;
                        try {
                            this.mainNode.ifPresent((grid, node) -> {
                                try {
                                    grid.getTickManager().wakeDevice(node);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            });
                        }
                        catch (Throwable throwable) {}
                    }
                } else {
                    this.eap$compatInitializeChannelLink();
                }
            }
        }
        catch (Exception e) {
            ExtendedAELogger.LOGGER.error("\u517c\u5bb9\u6027\u5ef6\u8fdf\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
        }
    }

    @Inject(method={"onMainNodeStateChanged"}, at={@At(value="TAIL")})
    private void eap$compatOnMainNodeStateChangedTail(CallbackInfo ci) {
        if (!UpgradeSlotCompat.shouldEnableChannelCard()) {
            return;
        }
        try {
            this.eap$compatLastChannel = -1L;
            this.eap$compatHasInitialized = false;
            this.eap$compatDelayedInitTicks = 10;
            try {
                this.mainNode.ifPresent((grid, node) -> {
                    try {
                        grid.getTickManager().wakeDevice(node);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                });
            }
            catch (Throwable throwable) {}
        }
        catch (Exception e) {
            ExtendedAELogger.LOGGER.error("\u517c\u5bb9\u6027\u4e3b\u8282\u70b9\u72b6\u6001\u53d8\u66f4\u5904\u7406\u5931\u8d25", (Throwable)e);
        }
    }
}

