/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.network;

import appeng.api.crafting.IPatternDetails;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingService;
import appeng.api.networking.security.IActionHost;
import appeng.api.stacks.AEKey;
import appeng.helpers.patternprovider.PatternProviderLogic;
import appeng.helpers.patternprovider.PatternProviderLogicHost;
import appeng.me.service.CraftingService;
import appeng.menu.me.crafting.CraftingCPUMenu;
import com.extendedae_plus.mixin.ae2.accessor.PatternProviderLogicAccessor;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;

public class CraftingMonitorJumpC2SPacket {
    private final AEKey what;

    public CraftingMonitorJumpC2SPacket(AEKey what) {
        this.what = what;
    }

    public static void encode(CraftingMonitorJumpC2SPacket msg, FriendlyByteBuf buf) {
        AEKey.writeKey((FriendlyByteBuf)buf, (AEKey)msg.what);
    }

    public static CraftingMonitorJumpC2SPacket decode(FriendlyByteBuf buf) {
        AEKey key = AEKey.readKey((FriendlyByteBuf)buf);
        return new CraftingMonitorJumpC2SPacket(key);
    }

    public static void handle(CraftingMonitorJumpC2SPacket msg, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            IActionHost host;
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            AbstractContainerMenu patt0$temp = player.f_36096_;
            if (!(patt0$temp instanceof CraftingCPUMenu)) {
                return;
            }
            CraftingCPUMenu menu = (CraftingCPUMenu)patt0$temp;
            IGrid grid = null;
            Object target = menu.getTarget();
            if (target instanceof IActionHost && (host = (IActionHost)target).getActionableNode() != null) {
                grid = host.getActionableNode().getGrid();
            }
            if (grid == null) {
                return;
            }
            ICraftingService cs = grid.getCraftingService();
            if (!(cs instanceof CraftingService)) {
                return;
            }
            CraftingService craftingService = (CraftingService)cs;
            Collection patterns = craftingService.getCraftingFor(msg.what);
            if (patterns.isEmpty()) {
                return;
            }
            for (IPatternDetails pattern : patterns) {
                Iterable providers = craftingService.getProviders(pattern);
                int providerCount = 0;
                for (ICraftingProvider provider : providers) {
                    BlockHitResult hit;
                    BlockState state2;
                    InteractionResult r;
                    Direction d;
                    Object targetPos;
                    PatternProviderLogic ppl;
                    PatternProviderLogicHost host2;
                    ++providerCount;
                    if (!(provider instanceof PatternProviderLogic) || (host2 = ((PatternProviderLogicAccessor)(ppl = (PatternProviderLogic)provider)).eap$host()) == null) continue;
                    BlockEntity pbe = host2.getBlockEntity();
                    ServerLevel serverLevel = player.m_284548_();
                    for (Direction dir : host2.getTargets()) {
                        targetPos = pbe.m_58899_().m_121945_(dir);
                        BlockEntity tbe = serverLevel.m_7702_((BlockPos)targetPos);
                        if (tbe instanceof MenuProvider) {
                            MenuProvider provider1 = (MenuProvider)tbe;
                            NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)provider1, (BlockPos)targetPos);
                            context.setPacketHandled(true);
                            return;
                        }
                        BlockState tstate = serverLevel.m_8055_((BlockPos)targetPos);
                        MenuProvider provider2 = tstate.m_60750_((Level)serverLevel, (BlockPos)targetPos);
                        if (provider2 == null) continue;
                        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)provider2, (BlockPos)targetPos);
                        context.setPacketHandled(true);
                        return;
                    }
                    InteractionHand hand = player.m_21205_().m_41619_() ? InteractionHand.MAIN_HAND : InteractionHand.MAIN_HAND;
                    Direction chosen = null;
                    targetPos = host2.getTargets().iterator();
                    while (targetPos.hasNext()) {
                        d = (Direction)targetPos.next();
                        if (serverLevel.m_7702_(pbe.m_58899_().m_121945_(d)) == null) continue;
                        chosen = d;
                        break;
                    }
                    if (chosen == null) {
                        targetPos = host2.getTargets().iterator();
                        while (targetPos.hasNext()) {
                            d = (Direction)targetPos.next();
                            if (serverLevel.m_8055_(pbe.m_58899_().m_121945_(d)).m_60795_()) continue;
                            chosen = d;
                            break;
                        }
                    }
                    if (chosen == null || !(r = (state2 = serverLevel.m_8055_((BlockPos)(targetPos = pbe.m_58899_().m_121945_(chosen)))).m_60664_((Level)serverLevel, (Player)player, hand, hit = new BlockHitResult(Vec3.m_82512_((Vec3i)targetPos), chosen.m_122424_(), (BlockPos)targetPos, false))).m_19077_()) continue;
                    context.setPacketHandled(true);
                    return;
                }
            }
        });
        context.setPacketHandled(true);
    }
}

