/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.network;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;

public class OpenProviderUiC2SPacket {
    private final long posLong;
    private final ResourceLocation dimId;
    private final int faceOrd;

    public OpenProviderUiC2SPacket(long posLong, ResourceLocation dimId, int faceOrd) {
        this.posLong = posLong;
        this.dimId = dimId;
        this.faceOrd = faceOrd;
    }

    public static void encode(OpenProviderUiC2SPacket msg, FriendlyByteBuf buf) {
        buf.writeLong(msg.posLong);
        buf.m_130085_(msg.dimId);
        buf.m_130130_(msg.faceOrd);
    }

    public static OpenProviderUiC2SPacket decode(FriendlyByteBuf buf) {
        long posLong = buf.readLong();
        ResourceLocation dimId = buf.m_130281_();
        int faceOrd = buf.m_130242_();
        return new OpenProviderUiC2SPacket(posLong, dimId, faceOrd);
    }

    public static void handle(OpenProviderUiC2SPacket msg, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            boolean anyHandEmpty;
            Direction[] tries;
            Direction[] directionArray;
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            ResourceKey levelKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)msg.dimId);
            ServerLevel level = player.f_8924_.m_129880_(levelKey);
            if (level == null) {
                return;
            }
            BlockPos pos = BlockPos.m_122022_((long)msg.posLong);
            if (!level.m_46749_(pos)) {
                return;
            }
            BlockEntity be = level.m_7702_(pos);
            BlockState stateAtPos = level.m_8055_(pos);
            if (msg.faceOrd >= 0 && msg.faceOrd < Direction.values().length) {
                Direction[] directionArray2 = new Direction[1];
                directionArray = directionArray2;
                directionArray2[0] = Direction.values()[msg.faceOrd];
            } else {
                directionArray = Direction.values();
            }
            for (Direction dir : tries = directionArray) {
                BlockPos targetPos = pos.m_121945_(dir);
                BlockEntity tbe = level.m_7702_(targetPos);
                if (tbe instanceof MenuProvider) {
                    MenuProvider provider = (MenuProvider)tbe;
                    NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)provider, (BlockPos)targetPos);
                    return;
                }
                BlockState tstate = level.m_8055_(targetPos);
                MenuProvider provider2 = tstate.m_60750_((Level)level, targetPos);
                if (provider2 == null) continue;
                NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)provider2, (BlockPos)targetPos);
                return;
            }
            boolean bl = anyHandEmpty = player.m_21205_().m_41619_() || player.m_21206_().m_41619_();
            if (anyHandEmpty) {
                InteractionHand hand;
                InteractionHand interactionHand = hand = player.m_21205_().m_41619_() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
                if (msg.faceOrd >= 0 && msg.faceOrd < Direction.values().length) {
                    BlockHitResult hit2;
                    Direction dir = Direction.values()[msg.faceOrd];
                    targetPos = pos.m_121945_(dir);
                    BlockState state2 = level.m_8055_(targetPos);
                    r = state2.m_60664_((Level)level, (Player)player, hand, hit2 = new BlockHitResult(Vec3.m_82512_((Vec3i)targetPos), dir.m_122424_(), targetPos, false));
                    if (r.m_19077_()) {
                        return;
                    }
                } else {
                    BlockHitResult hit;
                    BlockPos d;
                    int hit2;
                    BlockPos chosen = null;
                    targetPos = Direction.values();
                    int state2 = ((Direction[])targetPos).length;
                    for (hit2 = 0; hit2 < state2; ++hit2) {
                        d = targetPos[hit2];
                        if (level.m_7702_(pos.m_121945_((Direction)d)) == null) continue;
                        chosen = d;
                        break;
                    }
                    if (chosen == null) {
                        targetPos = Direction.values();
                        state2 = ((Direction[])targetPos).length;
                        for (hit2 = 0; hit2 < state2; ++hit2) {
                            d = targetPos[hit2];
                            if (level.m_8055_(pos.m_121945_((Direction)d)).m_60795_()) continue;
                            chosen = d;
                            break;
                        }
                    }
                    if (chosen != null && (r = (state2 = level.m_8055_(targetPos = pos.m_121945_(chosen))).m_60664_((Level)level, (Player)player, hand, hit = new BlockHitResult(Vec3.m_82512_((Vec3i)targetPos), chosen.m_122424_(), targetPos, false))).m_19077_()) {
                        return;
                    }
                }
            }
            context.setPacketHandled(true);
        });
    }
}

