/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.network;

import appeng.helpers.patternprovider.PatternContainer;
import appeng.menu.implementations.PatternAccessTermMenu;
import appeng.menu.me.items.PatternEncodingTermMenu;
import com.extendedae_plus.init.ModNetwork;
import com.extendedae_plus.network.ProvidersListS2CPacket;
import com.extendedae_plus.util.ExtendedAEPatternUploadUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class RequestProvidersListC2SPacket {
    public static void encode(RequestProvidersListC2SPacket msg, FriendlyByteBuf buf) {
    }

    public static RequestProvidersListC2SPacket decode(FriendlyByteBuf buf) {
        return new RequestProvidersListC2SPacket();
    }

    public static void handle(RequestProvidersListC2SPacket msg, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer player = ctx.getSender();
            if (player == null) {
                return;
            }
            AbstractContainerMenu patt0$temp = player.f_36096_;
            if (!(patt0$temp instanceof PatternEncodingTermMenu)) {
                return;
            }
            PatternEncodingTermMenu encMenu = (PatternEncodingTermMenu)patt0$temp;
            PatternAccessTermMenu accessMenu = ExtendedAEPatternUploadUtil.getPatternAccessMenu(player);
            if (accessMenu != null) {
                List<Long> ids = ExtendedAEPatternUploadUtil.getAllProviderIds(accessMenu);
                ArrayList<Long> filteredIds = new ArrayList<Long>();
                ArrayList<String> names = new ArrayList<String>();
                ArrayList<Integer> slots = new ArrayList<Integer>();
                for (Long id : ids) {
                    int empty;
                    if (id == null || !ExtendedAEPatternUploadUtil.isProviderAvailable(id, accessMenu) || (empty = ExtendedAEPatternUploadUtil.getAvailableSlots(id, accessMenu)) <= 0) continue;
                    filteredIds.add(id);
                    names.add(ExtendedAEPatternUploadUtil.getProviderDisplayName(id, accessMenu));
                    slots.add(empty);
                }
                ModNetwork.CHANNEL.sendTo((Object)new ProvidersListS2CPacket(filteredIds, names, slots), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                return;
            }
            List<PatternContainer> containers = ExtendedAEPatternUploadUtil.listAvailableProvidersFromGrid(encMenu);
            ArrayList<Long> idxIds = new ArrayList<Long>();
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<Integer> slots = new ArrayList<Integer>();
            for (int i = 0; i < containers.size(); ++i) {
                int empty;
                PatternContainer c = containers.get(i);
                if (c == null || (empty = ExtendedAEPatternUploadUtil.getAvailableSlots(c)) <= 0) continue;
                long encodedId = -1L - (long)i;
                idxIds.add(encodedId);
                names.add(ExtendedAEPatternUploadUtil.getProviderDisplayName(c));
                slots.add(empty);
            }
            ModNetwork.CHANNEL.sendTo((Object)new ProvidersListS2CPacket(idxIds, names, slots), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        });
        ctx.setPacketHandled(true);
    }
}

