/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class ConfigParsingUtils {
    private static volatile List<Pattern> cachedBlacklist = null;
    private static volatile List<MultiplierEntry> cachedMultiplierEntries = null;
    private static final Object CACHE_LOCK = new Object();

    private ConfigParsingUtils() {
    }

    public static Pattern compilePattern(String raw) {
        if (raw == null) {
            throw new IllegalArgumentException("pattern is null");
        }
        if ((raw = raw.trim()).isEmpty()) {
            throw new IllegalArgumentException("pattern is empty");
        }
        if (raw.contains(".*") || raw.matches(".*[\\[\\(\\+\\{\\\\].*")) {
            try {
                return Pattern.compile("^" + raw + "$");
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        if (raw.contains("*") || raw.contains("?")) {
            StringBuilder sb = new StringBuilder();
            sb.append('^');
            block6: for (char c : raw.toCharArray()) {
                switch (c) {
                    case '*': {
                        sb.append(".*");
                        continue block6;
                    }
                    case '?': {
                        sb.append('.');
                        continue block6;
                    }
                    default: {
                        if (".\\+[]{}()^$|".indexOf(c) >= 0) {
                            sb.append('\\');
                        }
                        sb.append(c);
                    }
                }
            }
            sb.append('$');
            return Pattern.compile(sb.toString());
        }
        return Pattern.compile("^" + Pattern.quote(raw) + "$");
    }

    public static MultiplierEntry parseMultiplierEntry(String entry) {
        double m;
        if (entry == null) {
            return null;
        }
        String[] parts = entry.trim().split("\\s+");
        if (parts.length < 2) {
            return null;
        }
        String key = parts[0];
        String val = parts[1].toLowerCase();
        if (val.endsWith("x")) {
            val = val.substring(0, val.length() - 1);
        }
        try {
            m = Double.parseDouble(val);
        }
        catch (NumberFormatException ex) {
            return null;
        }
        try {
            Pattern p = ConfigParsingUtils.compilePattern(key);
            return new MultiplierEntry(p, m);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static List<Pattern> compilePatterns(List<? extends String> raw) {
        ArrayList<Pattern> out = new ArrayList<Pattern>();
        if (raw == null) {
            return out;
        }
        for (String string : raw) {
            if (string == null || string.isBlank()) continue;
            try {
                out.add(ConfigParsingUtils.compilePattern(string));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return out;
    }

    public static List<MultiplierEntry> parseMultiplierList(List<? extends String> raw) {
        ArrayList<MultiplierEntry> out = new ArrayList<MultiplierEntry>();
        if (raw == null) {
            return out;
        }
        for (String string : raw) {
            MultiplierEntry me = ConfigParsingUtils.parseMultiplierEntry(string);
            if (me == null) continue;
            out.add(me);
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Pattern> getCachedBlacklist(List<? extends String> source) {
        if (cachedBlacklist == null) {
            Object object = CACHE_LOCK;
            synchronized (object) {
                if (cachedBlacklist == null) {
                    cachedBlacklist = ConfigParsingUtils.compilePatterns(source);
                }
            }
        }
        return List.copyOf(cachedBlacklist);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<MultiplierEntry> getCachedMultiplierEntries(List<? extends String> source) {
        if (cachedMultiplierEntries == null) {
            Object object = CACHE_LOCK;
            synchronized (object) {
                if (cachedMultiplierEntries == null) {
                    cachedMultiplierEntries = ConfigParsingUtils.parseMultiplierList(source);
                }
            }
        }
        return List.copyOf(cachedMultiplierEntries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reload() {
        Object object = CACHE_LOCK;
        synchronized (object) {
            cachedBlacklist = null;
            cachedMultiplierEntries = null;
        }
    }

    public static final class MultiplierEntry {
        public final Pattern pattern;
        public final double multiplier;

        public MultiplierEntry(Pattern pattern, double multiplier) {
            this.pattern = pattern;
            this.multiplier = multiplier;
        }
    }
}

