/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.util;

import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.implementations.blockentities.PatternContainerGroup;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.core.definitions.AEItems;
import appeng.crafting.pattern.AECraftingPattern;
import appeng.crafting.pattern.AESmithingTablePattern;
import appeng.crafting.pattern.AEStonecuttingPattern;
import appeng.helpers.patternprovider.PatternContainer;
import appeng.menu.implementations.PatternAccessTermMenu;
import appeng.menu.me.items.PatternEncodingTermMenu;
import appeng.menu.slot.RestrictedInputSlot;
import appeng.util.inv.FilteredInternalInventory;
import appeng.util.inv.filter.IAEItemFilter;
import com.extendedae_plus.content.matrix.UploadCoreBlockEntity;
import com.extendedae_plus.mixin.ae2.accessor.PatternEncodingTermMenuAccessor;
import com.glodblock.github.extendedae.common.tileentities.matrix.TileAssemblerMatrixBase;
import com.glodblock.github.extendedae.common.tileentities.matrix.TileAssemblerMatrixPattern;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.items.IItemHandler;

public class ExtendedAEPatternUploadUtil {
    private static final String CONFIG_RELATIVE = "extendedae_plus/recipe_type_names.json";
    private static final Map<ResourceLocation, String> CUSTOM_NAMES = new ConcurrentHashMap<ResourceLocation, String>();
    private static final Map<String, String> CUSTOM_ALIASES = new ConcurrentHashMap<String, String>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static volatile String lastProcessingName;

    public static synchronized void loadRecipeTypeNames() {
        try {
            Path cfgDir = FMLPaths.CONFIGDIR.get();
            Path cfgPath = cfgDir.resolve(CONFIG_RELATIVE);
            if (!Files.exists(cfgPath, new LinkOption[0])) {
                Files.createDirectories(cfgPath.getParent(), new FileAttribute[0]);
                JsonObject tmpl = new JsonObject();
                tmpl.addProperty("minecraft:smelting", "\u7194\u7089");
                tmpl.addProperty("minecraft:blasting", "\u9ad8\u7089");
                tmpl.addProperty("minecraft:smoking", "\u70df\u718f");
                tmpl.addProperty("minecraft:campfire_cooking", "\u8425\u706b");
                tmpl.addProperty("gtceu:assembler", "\u7ec4\u88c5\u673a");
                tmpl.addProperty("gtceu:arc_furnace", "\u7535\u5f27\u7089");
                tmpl.addProperty("gtceu:chemical_reactor", "\u5316\u5b66\u53cd\u5e94\u5668");
                tmpl.addProperty("assembler", "\u7ec4\u88c5\u673a");
                Files.writeString(cfgPath, (CharSequence)GSON.toJson((JsonElement)tmpl), new OpenOption[0]);
            }
            String json = Files.readString(cfgPath);
            JsonObject obj = (JsonObject)GSON.fromJson(json, JsonObject.class);
            HashMap<ResourceLocation, String> map = new HashMap<ResourceLocation, String>();
            HashMap<String, String> alias = new HashMap<String, String>();
            if (obj != null) {
                for (Map.Entry e : obj.entrySet()) {
                    String name;
                    String k = (String)e.getKey();
                    JsonElement v = (JsonElement)e.getValue();
                    if (v == null || !v.isJsonPrimitive() || (name = v.getAsString()) == null || name.isBlank()) continue;
                    if (k.contains(":")) {
                        try {
                            ResourceLocation rl = new ResourceLocation(k);
                            map.put(rl, name);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    alias.put(k.toLowerCase(), name);
                }
            }
            CUSTOM_NAMES.clear();
            CUSTOM_NAMES.putAll(map);
            CUSTOM_ALIASES.clear();
            CUSTOM_ALIASES.putAll(alias);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void setLastProcessingName(String name) {
        lastProcessingName = name;
    }

    public static synchronized boolean addOrUpdateAliasMapping(String aliasKey, String cnValue) {
        if (aliasKey == null || aliasKey.isBlank() || cnValue == null || cnValue.isBlank()) {
            return false;
        }
        try {
            JsonObject obj;
            Path cfgDir = FMLPaths.CONFIGDIR.get();
            Path cfgPath = cfgDir.resolve(CONFIG_RELATIVE);
            if (!Files.exists(cfgPath, new LinkOption[0])) {
                ExtendedAEPatternUploadUtil.loadRecipeTypeNames();
            }
            if (Files.exists(cfgPath, new LinkOption[0])) {
                String json = Files.readString(cfgPath);
                obj = (JsonObject)GSON.fromJson(json, JsonObject.class);
                if (obj == null) {
                    obj = new JsonObject();
                }
            } else {
                obj = new JsonObject();
            }
            String key = aliasKey.trim();
            obj.addProperty(key, cnValue);
            Files.createDirectories(cfgPath.getParent(), new FileAttribute[0]);
            Files.writeString(cfgPath, (CharSequence)GSON.toJson((JsonElement)obj), new OpenOption[0]);
            if (key.contains(":")) {
                try {
                    ResourceLocation rl = new ResourceLocation(key);
                    CUSTOM_NAMES.put(rl, cnValue);
                }
                catch (Exception exception) {}
            } else {
                CUSTOM_ALIASES.put(key.toLowerCase(), cnValue);
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static synchronized int removeMappingsByCnValue(String cnValue) {
        if (cnValue == null) {
            return 0;
        }
        String target = cnValue.trim();
        if (target.isEmpty()) {
            return 0;
        }
        try {
            Path cfgDir = FMLPaths.CONFIGDIR.get();
            Path cfgPath = cfgDir.resolve(CONFIG_RELATIVE);
            if (!Files.exists(cfgPath, new LinkOption[0])) {
                return 0;
            }
            String json = Files.readString(cfgPath);
            JsonObject obj = (JsonObject)GSON.fromJson(json, JsonObject.class);
            if (obj == null) {
                return 0;
            }
            ArrayList<String> toRemove = new ArrayList<String>();
            for (Map.Entry e : obj.entrySet()) {
                String name;
                JsonElement v = (JsonElement)e.getValue();
                if (v == null || !v.isJsonPrimitive() || !target.equals(name = v.getAsString())) continue;
                toRemove.add((String)e.getKey());
            }
            if (toRemove.isEmpty()) {
                return 0;
            }
            for (String k : toRemove) {
                obj.remove(k);
            }
            Files.createDirectories(cfgPath.getParent(), new FileAttribute[0]);
            Files.writeString(cfgPath, (CharSequence)GSON.toJson((JsonElement)obj), new OpenOption[0]);
            for (String k : toRemove) {
                String cur;
                if (k.contains(":")) {
                    try {
                        ResourceLocation rl = new ResourceLocation(k);
                        cur = CUSTOM_NAMES.get(rl);
                        if (!target.equals(cur)) continue;
                        CUSTOM_NAMES.remove(rl);
                    }
                    catch (Exception rl) {}
                    continue;
                }
                String lower = k.toLowerCase();
                cur = CUSTOM_ALIASES.get(lower);
                if (!target.equals(cur)) continue;
                CUSTOM_ALIASES.remove(lower);
            }
            return toRemove.size();
        }
        catch (IOException e) {
            return 0;
        }
    }

    public static String mapRecipeTypeToCn(Recipe<?> recipe) {
        String path;
        if (recipe == null) {
            return null;
        }
        RecipeType type = recipe.m_6671_();
        ResourceLocation key = BuiltInRegistries.f_256990_.m_7981_((Object)type);
        if (key == null) {
            return null;
        }
        String custom = CUSTOM_NAMES.get(key);
        if (custom != null && !custom.isBlank()) {
            return custom;
        }
        String id = key.toString();
        switch (path = key.m_135815_()) {
            case "smelting": {
                return "\u7194\u7089";
            }
            case "blasting": {
                return "\u9ad8\u7089";
            }
            case "smoking": {
                return "\u70df\u718f";
            }
            case "campfire_cooking": {
                return "\u8425\u706b";
            }
        }
        return id;
    }

    public static String mapRecipeTypeToSearchKey(Recipe<?> recipe) {
        if (recipe == null) {
            return null;
        }
        RecipeType type = recipe.m_6671_();
        ResourceLocation key = BuiltInRegistries.f_256990_.m_7981_((Object)type);
        if (key == null) {
            return null;
        }
        String alias = CUSTOM_ALIASES.get(key.m_135815_().toLowerCase());
        if (alias != null && !alias.isBlank()) {
            return alias;
        }
        String custom = CUSTOM_NAMES.get(key);
        if (custom != null && !custom.isBlank()) {
            return custom;
        }
        return key.m_135815_();
    }

    public static String mapGTCEuRecipeToSearchKey(GTRecipe gtRecipe) {
        if (gtRecipe == null) {
            return null;
        }
        try {
            String alias;
            String idStr = String.valueOf(gtRecipe.getType());
            if (idStr == null || idStr.isBlank()) {
                return null;
            }
            ResourceLocation rl = new ResourceLocation(idStr);
            String path = rl.m_135815_();
            if (path != null && (alias = CUSTOM_ALIASES.get(path.toLowerCase())) != null && !alias.isBlank()) {
                return alias;
            }
            String custom = CUSTOM_NAMES.get(rl);
            if (custom != null && !custom.isBlank()) {
                return custom;
            }
            return path != null && !path.isBlank() ? path : idStr;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static String mapGTCEuRecipeToSearchKey(Object gtRecipeObj) {
        if (gtRecipeObj == null) {
            return null;
        }
        try {
            String alias;
            Method mGetType = gtRecipeObj.getClass().getMethod("getType", new Class[0]);
            Object typeObj = mGetType.invoke(gtRecipeObj, new Object[0]);
            String idStr = String.valueOf(typeObj);
            if (idStr == null || idStr.isBlank()) {
                return null;
            }
            ResourceLocation rl = new ResourceLocation(idStr);
            String path = rl.m_135815_();
            if (path != null && (alias = CUSTOM_ALIASES.get(path.toLowerCase())) != null && !alias.isBlank()) {
                return alias;
            }
            String custom = CUSTOM_NAMES.get(rl);
            if (custom != null && !custom.isBlank()) {
                return custom;
            }
            return path != null && !path.isBlank() ? path : idStr;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static String deriveSearchKeyFromUnknownRecipe(Object recipeBase) {
        if (recipeBase == null) {
            return null;
        }
        try {
            Object key;
            Class<?> cls = recipeBase.getClass();
            String simple = cls.getSimpleName();
            String pkg = cls.getName();
            String ns = null;
            String lower = pkg.toLowerCase();
            if (lower.contains("gtceu")) {
                ns = "gtceu";
            } else if (lower.contains("gregtech")) {
                ns = "gregtech";
            } else if (lower.contains("projecte")) {
                ns = "projecte";
            } else if (lower.contains("create")) {
                ns = "create";
            } else if (lower.contains("immersiveengineering")) {
                ns = "immersive";
            }
            String token = ExtendedAEPatternUploadUtil.toSearchToken(simple);
            if (ns != null && token != null && !token.isBlank()) {
                key = ns + " " + token;
            } else {
                Object object = key = token != null && !token.isBlank() ? token : ns;
            }
            if (key == null || ((String)key).isBlank()) {
                return null;
            }
            String alias = CUSTOM_ALIASES.get(((String)key).toLowerCase());
            return alias != null && !alias.isBlank() ? alias : key;
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    private static String toSearchToken(String simpleName) {
        if (simpleName == null || simpleName.isBlank()) {
            return null;
        }
        String s = simpleName.replaceAll("Recipe$", "").replaceAll("Recipes$", "").replaceAll("Category$", "").replaceAll("JEI$", "");
        s = s.replaceAll("(?<!^)([A-Z])", " $1").toLowerCase();
        s = s.trim();
        return s;
    }

    public static PatternAccessTermMenu getPatternAccessMenu(ServerPlayer player) {
        if (player == null || player.f_36096_ == null) {
            return null;
        }
        String containerClassName = player.f_36096_.getClass().getName();
        if (containerClassName.equals("com.glodblock.github.extendedae.container.ContainerExPatternTerminal")) {
            return (PatternAccessTermMenu)player.f_36096_;
        }
        if (player.f_36096_ instanceof PatternAccessTermMenu) {
            return (PatternAccessTermMenu)player.f_36096_;
        }
        return null;
    }

    public static boolean uploadFromEncodingMenuToMatrix(ServerPlayer player, PatternEncodingTermMenu menu) {
        List<IItemHandler> handlers;
        if (player == null || menu == null) {
            return false;
        }
        RestrictedInputSlot encodedSlot = ((PatternEncodingTermMenuAccessor)menu).eap$getEncodedPatternSlot();
        ItemStack stack = encodedSlot.m_7993_();
        if (stack.m_41619_() || !PatternDetailsHelper.isEncodedPattern((ItemStack)stack)) {
            ExtendedAEPatternUploadUtil.sendMessage(player, "ExtendedAE Plus: \u6ca1\u6709\u53ef\u4e0a\u4f20\u7684\u7f16\u7801\u6837\u677f");
            return false;
        }
        IPatternDetails details = PatternDetailsHelper.decodePattern((ItemStack)stack, (Level)player.m_9236_());
        if (!(details instanceof AECraftingPattern || details instanceof AESmithingTablePattern || details instanceof AEStonecuttingPattern)) {
            ExtendedAEPatternUploadUtil.sendMessage(player, "extendedae_plus.upload_to_matrix.fail");
            return false;
        }
        IGridNode node = menu.getNetworkNode();
        if (node == null) {
            ExtendedAEPatternUploadUtil.sendMessage(player, "ExtendedAE Plus: \u5f53\u524d\u4e0d\u5728\u6709\u6548\u7684 AE \u7f51\u7edc\u4e2d");
            return false;
        }
        IGrid grid = node.getGrid();
        if (grid == null) {
            ExtendedAEPatternUploadUtil.sendMessage(player, "ExtendedAE Plus: \u5f53\u524d\u4e0d\u5728\u6709\u6548\u7684 AE \u7f51\u7edc\u4e2d");
            return false;
        }
        if (ExtendedAEPatternUploadUtil.matrixContainsPattern(grid, stack)) {
            block21: {
                if (player != null) {
                    player.m_213846_((Component)Component.m_237113_((String)"ExtendedAE Plus: \u88c5\u914d\u77e9\u9635\u5df2\u5b58\u5728\u76f8\u540c\u6837\u677f\uff0c\u5df2\u8df3\u8fc7\u4e0a\u4f20\u5e76\u8fd4\u8fd8\u7a7a\u767d\u6837\u677f"));
                }
                try {
                    PatternEncodingTermMenuAccessor accessor = (PatternEncodingTermMenuAccessor)menu;
                    RestrictedInputSlot blankSlot = accessor.eap$getBlankPatternSlot();
                    ItemStack blanks = AEItems.BLANK_PATTERN.stack(stack.m_41613_());
                    if (blankSlot != null && blankSlot.m_5857_(blanks)) {
                        ItemStack remain = blankSlot.m_150659_(blanks);
                        if (!remain.m_41619_() && player != null) {
                            player.m_150109_().m_150076_(remain, false);
                        }
                    } else if (player != null) {
                        player.m_150109_().m_150076_(blanks, false);
                    }
                }
                catch (Throwable t) {
                    if (player == null) break block21;
                    player.m_150109_().m_150076_(AEItems.BLANK_PATTERN.stack(stack.m_41613_()), false);
                }
            }
            encodedSlot.m_5852_(ItemStack.f_41583_);
            return false;
        }
        List<InternalInventory> inventories = ExtendedAEPatternUploadUtil.findAllMatrixPatternInventories(grid);
        if (!inventories.isEmpty()) {
            for (int i = 0; i < inventories.size(); ++i) {
                ItemStack toInsert;
                InternalInventory inv = inventories.get(i);
                ItemStack remain = inv.addItems(toInsert = stack.m_41777_());
                if (remain.m_41613_() >= stack.m_41613_()) continue;
                int inserted = stack.m_41613_() - remain.m_41613_();
                stack.m_41774_(inserted);
                if (stack.m_41619_()) {
                    encodedSlot.m_5852_(ItemStack.f_41583_);
                }
                ExtendedAEPatternUploadUtil.sendMessage(player, "extendedae_plus.upload_to_matrix.success");
                return true;
            }
        }
        if (!(handlers = ExtendedAEPatternUploadUtil.findAllMatrixPatternHandlers(grid)).isEmpty()) {
            for (int i = 0; i < handlers.size(); ++i) {
                ItemStack toInsert;
                IItemHandler cap = handlers.get(i);
                ItemStack remain = ExtendedAEPatternUploadUtil.insertIntoAnySlot(cap, toInsert = stack.m_41777_());
                if (remain.m_41613_() >= stack.m_41613_()) continue;
                int inserted = stack.m_41613_() - remain.m_41613_();
                stack.m_41774_(inserted);
                if (stack.m_41619_()) {
                    encodedSlot.m_5852_(ItemStack.f_41583_);
                }
                ExtendedAEPatternUploadUtil.sendMessage(player, "extendedae_plus.upload_to_matrix.success");
                return true;
            }
        }
        if (inventories.isEmpty() && handlers.isEmpty()) {
            ExtendedAEPatternUploadUtil.sendMessage(player, "extendedae_plus.upload_to_matrix.fail_no_matrix");
        } else {
            ExtendedAEPatternUploadUtil.sendMessage(player, "extendedae_plus.upload_to_matrix.fail_full");
        }
        return false;
    }

    private static List<InternalInventory> findAllMatrixPatternInventories(IGrid grid) {
        ArrayList<InternalInventory> result = new ArrayList<InternalInventory>();
        try {
            Set tiles = grid.getMachines(TileAssemblerMatrixPattern.class);
            int idx = 0;
            for (TileAssemblerMatrixPattern tile : tiles) {
                FilteredInternalInventory inv;
                if (tile != null && tile.isFormed() && tile.getMainNode().isActive() && ExtendedAEPatternUploadUtil.clusterHasSingleUploadCore((TileAssemblerMatrixBase)tile) && (inv = tile.getExposedInventory()) != null) {
                    result.add((InternalInventory)inv);
                }
                ++idx;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    private static List<IItemHandler> findAllMatrixPatternHandlers(IGrid grid) {
        ArrayList<IItemHandler> result = new ArrayList<IItemHandler>();
        try {
            Set matrices = grid.getMachines(TileAssemblerMatrixBase.class);
            int idx = 0;
            for (TileAssemblerMatrixBase tile : matrices) {
                IItemHandler handler;
                LazyOptional capOpt;
                if (tile != null && tile.isFormed() && ExtendedAEPatternUploadUtil.clusterHasSingleUploadCore(tile) && (capOpt = tile.getCapability(ForgeCapabilities.ITEM_HANDLER, null)) != null && (handler = (IItemHandler)capOpt.orElse(null)) != null) {
                    result.add(handler);
                }
                ++idx;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    private static ItemStack insertIntoAnySlot(IItemHandler handler, ItemStack stack) {
        ItemStack remaining = stack.m_41777_();
        if (handler == null || remaining.m_41619_()) {
            return remaining;
        }
        for (int i = 0; i < handler.getSlots() && !(remaining = handler.insertItem(i, remaining, false)).m_41619_(); ++i) {
        }
        return remaining;
    }

    private static boolean matrixContainsPattern(IGrid grid, ItemStack pattern) {
        if (grid == null || pattern == null || pattern.m_41619_()) {
            return false;
        }
        try {
            List<InternalInventory> inventories = ExtendedAEPatternUploadUtil.findAllMatrixPatternInventories(grid);
            for (InternalInventory inv : inventories) {
                if (inv == null) continue;
                for (int i = 0; i < inv.size(); ++i) {
                    ItemStack s = inv.getStackInSlot(i);
                    if (s.m_41619_() || !ItemStack.m_150942_((ItemStack)s, (ItemStack)pattern)) continue;
                    return true;
                }
            }
        }
        catch (Throwable inventories) {
            // empty catch block
        }
        try {
            List<IItemHandler> handlers = ExtendedAEPatternUploadUtil.findAllMatrixPatternHandlers(grid);
            for (IItemHandler h : handlers) {
                if (h == null) continue;
                int slots = h.getSlots();
                for (int i = 0; i < slots; ++i) {
                    ItemStack s = h.getStackInSlot(i);
                    if (s.m_41619_() || !ItemStack.m_150942_((ItemStack)s, (ItemStack)pattern)) continue;
                    return true;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static boolean clusterHasSingleUploadCore(TileAssemblerMatrixBase any) {
        try {
            if (any == null || any.getCluster() == null) {
                return false;
            }
            int cores = 0;
            Iterator it = any.getCluster().getBlockEntities();
            while (it.hasNext()) {
                TileAssemblerMatrixBase te = (TileAssemblerMatrixBase)it.next();
                if (!(te instanceof UploadCoreBlockEntity)) continue;
                ++cores;
            }
            return cores >= 1;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean isExtendedAETerminal(ServerPlayer player) {
        if (player == null || player.f_36096_ == null) {
            return false;
        }
        String containerClassName = player.f_36096_.getClass().getName();
        return containerClassName.equals("com.glodblock.github.extendedae.container.ContainerExPatternTerminal");
    }

    public static boolean uploadPatternToProvider(ServerPlayer player, int playerSlotIndex, long providerId) {
        PatternAccessTermMenu menu = ExtendedAEPatternUploadUtil.getPatternAccessMenu(player);
        if (menu == null) {
            ExtendedAEPatternUploadUtil.sendMessage(player, "ExtendedAE Plus: \u8bf7\u5148\u6253\u5f00\u6837\u677f\u8bbf\u95ee\u7ec8\u7aef\u6216\u6269\u5c55\u6837\u677f\u7ba1\u7406\u7ec8\u7aef");
            return false;
        }
        ItemStack playerItem = player.m_150109_().m_8020_(playerSlotIndex);
        if (playerItem.m_41619_()) {
            ExtendedAEPatternUploadUtil.sendMessage(player, "ExtendedAE Plus: \u80cc\u5305\u69fd\u4f4d\u4e3a\u7a7a");
            return false;
        }
        if (!PatternDetailsHelper.isEncodedPattern((ItemStack)playerItem)) {
            ExtendedAEPatternUploadUtil.sendMessage(player, "ExtendedAE Plus: \u8be5\u7269\u54c1\u4e0d\u662f\u6709\u6548\u7684\u7f16\u7801\u6837\u677f");
            return false;
        }
        PatternContainer patternContainer = ExtendedAEPatternUploadUtil.getPatternContainerById(menu, providerId);
        if (patternContainer == null) {
            ExtendedAEPatternUploadUtil.sendMessage(player, "ExtendedAE Plus: \u627e\u4e0d\u5230\u6307\u5b9a\u7684\u6837\u677f\u4f9b\u5e94\u5668 (ID: " + providerId + ")");
            return false;
        }
        InternalInventory patternInventory = patternContainer.getTerminalPatternInventory();
        if (patternInventory == null) {
            ExtendedAEPatternUploadUtil.sendMessage(player, "ExtendedAE Plus: \u65e0\u6cd5\u8bbf\u95ee\u6837\u677f\u4f9b\u5e94\u5668\u7684\u5e93\u5b58");
            return false;
        }
        ExtendedAEPatternFilter patternFilter = new ExtendedAEPatternFilter();
        FilteredInternalInventory filteredInventory = new FilteredInternalInventory(patternInventory, (IAEItemFilter)patternFilter);
        ItemStack itemToInsert = playerItem.m_41777_();
        ItemStack remaining = filteredInventory.addItems(itemToInsert);
        if (remaining.m_41613_() < itemToInsert.m_41613_()) {
            int insertedCount = itemToInsert.m_41613_() - remaining.m_41613_();
            playerItem.m_41774_(insertedCount);
            if (playerItem.m_41619_()) {
                player.m_150109_().m_6836_(playerSlotIndex, ItemStack.f_41583_);
            }
            String terminalType = ExtendedAEPatternUploadUtil.isExtendedAETerminal(player) ? "\u6269\u5c55\u6837\u677f\u7ba1\u7406\u7ec8\u7aef" : "\u6837\u677f\u8bbf\u95ee\u7ec8\u7aef";
            ExtendedAEPatternUploadUtil.sendMessage(player, "ExtendedAE Plus: \u901a\u8fc7" + terminalType + "\u6210\u529f\u4e0a\u4f20 " + insertedCount + " \u4e2a\u6837\u677f");
            return true;
        }
        ExtendedAEPatternUploadUtil.sendMessage(player, "ExtendedAE Plus: \u4e0a\u4f20\u5931\u8d25 - \u6837\u677f\u4f9b\u5e94\u5668\u5df2\u6ee1\u6216\u6837\u677f\u65e0\u6548");
        return false;
    }

    public static int uploadMultiplePatterns(ServerPlayer player, int[] playerSlotIndices, long providerId) {
        int successCount = 0;
        for (int slotIndex : playerSlotIndices) {
            if (!ExtendedAEPatternUploadUtil.uploadPatternToProvider(player, slotIndex, providerId)) continue;
            ++successCount;
        }
        String terminalType = ExtendedAEPatternUploadUtil.isExtendedAETerminal(player) ? "\u6269\u5c55\u6837\u677f\u7ba1\u7406\u7ec8\u7aef" : "\u6837\u677f\u8bbf\u95ee\u7ec8\u7aef";
        ExtendedAEPatternUploadUtil.sendMessage(player, "ExtendedAE Plus: \u901a\u8fc7" + terminalType + "\u6279\u91cf\u4e0a\u4f20\u5b8c\u6210\uff0c\u6210\u529f\u4e0a\u4f20 " + successCount + " \u4e2a\u6837\u677f");
        return successCount;
    }

    public static boolean hasEnoughSlots(long providerId, PatternAccessTermMenu menu, int requiredSlots) {
        PatternContainer container = ExtendedAEPatternUploadUtil.getPatternContainerById(menu, providerId);
        if (container == null) {
            return false;
        }
        InternalInventory inventory = container.getTerminalPatternInventory();
        if (inventory == null) {
            return false;
        }
        int availableSlots = 0;
        for (int i = 0; i < inventory.size(); ++i) {
            if (!inventory.getStackInSlot(i).m_41619_() || ++availableSlots < requiredSlots) continue;
            return true;
        }
        return false;
    }

    public static int getAvailableSlots(long providerId, PatternAccessTermMenu menu) {
        PatternContainer container = ExtendedAEPatternUploadUtil.getPatternContainerById(menu, providerId);
        if (container == null) {
            return -1;
        }
        InternalInventory inventory = container.getTerminalPatternInventory();
        if (inventory == null) {
            return -1;
        }
        int availableSlots = 0;
        for (int i = 0; i < inventory.size(); ++i) {
            if (!inventory.getStackInSlot(i).m_41619_()) continue;
            ++availableSlots;
        }
        return availableSlots;
    }

    private static PatternContainer getPatternContainerById(PatternAccessTermMenu menu, long providerId) {
        try {
            Field byIdField = ExtendedAEPatternUploadUtil.findByIdField(menu.getClass());
            if (byIdField == null) {
                System.err.println("ExtendedAE Plus: \u65e0\u6cd5\u627e\u5230byId\u5b57\u6bb5");
                return null;
            }
            byIdField.setAccessible(true);
            Map byId = (Map)byIdField.get(menu);
            Object containerTracker = byId.get(providerId);
            if (containerTracker == null) {
                return null;
            }
            Field containerField = ExtendedAEPatternUploadUtil.findContainerField(containerTracker.getClass());
            if (containerField == null) {
                System.err.println("ExtendedAE Plus: \u65e0\u6cd5\u627e\u5230container\u5b57\u6bb5");
                return null;
            }
            containerField.setAccessible(true);
            return (PatternContainer)containerField.get(containerTracker);
        }
        catch (Exception e) {
            System.err.println("ExtendedAE Plus: \u65e0\u6cd5\u83b7\u53d6PatternContainer\uff0c\u9519\u8bef: " + e.getMessage());
            return null;
        }
    }

    private static Field findByIdField(Class<?> clazz) {
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            try {
                return currentClass.getDeclaredField("byId");
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        return null;
    }

    private static Field findContainerField(Class<?> clazz) {
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            try {
                return currentClass.getDeclaredField("container");
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        return null;
    }

    private static void sendMessage(ServerPlayer player, String message) {
    }

    public static String getProviderDisplayName(long providerId, PatternAccessTermMenu menu) {
        PatternContainer container = ExtendedAEPatternUploadUtil.getPatternContainerById(menu, providerId);
        if (container == null) {
            return "\u672a\u77e5\u4f9b\u5e94\u5668";
        }
        try {
            PatternContainerGroup group = container.getTerminalGroup();
            if (group != null) {
                return group.name().getString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "\u6837\u677f\u4f9b\u5e94\u5668 #" + providerId;
    }

    public static boolean isProviderAvailable(long providerId, PatternAccessTermMenu menu) {
        PatternContainer container = ExtendedAEPatternUploadUtil.getPatternContainerById(menu, providerId);
        if (container == null) {
            return false;
        }
        if (!container.isVisibleInTerminal()) {
            return false;
        }
        return container.getGrid() != null;
    }

    public static String getTerminalTypeDescription(ServerPlayer player) {
        if (ExtendedAEPatternUploadUtil.isExtendedAETerminal(player)) {
            return "ExtendedAE\u6269\u5c55\u6837\u677f\u7ba1\u7406\u7ec8\u7aef";
        }
        if (ExtendedAEPatternUploadUtil.getPatternAccessMenu(player) != null) {
            return "AE2\u6837\u677f\u8bbf\u95ee\u7ec8\u7aef";
        }
        return "\u672a\u77e5\u7ec8\u7aef\u7c7b\u578b";
    }

    public static boolean uploadFromEncodingMenuToAnyProvider(ServerPlayer player, PatternEncodingTermMenu menu) {
        if (player == null || menu == null) {
            return false;
        }
        RestrictedInputSlot encodedSlot = ((PatternEncodingTermMenuAccessor)menu).eap$getEncodedPatternSlot();
        ItemStack stack = encodedSlot.m_7993_();
        if (stack.m_41619_() || !PatternDetailsHelper.isEncodedPattern((ItemStack)stack)) {
            return false;
        }
        IGridNode node = menu.getNetworkNode();
        if (node == null) {
            return false;
        }
        IGrid grid = node.getGrid();
        if (grid == null) {
            return false;
        }
        try {
            for (Class machineClass : grid.getMachineClasses()) {
                if (!PatternContainer.class.isAssignableFrom(machineClass)) continue;
                Class containerClass = machineClass;
                for (PatternContainer container : grid.getActiveMachines(containerClass)) {
                    ItemStack toInsert;
                    FilteredInternalInventory filtered;
                    ItemStack remain;
                    InternalInventory inv;
                    if (container == null || !container.isVisibleInTerminal() || (inv = container.getTerminalPatternInventory()) == null || inv.size() <= 0) continue;
                    boolean hasEmpty = false;
                    for (int i = 0; i < inv.size(); ++i) {
                        if (!inv.getStackInSlot(i).m_41619_()) continue;
                        hasEmpty = true;
                        break;
                    }
                    if (!hasEmpty || (remain = (filtered = new FilteredInternalInventory(inv, (IAEItemFilter)new ExtendedAEPatternFilter())).addItems(toInsert = stack.m_41777_())).m_41613_() >= toInsert.m_41613_()) continue;
                    int inserted = toInsert.m_41613_() - remain.m_41613_();
                    stack.m_41774_(inserted);
                    if (stack.m_41619_()) {
                        encodedSlot.m_5852_(ItemStack.f_41583_);
                    } else {
                        encodedSlot.m_5852_(stack);
                    }
                    return true;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static boolean uploadFromEncodingMenuToProvider(ServerPlayer player, PatternEncodingTermMenu menu, long providerId) {
        if (player == null || menu == null) {
            return false;
        }
        RestrictedInputSlot encodedSlot = ((PatternEncodingTermMenuAccessor)menu).eap$getEncodedPatternSlot();
        ItemStack stack = encodedSlot.m_7993_();
        if (stack.m_41619_() || !PatternDetailsHelper.isEncodedPattern((ItemStack)stack)) {
            return false;
        }
        PatternAccessTermMenu accessMenu = ExtendedAEPatternUploadUtil.getPatternAccessMenu(player);
        if (accessMenu == null) {
            return false;
        }
        String targetName = ExtendedAEPatternUploadUtil.getProviderDisplayName(providerId, accessMenu);
        ArrayList<Long> tryIds = new ArrayList<Long>();
        tryIds.add(providerId);
        try {
            List<Long> all = ExtendedAEPatternUploadUtil.getAllProviderIds(accessMenu);
            for (Long id : all) {
                String name;
                if (id == null || id == providerId || (name = ExtendedAEPatternUploadUtil.getProviderDisplayName(id, accessMenu)) == null || !name.equals(targetName)) continue;
                tryIds.add(id);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (Long id : tryIds) {
            ItemStack toInsert;
            FilteredInternalInventory filtered;
            ItemStack remain;
            InternalInventory inv;
            PatternContainer c = ExtendedAEPatternUploadUtil.getPatternContainerById(accessMenu, id);
            if (c == null || !c.isVisibleInTerminal() || (inv = c.getTerminalPatternInventory()) == null || inv.size() <= 0 || (remain = (filtered = new FilteredInternalInventory(inv, (IAEItemFilter)new ExtendedAEPatternFilter())).addItems(toInsert = stack.m_41777_())).m_41613_() >= toInsert.m_41613_()) continue;
            int inserted = toInsert.m_41613_() - remain.m_41613_();
            stack.m_41774_(inserted);
            if (stack.m_41619_()) {
                encodedSlot.m_5852_(ItemStack.f_41583_);
            } else {
                encodedSlot.m_5852_(stack);
            }
            return true;
        }
        return false;
    }

    public static List<Long> getAllProviderIds(PatternAccessTermMenu menu) {
        ArrayList<Long> result = new ArrayList<Long>();
        if (menu == null) {
            return result;
        }
        try {
            Field byIdField = ExtendedAEPatternUploadUtil.findByIdField(menu.getClass());
            if (byIdField == null) {
                return result;
            }
            byIdField.setAccessible(true);
            Map byId = (Map)byIdField.get(menu);
            if (byId != null) {
                result.addAll(byId.keySet());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    public static List<PatternContainer> listAvailableProvidersFromGrid(PatternEncodingTermMenu menu) {
        ArrayList<PatternContainer> list = new ArrayList<PatternContainer>();
        if (menu == null) {
            return list;
        }
        try {
            IGridNode node = menu.getNetworkNode();
            if (node == null) {
                return list;
            }
            IGrid grid = node.getGrid();
            if (grid == null) {
                return list;
            }
            for (Class machineClass : grid.getMachineClasses()) {
                if (!PatternContainer.class.isAssignableFrom(machineClass)) continue;
                Class containerClass = machineClass;
                for (PatternContainer container : grid.getActiveMachines(containerClass)) {
                    InternalInventory inv;
                    if (container == null || !container.isVisibleInTerminal() || (inv = container.getTerminalPatternInventory()) == null || inv.size() <= 0) continue;
                    boolean hasEmpty = false;
                    for (int i = 0; i < inv.size(); ++i) {
                        if (!inv.getStackInSlot(i).m_41619_()) continue;
                        hasEmpty = true;
                        break;
                    }
                    if (!hasEmpty) continue;
                    list.add(container);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return list;
    }

    public static String getProviderDisplayName(PatternContainer container) {
        if (container == null) {
            return "\u672a\u77e5\u4f9b\u5e94\u5668";
        }
        try {
            PatternContainerGroup group = container.getTerminalGroup();
            if (group != null) {
                return group.name().getString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "\u6837\u677f\u4f9b\u5e94\u5668";
    }

    public static int getAvailableSlots(PatternContainer container) {
        if (container == null) {
            return -1;
        }
        InternalInventory inv = container.getTerminalPatternInventory();
        if (inv == null) {
            return -1;
        }
        int available = 0;
        for (int i = 0; i < inv.size(); ++i) {
            if (!inv.getStackInSlot(i).m_41619_()) continue;
            ++available;
        }
        return available;
    }

    public static boolean uploadFromEncodingMenuToProviderByIndex(ServerPlayer player, PatternEncodingTermMenu menu, int index) {
        if (player == null || menu == null || index < 0) {
            return false;
        }
        List<PatternContainer> list = ExtendedAEPatternUploadUtil.listAvailableProvidersFromGrid(menu);
        if (index >= list.size()) {
            return false;
        }
        PatternContainer container = list.get(index);
        if (container == null) {
            return false;
        }
        RestrictedInputSlot encodedSlot = ((PatternEncodingTermMenuAccessor)menu).eap$getEncodedPatternSlot();
        ItemStack stack = encodedSlot.m_7993_();
        if (stack.m_41619_() || !PatternDetailsHelper.isEncodedPattern((ItemStack)stack)) {
            return false;
        }
        String targetName = ExtendedAEPatternUploadUtil.getProviderDisplayName(container);
        ArrayList<PatternContainer> tryList = new ArrayList<PatternContainer>();
        tryList.add(container);
        try {
            for (PatternContainer c : list) {
                String name;
                if (c == null || c == container || (name = ExtendedAEPatternUploadUtil.getProviderDisplayName(c)) == null || !name.equals(targetName)) continue;
                tryList.add(c);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (PatternContainer c : tryList) {
            ItemStack toInsert;
            FilteredInternalInventory filtered;
            ItemStack remain;
            InternalInventory inv = c.getTerminalPatternInventory();
            if (inv == null || inv.size() <= 0 || (remain = (filtered = new FilteredInternalInventory(inv, (IAEItemFilter)new ExtendedAEPatternFilter())).addItems(toInsert = stack.m_41777_())).m_41613_() >= toInsert.m_41613_()) continue;
            int inserted = toInsert.m_41613_() - remain.m_41613_();
            stack.m_41774_(inserted);
            if (stack.m_41619_()) {
                encodedSlot.m_5852_(ItemStack.f_41583_);
            } else {
                encodedSlot.m_5852_(stack);
            }
            return true;
        }
        return false;
    }

    static {
        try {
            ExtendedAEPatternUploadUtil.loadRecipeTypeNames();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        lastProcessingName = null;
    }

    private static class ExtendedAEPatternFilter
    implements IAEItemFilter {
        private ExtendedAEPatternFilter() {
        }

        public boolean allowExtract(InternalInventory inv, int slot, int amount) {
            return true;
        }

        public boolean allowInsert(InternalInventory inv, int slot, ItemStack stack) {
            return !stack.m_41619_() && PatternDetailsHelper.isEncodedPattern((ItemStack)stack);
        }
    }
}

