/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.util;

import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.crafting.pattern.AEProcessingPattern;
import com.extendedae_plus.api.SmartDoublingAwarePattern;
import com.extendedae_plus.config.ModConfig;
import com.extendedae_plus.content.ScaledProcessingPattern;

public final class PatternScaler {
    private PatternScaler() {
    }

    public static ScaledProcessingPattern scale(AEProcessingPattern base, AEKey target, long requestedAmount) {
        long amt;
        int i;
        SmartDoublingAwarePattern aware;
        if (base == null) {
            throw new IllegalArgumentException("base");
        }
        if (target == null) {
            throw new IllegalArgumentException("target");
        }
        if (base instanceof SmartDoublingAwarePattern && !(aware = (SmartDoublingAwarePattern)base).eap$allowScaling()) {
            return null;
        }
        GenericStack[] baseOutputs = base.getOutputs();
        int targetOutIndex = -1;
        for (i = 0; i < baseOutputs.length; ++i) {
            GenericStack out = baseOutputs[i];
            if (out == null || target == null || out.what() == null || !out.what().equals(target)) continue;
            targetOutIndex = i;
            break;
        }
        if (targetOutIndex == -1) {
            for (i = 0; i < baseOutputs.length; ++i) {
                if (baseOutputs[i] == null) continue;
                targetOutIndex = i;
                break;
            }
        }
        if (targetOutIndex == -1 && baseOutputs.length > 0) {
            targetOutIndex = 0;
        }
        long perOperationTarget = 1L;
        if (targetOutIndex >= 0 && baseOutputs[targetOutIndex] != null && (amt = baseOutputs[targetOutIndex].amount()) > 0L) {
            perOperationTarget = amt;
        }
        long multiplier = 1L;
        if (requestedAmount > 0L) {
            long needed = requestedAmount / perOperationTarget + (long)(requestedAmount % perOperationTarget == 0L ? 0 : 1);
            multiplier = needed <= 1L ? 1L : needed;
        }
        try {
            int minBenefit = ModConfig.INSTANCE.smartScalingMinBenefitFactor;
            if (minBenefit > 1 && requestedAmount > 0L && requestedAmount < perOperationTarget * (long)minBenefit) {
                return null;
            }
        }
        catch (Throwable minBenefit) {
            // empty catch block
        }
        try {
            int maxMul = ModConfig.INSTANCE.smartScalingMaxMultiplier;
            if (maxMul > 0 && multiplier > (long)maxMul) {
                multiplier = maxMul;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new ScaledProcessingPattern(base, base.getDefinition(), multiplier);
    }
}

