/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.util;

import appeng.menu.implementations.UpgradeableMenu;
import com.extendedae_plus.ae.definitions.upgrades.EntitySpeedCardItem;
import com.extendedae_plus.config.ModConfig;
import java.util.ArrayList;
import net.minecraft.world.item.ItemStack;

public final class PowerUtils {
    private PowerUtils() {
    }

    public static long computeProductWithCap(Iterable<Integer> multipliers, int maxCards) {
        long product = 1L;
        int considered = 0;
        int highest = 1;
        for (Integer m : multipliers) {
            if (m == null) continue;
            if (considered >= maxCards) break;
            int mult = m;
            if (mult <= 0) {
                mult = 1;
            }
            product *= (long)mult;
            highest = Math.max(highest, mult);
            ++considered;
        }
        long cap = PowerUtils.capForHighestMultiplier(highest);
        return Math.min(product, cap);
    }

    public static long capForHighestMultiplier(int highestMultiplier) {
        if (highestMultiplier >= 16) {
            return 1024L;
        }
        if (highestMultiplier >= 8) {
            return 256L;
        }
        if (highestMultiplier >= 4) {
            return 64L;
        }
        if (highestMultiplier >= 2) {
            return 8L;
        }
        return 1L;
    }

    public static long computeProductWithCapFromMenu(UpgradeableMenu<?> menu, int maxCards) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int considered = 0;
        block0: for (ItemStack stack : menu.getUpgrades()) {
            if (considered >= maxCards) break;
            if (stack == null || stack.m_41619_() || !(stack.m_41720_() instanceof EntitySpeedCardItem)) continue;
            int multVal = EntitySpeedCardItem.readMultiplier(stack);
            int count = Math.min(stack.m_41613_(), maxCards - considered);
            for (int i = 0; i < count; ++i) {
                list.add(multVal);
                if (++considered >= maxCards) continue block0;
            }
        }
        return PowerUtils.computeProductWithCap(list, maxCards);
    }

    public static long computeProductWithCapFromStacks(Iterable<ItemStack> stacks, int maxCards) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int considered = 0;
        block0: for (ItemStack stack : stacks) {
            if (considered >= maxCards) break;
            if (stack == null || stack.m_41619_() || !(stack.m_41720_() instanceof EntitySpeedCardItem)) continue;
            int multVal = EntitySpeedCardItem.readMultiplier(stack);
            int count = Math.min(stack.m_41613_(), maxCards - considered);
            for (int i = 0; i < count; ++i) {
                list.add(multVal);
                if (++considered >= maxCards) continue block0;
            }
        }
        return PowerUtils.computeProductWithCap(list, maxCards);
    }

    public static double computeFinalPowerForProduct(long product, int energyCardCount) {
        if (product <= 1L) {
            return 0.0;
        }
        double base = ModConfig.INSTANCE.entityTickerCost;
        double log2 = Math.log(product) / Math.log(2.0);
        double raw = product == 2L ? base * 4.0 : (product <= 256L ? base * Math.pow(2.0, 1.5 * log2) * 2.0 : base * Math.pow(2.0, 2.5 * log2));
        double reduction = PowerUtils.getReductionPercent(energyCardCount);
        return raw * (1.0 - reduction) / 8.0;
    }

    public static double getGrowthFactor(int speedCardCount) {
        if (speedCardCount <= 0) {
            return 1.0;
        }
        if (speedCardCount == 1) {
            return 2.0;
        }
        if (speedCardCount <= 6) {
            return Math.pow(2.0, 2.0 * (double)speedCardCount);
        }
        return Math.pow(2.0, 3.0 * (double)speedCardCount);
    }

    public static double getRawPower(int speedCardCount) {
        double base = ModConfig.INSTANCE.entityTickerCost;
        return base * PowerUtils.getGrowthFactor(speedCardCount);
    }

    public static double getReductionPercent(int energyCardCount) {
        if (energyCardCount <= 0) {
            return 0.0;
        }
        if (energyCardCount == 1) {
            return 0.1;
        }
        if (energyCardCount >= 8) {
            return 0.5;
        }
        return 0.5 * (1.0 - Math.pow(0.7, energyCardCount));
    }

    public static double getFinalPower(int speedCardCount, int energyCardCount) {
        double raw = PowerUtils.getRawPower(speedCardCount);
        double reduction = PowerUtils.getReductionPercent(energyCardCount);
        return raw * (1.0 - reduction) / 4.0;
    }

    public static double getRemainingRatio(int energyCardCount) {
        return 1.0 - PowerUtils.getReductionPercent(energyCardCount);
    }

    public static String formatPercentage(double ratio) {
        double pct = ratio * 100.0;
        if (Math.abs(pct - (double)Math.round(pct)) < 1.0E-9) {
            return String.format("%d%%", Math.round(pct));
        }
        return String.format("%.2f%%", pct);
    }
}

