/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.wireless;

import com.extendedae_plus.config.ModConfig;
import com.extendedae_plus.wireless.IWirelessEndpoint;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public final class WirelessMasterRegistry {
    private static final Map<Key, WeakReference<IWirelessEndpoint>> MASTERS = new HashMap<Key, WeakReference<IWirelessEndpoint>>();

    private WirelessMasterRegistry() {
    }

    public static synchronized boolean register(ServerLevel level, long frequency, IWirelessEndpoint endpoint) {
        IWirelessEndpoint existingVal;
        Objects.requireNonNull(level, "level");
        Objects.requireNonNull(endpoint, "endpoint");
        if (frequency == 0L) {
            return false;
        }
        Key key = new Key((ResourceKey<Level>)(WirelessMasterRegistry.useGlobal() ? null : level.m_46472_()), frequency);
        WirelessMasterRegistry.cleanupIfCleared(key);
        WeakReference<IWirelessEndpoint> existing = MASTERS.get(key);
        IWirelessEndpoint iWirelessEndpoint = existingVal = existing == null ? null : (IWirelessEndpoint)existing.get();
        if (existingVal != null && !existingVal.isEndpointRemoved()) {
            return false;
        }
        MASTERS.put(key, new WeakReference<IWirelessEndpoint>(endpoint));
        return true;
    }

    public static synchronized void unregister(ServerLevel level, long frequency, IWirelessEndpoint endpoint) {
        IWirelessEndpoint cur;
        if (frequency == 0L || level == null) {
            return;
        }
        Key key = new Key((ResourceKey<Level>)(WirelessMasterRegistry.useGlobal() ? null : level.m_46472_()), frequency);
        WeakReference<IWirelessEndpoint> ref = MASTERS.get(key);
        if (ref != null && ((cur = (IWirelessEndpoint)ref.get()) == null || cur == endpoint)) {
            MASTERS.remove(key);
        }
    }

    public static synchronized IWirelessEndpoint get(ServerLevel level, long frequency) {
        if (frequency == 0L || level == null) {
            return null;
        }
        Key key = new Key((ResourceKey<Level>)(WirelessMasterRegistry.useGlobal() ? null : level.m_46472_()), frequency);
        WirelessMasterRegistry.cleanupIfCleared(key);
        WeakReference<IWirelessEndpoint> ref = MASTERS.get(key);
        return ref == null ? null : (IWirelessEndpoint)ref.get();
    }

    private static void cleanupIfCleared(Key key) {
        WeakReference<IWirelessEndpoint> ref = MASTERS.get(key);
        if (ref != null && ref.get() == null) {
            MASTERS.remove(key);
        }
    }

    private static boolean useGlobal() {
        return ModConfig.INSTANCE.wirelessCrossDimEnable;
    }

    private record Key(ResourceKey<Level> dim, long freq) {
        @Override
        public String toString() {
            return (this.dim == null ? "*" : this.dim.m_135782_().toString()) + "#" + this.freq;
        }
    }
}

