/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus;

import appeng.api.parts.IPart;
import appeng.api.parts.PartModels;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.ICellHandler;
import appeng.block.AEBaseEntityBlock;
import appeng.blockentity.crafting.CraftingBlockEntity;
import appeng.items.parts.PartModelsHelper;
import appeng.menu.locator.MenuLocators;
import com.extendedae_plus.api.ids.EAPComponents;
import com.extendedae_plus.api.storage.InfinityBigIntegerCellHandler;
import com.extendedae_plus.config.ModConfigs;
import com.extendedae_plus.content.matrix.CrafterCorePlusBlock;
import com.extendedae_plus.content.matrix.CrafterCorePlusBlockEntity;
import com.extendedae_plus.content.matrix.PatternCorePlusBlock;
import com.extendedae_plus.content.matrix.PatternCorePlusBlockEntity;
import com.extendedae_plus.content.matrix.SpeedCorePlusBlock;
import com.extendedae_plus.content.matrix.SpeedCorePlusBlockEntity;
import com.extendedae_plus.content.matrix.UploadCoreBlock;
import com.extendedae_plus.content.matrix.UploadCoreBlockEntity;
import com.extendedae_plus.init.ModBlockEntities;
import com.extendedae_plus.init.ModBlocks;
import com.extendedae_plus.init.ModCapabilities;
import com.extendedae_plus.init.ModCreativeTabs;
import com.extendedae_plus.init.ModItems;
import com.extendedae_plus.init.ModMenuTypes;
import com.extendedae_plus.init.ModNetwork;
import com.extendedae_plus.init.UpgradeCards;
import com.extendedae_plus.items.EntitySpeedTickerPartItem;
import com.extendedae_plus.menu.locator.CuriosItemLocator;
import com.extendedae_plus.util.storage.InfinityStorageManager;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Mod(value="extendedae_plus")
public class ExtendedAEPlus {
    public static final String MODID = "extendedae_plus";
    public static final Logger LOGGER = LogUtils.getLogger();
    @Nullable
    private static InfinityStorageManager storageManager;
    @Nullable
    private static MinecraftServer storageManagerServer;

    public ExtendedAEPlus(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(ModNetwork::registerPayloadHandlers);
        modEventBus.addListener(ModCapabilities::onRegisterCapabilities);
        ModBlocks.BLOCKS.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        ModBlockEntities.BLOCK_ENTITY_TYPES.register(modEventBus);
        ModCreativeTabs.TABS.register(modEventBus);
        ModMenuTypes.MENUS.register(modEventBus);
        EAPComponents.DR.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        NeoForge.EVENT_BUS.addListener(ExtendedAEPlus::onServerStarted);
        NeoForge.EVENT_BUS.addListener(ExtendedAEPlus::onServerStopped);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ModConfigs.COMMON_SPEC, "extendedae_plus-common.toml");
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ModConfigs.CLIENT_SPEC, "extendedae_plus-client.toml");
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ModConfigs.SERVER_SPEC, "extendedae_plus-server.toml");
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    private static void onServerStarted(ServerStartedEvent event) {
        storageManagerServer = event.getServer();
        storageManager = InfinityStorageManager.getInstance(event.getServer());
    }

    private static void onServerStopped(ServerStoppedEvent event) {
        if (storageManagerServer == event.getServer()) {
            storageManagerServer = null;
            storageManager = null;
        }
    }

    @Nullable
    public static InfinityStorageManager currentStorageManager() {
        return storageManager;
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM COMMON SETUP");
        LOGGER.info("DIRT BLOCK >> {}", (Object)BuiltInRegistries.BLOCK.getKey((Object)Blocks.DIRT));
        StorageCells.addCellHandler((ICellHandler)InfinityBigIntegerCellHandler.INSTANCE);
        event.enqueueWork(() -> {
            try {
                new UpgradeCards(event);
                PartModels.registerModels((Collection)PartModelsHelper.createModels(((EntitySpeedTickerPartItem)((Object)((Object)ModItems.ENTITY_TICKER_PART_ITEM.get()))).getPartClass().asSubclass(IPart.class)));
                try {
                    MenuLocators.register(CuriosItemLocator.class, CuriosItemLocator::writeToPacket, CuriosItemLocator::readFromPacket);
                    LOGGER.info("Registered AE2 MenuLocator: CuriosItemLocator");
                }
                catch (Throwable t) {
                    LOGGER.warn("Failed to register CuriosItemLocator with AE2 MenuLocators: {}", (Object)t.toString());
                }
                AEBaseEntityBlock b4 = (AEBaseEntityBlock)ModBlocks.ACCELERATOR_4x.get();
                AEBaseEntityBlock b16 = (AEBaseEntityBlock)ModBlocks.ACCELERATOR_16x.get();
                AEBaseEntityBlock b64 = (AEBaseEntityBlock)ModBlocks.ACCELERATOR_64x.get();
                AEBaseEntityBlock b256 = (AEBaseEntityBlock)ModBlocks.ACCELERATOR_256x.get();
                AEBaseEntityBlock b1024 = (AEBaseEntityBlock)ModBlocks.ACCELERATOR_1024x.get();
                BlockEntityType type = (BlockEntityType)ModBlockEntities.EPLUS_CRAFTING_UNIT_BE.get();
                b4.setBlockEntity(CraftingBlockEntity.class, type, null, null);
                b16.setBlockEntity(CraftingBlockEntity.class, type, null, null);
                b64.setBlockEntity(CraftingBlockEntity.class, type, null, null);
                b256.setBlockEntity(CraftingBlockEntity.class, type, null, null);
                b1024.setBlockEntity(CraftingBlockEntity.class, type, null, null);
                LOGGER.info("Bound AE2 CraftingBlockEntity to ExtendedAE Plus accelerators.");
                ((UploadCoreBlock)((Object)((Object)ModBlocks.ASSEMBLER_MATRIX_UPLOAD_CORE.get()))).setBlockEntity(UploadCoreBlockEntity.class, (BlockEntityType)ModBlockEntities.UPLOAD_CORE_BE.get(), null, null);
                ((SpeedCorePlusBlock)((Object)((Object)ModBlocks.ASSEMBLER_MATRIX_SPEED_PLUS.get()))).setBlockEntity(SpeedCorePlusBlockEntity.class, (BlockEntityType)ModBlockEntities.ASSEMBLER_MATRIX_SPEED_PLUS_BE.get(), null, null);
                ((CrafterCorePlusBlock)((Object)((Object)ModBlocks.ASSEMBLER_MATRIX_CRAFTER_PLUS.get()))).setBlockEntity(CrafterCorePlusBlockEntity.class, (BlockEntityType)ModBlockEntities.ASSEMBLER_MATRIX_CRAFTER_PLUS_BE.get(), null, null);
                ((PatternCorePlusBlock)((Object)((Object)ModBlocks.ASSEMBLER_MATRIX_PATTERN_PLUS.get()))).setBlockEntity(PatternCorePlusBlockEntity.class, (BlockEntityType)ModBlockEntities.ASSEMBLER_MATRIX_PATTERN_PLUS_BE.get(), null, null);
                LOGGER.info("Bound UploadCoreBlockEntity to assembler matrix upload core block.");
            }
            catch (Throwable t) {
                LOGGER.warn("Failed to bind block entities: {}", (Object)t.toString());
            }
        });
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }
}

