/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.ae.wireless;

import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNode;
import appeng.me.service.helpers.ConnectionWrapper;
import com.extendedae_plus.ae.wireless.IWirelessEndpoint;
import com.extendedae_plus.ae.wireless.WirelessMasterRegistry;
import com.extendedae_plus.config.ModConfigs;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import org.jetbrains.annotations.Nullable;

public class WirelessSlaveLink {
    private final IWirelessEndpoint host;
    private long frequency;
    @Nullable
    private UUID placerId;
    private ConnectionWrapper connection = new ConnectionWrapper(null);
    private boolean shutdown = true;
    private double distance;

    public WirelessSlaveLink(IWirelessEndpoint host) {
        this.host = Objects.requireNonNull(host);
    }

    public void setPlacerId(@Nullable UUID placerId) {
        this.placerId = placerId;
    }

    public long getFrequency() {
        return this.frequency;
    }

    public void setFrequency(long frequency) {
        if (this.frequency != frequency) {
            this.frequency = frequency;
            this.updateStatus();
        }
    }

    public boolean isConnected() {
        return !this.shutdown && this.connection.getConnection() != null;
    }

    public double getDistance() {
        return this.distance;
    }

    public void updateStatus() {
        if (this.host.isEndpointRemoved()) {
            this.destroyConnection();
            return;
        }
        ServerLevel level = this.host.getServerLevel();
        if (level == null || this.frequency == 0L) {
            this.destroyConnection();
            return;
        }
        IWirelessEndpoint master = WirelessMasterRegistry.get(level, this.frequency, this.placerId);
        this.shutdown = false;
        this.distance = 0.0;
        boolean crossDim = (Boolean)ModConfigs.WIRELESS_CROSS_DIM_ENABLE.get();
        if (master != null && !master.isEndpointRemoved() && (crossDim || master.getServerLevel() == level)) {
            if (!crossDim) {
                this.distance = Math.sqrt(master.getBlockPos().distSqr((Vec3i)this.host.getBlockPos()));
            }
            double maxRange = (Double)ModConfigs.WIRELESS_MAX_RANGE.get();
            if (crossDim || this.distance <= maxRange) {
                try {
                    IGridConnection current = this.connection.getConnection();
                    IGridNode a = this.host.getGridNode();
                    IGridNode b = master.getGridNode();
                    if (a != null && b != null) {
                        IGridConnection existing;
                        if (current != null) {
                            IGridNode ca = current.a();
                            IGridNode cb = current.b();
                            if (!(ca != a && cb != a || ca != b && cb != b)) {
                                return;
                            }
                            current.destroy();
                            this.connection = new ConnectionWrapper(null);
                        }
                        if ((existing = this.findExistingConnection(a, b)) != null) {
                            this.connection = new ConnectionWrapper(existing);
                            return;
                        }
                        this.connection = new ConnectionWrapper(GridHelper.createConnection((IGridNode)a, (IGridNode)b));
                        return;
                    }
                    this.shutdown = true;
                }
                catch (IllegalStateException illegalStateException) {}
            } else {
                this.shutdown = true;
            }
        } else {
            this.shutdown = true;
        }
        this.destroyConnection();
    }

    public void onUnloadOrRemove() {
        this.destroyConnection();
    }

    private void destroyConnection() {
        block16: {
            IGridConnection current = this.connection.getConnection();
            if (current != null) {
                IGridNode a = current.a();
                IGridNode b = current.b();
                current.destroy();
                try {
                    if (a != null && a.getGrid() != null) {
                        a.getGrid().getTickManager().wakeDevice(a);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    if (b != null && b.getGrid() != null) {
                        b.getGrid().getTickManager().wakeDevice(b);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.connection.setConnection(null);
            } else {
                try {
                    IGridNode a = this.host.getGridNode();
                    if (a == null) break block16;
                    for (IGridConnection gc : a.getConnections()) {
                        IGridNode other;
                        Object owner;
                        if (gc == null || gc.isInWorld() || !((owner = (other = gc.getOtherSide(a)) != null ? other.getOwner() : null) instanceof IWirelessEndpoint)) continue;
                        gc.destroy();
                        try {
                            if (a.getGrid() != null) {
                                a.getGrid().getTickManager().wakeDevice(a);
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        try {
                            if (other == null || other.getGrid() == null) continue;
                            other.getGrid().getTickManager().wakeDevice(other);
                        }
                        catch (Throwable throwable) {}
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        this.connection = new ConnectionWrapper(null);
    }

    private IGridConnection findExistingConnection(IGridNode a, IGridNode b) {
        try {
            for (IGridConnection gc : a.getConnections()) {
                IGridNode ga = gc.a();
                IGridNode gb = gc.b();
                if (ga != a && gb != a || ga != b && gb != b) continue;
                return gc;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }
}

