/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.api.crafting;

import appeng.api.crafting.IPatternDetails;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.crafting.pattern.AEProcessingPattern;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScaledProcessingPattern
implements IPatternDetails {
    @NotNull
    protected final IPatternDetails original;
    protected final long multiplier;

    public ScaledProcessingPattern(@NotNull IPatternDetails original, long multiplier) {
        if (multiplier <= 0L) {
            throw new IllegalArgumentException("multiplier must be > 0");
        }
        this.original = original;
        this.multiplier = multiplier;
    }

    @NotNull
    public IPatternDetails getOriginal() {
        return this.original;
    }

    public AEItemKey getDefinition() {
        return this.original.getDefinition();
    }

    public IPatternDetails.IInput[] getInputs() {
        IPatternDetails.IInput[] original = this.original.getInputs();
        IPatternDetails.IInput[] scaled = new IPatternDetails.IInput[original.length];
        for (int i = 0; i < original.length; ++i) {
            scaled[i] = new ScaledInput(original[i], this.multiplier);
        }
        return scaled;
    }

    public List<GenericStack> getOutputs() {
        List original = this.original.getOutputs();
        ArrayList<GenericStack> scaled = new ArrayList<GenericStack>(original.size());
        for (GenericStack g : original) {
            if (g == null) continue;
            scaled.add(new GenericStack(g.what(), g.amount() * this.multiplier));
        }
        return scaled;
    }

    public void pushInputsToExternalInventory(KeyCounter[] inputHolder, IPatternDetails.PatternInputSink sink) {
        if (((AEProcessingPattern)this.original).getSparseInputs().size() == this.original.getInputs().length) {
            super.pushInputsToExternalInventory(inputHolder, sink);
            return;
        }
        KeyCounter allInputs = new KeyCounter();
        for (KeyCounter ctr : inputHolder) {
            allInputs.addAll(ctr);
        }
        List<GenericStack> sparse = this.getSparseInputs();
        for (GenericStack sparseInput : sparse) {
            if (sparseInput == null) continue;
            AEKey key = sparseInput.what();
            long amount = sparseInput.amount();
            long available = allInputs.get(key);
            if (available < amount) {
                throw new IllegalStateException("Expected " + amount + " of " + String.valueOf(key) + " but only " + available + " available");
            }
            sink.pushInput(key, amount);
            allInputs.remove(key, amount);
        }
    }

    protected List<GenericStack> getSparseInputs() {
        List original = ((AEProcessingPattern)this.original).getSparseInputs();
        ArrayList<GenericStack> scaled = new ArrayList<GenericStack>(original.size());
        for (GenericStack g : original) {
            if (g != null) {
                scaled.add(new GenericStack(g.what(), g.amount() * this.multiplier));
                continue;
            }
            scaled.add(null);
        }
        return scaled;
    }

    public List<GenericStack> getSparseOutputs() {
        List original = ((AEProcessingPattern)this.original).getSparseOutputs();
        ArrayList<GenericStack> scaled = new ArrayList<GenericStack>(original.size());
        for (GenericStack g : original) {
            if (g != null) {
                scaled.add(new GenericStack(g.what(), g.amount() * this.multiplier));
                continue;
            }
            scaled.add(null);
        }
        return scaled;
    }

    public int hashCode() {
        int h = this.original.hashCode();
        h = 31 * h + Long.hashCode(this.multiplier);
        return h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ScaledProcessingPattern)) {
            return false;
        }
        ScaledProcessingPattern sp = (ScaledProcessingPattern)obj;
        return sp.original.equals((Object)this.original) && sp.multiplier == this.multiplier;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Scaled[Mult=").append(this.multiplier).append("] ");
        sb.append("Inputs: [");
        sb.append(String.join((CharSequence)", ", (CharSequence[])Arrays.stream(this.original.getInputs()).filter(i -> i.getPossibleInputs() != null && i.getPossibleInputs().length > 0).map(i -> {
            GenericStack stack = i.getPossibleInputs()[0];
            return String.valueOf(stack.what()) + "\u00d7" + i.getMultiplier();
        }).toArray(String[]::new)));
        sb.append("] ");
        sb.append("Outputs: [");
        sb.append(String.join((CharSequence)", ", (CharSequence[])this.original.getOutputs().stream().filter(Objects::nonNull).map(s -> String.valueOf(s.what()) + "\u00d7" + s.amount()).toArray(String[]::new)));
        sb.append("]");
        return sb.toString();
    }

    private record ScaledInput(IPatternDetails.IInput original, long multiplier) implements IPatternDetails.IInput
    {
        public GenericStack[] getPossibleInputs() {
            return this.original.getPossibleInputs();
        }

        public long getMultiplier() {
            return this.original.getMultiplier() * this.multiplier;
        }

        public boolean isValid(AEKey input, Level level) {
            return this.original.isValid(input, level);
        }

        @Nullable
        public AEKey getRemainingKey(AEKey template) {
            return this.original.getRemainingKey(template);
        }
    }
}

