/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.api.crafting;

import appeng.api.crafting.IPatternDetails;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import com.extendedae_plus.api.crafting.ScaledProcessingPattern;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.core.Direction;
import net.pedroksl.advanced_ae.common.patterns.AdvProcessingPattern;
import net.pedroksl.advanced_ae.common.patterns.IAdvPatternDetails;
import org.jetbrains.annotations.NotNull;

public final class ScaledProcessingPatternAdv
extends ScaledProcessingPattern
implements IPatternDetails,
IAdvPatternDetails {
    private final LinkedHashMap<AEKey, Direction> dirMap;

    public ScaledProcessingPatternAdv(@NotNull IPatternDetails original, long multiplier) {
        super(original, multiplier);
        this.dirMap = ((AdvProcessingPattern)original).getDirectionMap();
    }

    @Override
    public void pushInputsToExternalInventory(KeyCounter[] inputHolder, IPatternDetails.PatternInputSink sink) {
        if (((AdvProcessingPattern)this.original).getSparseInputs().size() == this.original.getInputs().length) {
            this.original.pushInputsToExternalInventory(inputHolder, sink);
            return;
        }
        KeyCounter allInputs = new KeyCounter();
        for (KeyCounter counter : inputHolder) {
            allInputs.addAll(counter);
        }
        for (GenericStack sparseInput : this.getSparseInputs()) {
            if (sparseInput == null) continue;
            AEKey key = sparseInput.what();
            long amount = sparseInput.amount();
            long available = allInputs.get(key);
            if (available < amount) {
                throw new IllegalStateException("Expected " + amount + " of " + String.valueOf(key) + " but only " + available + " available");
            }
            sink.pushInput(key, amount);
            allInputs.remove(key, amount);
        }
    }

    @Override
    protected List<GenericStack> getSparseInputs() {
        List original = ((AdvProcessingPattern)this.original).getSparseInputs();
        ArrayList<GenericStack> scaled = new ArrayList<GenericStack>(original.size());
        for (GenericStack g : original) {
            if (g != null) {
                scaled.add(new GenericStack(g.what(), g.amount() * this.multiplier));
                continue;
            }
            scaled.add(null);
        }
        return scaled;
    }

    @Override
    public List<GenericStack> getSparseOutputs() {
        List original = ((AdvProcessingPattern)this.original).getSparseOutputs();
        ArrayList<GenericStack> scaled = new ArrayList<GenericStack>(original.size());
        for (GenericStack g : original) {
            if (g != null) {
                scaled.add(new GenericStack(g.what(), g.amount() * this.multiplier));
                continue;
            }
            scaled.add(null);
        }
        return scaled;
    }

    public boolean directionalInputsSet() {
        return this.dirMap != null && !this.dirMap.isEmpty();
    }

    public LinkedHashMap<AEKey, Direction> getDirectionMap() {
        return this.dirMap;
    }

    public Direction getDirectionSideForInputKey(AEKey key) {
        return this.dirMap.get(key);
    }
}

