/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.client;

import appeng.api.stacks.GenericStack;
import appeng.client.gui.me.common.MEStorageScreen;
import com.extendedae_plus.mixin.ae2.accessor.MEStorageScreenAccessor;
import com.extendedae_plus.mixin.extendedae.accessor.GuiExPatternTerminalAccessor;
import com.extendedae_plus.network.OpenCraftFromJeiC2SPacket;
import com.extendedae_plus.network.PullFromJeiOrCraftC2SPacket;
import com.glodblock.github.extendedae.client.gui.GuiExPatternTerminal;
import java.lang.reflect.Method;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InputEvents {
    private static final Logger log = LoggerFactory.getLogger(InputEvents.class);

    private InputEvents() {
    }

    private static Optional<?> getIngredientUnderMouse() {
        try {
            Class<?> cls = Class.forName("com.extendedae_plus.integration.jei.JeiRuntimeProxy");
            Method m = cls.getMethod("getIngredientUnderMouse", new Class[0]);
            Object r = m.invoke(null, new Object[0]);
            return (Optional)r;
        }
        catch (Throwable ignored) {
            return Optional.empty();
        }
    }

    private static Optional<?> getIngredientUnderMouse(double mouseX, double mouseY) {
        try {
            Class<?> cls = Class.forName("com.extendedae_plus.integration.jei.JeiRuntimeProxy");
            Method m = cls.getMethod("getIngredientUnderMouse", Double.TYPE, Double.TYPE);
            Object r = m.invoke(null, mouseX, mouseY);
            return (Optional)r;
        }
        catch (Throwable ignored) {
            return Optional.empty();
        }
    }

    private static boolean isJeiCheatModeEnabled() {
        try {
            Boolean b;
            Class<?> cls = Class.forName("com.extendedae_plus.integration.jei.JeiRuntimeProxy");
            Method m = cls.getMethod("isJeiCheatModeEnabled", new Class[0]);
            Object r = m.invoke(null, new Object[0]);
            return r instanceof Boolean && (b = (Boolean)r) != false;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    private static String getTypedIngredientDisplayName(Object typed) {
        try {
            String s;
            Class<?> cls = Class.forName("com.extendedae_plus.integration.jei.JeiRuntimeProxy");
            Method m = cls.getMethod("getTypedIngredientDisplayName", Object.class);
            Object r = m.invoke(null, typed);
            return r instanceof String ? (s = (String)r) : "";
        }
        catch (Throwable ignored) {
            return "";
        }
    }

    private static GenericStack toGenericStack(Object typed) {
        try {
            Object val;
            Optional opt;
            Method getItemStack = typed.getClass().getMethod("getItemStack", new Class[0]);
            Object maybe = getItemStack.invoke(typed, new Object[0]);
            if (maybe instanceof Optional && (opt = (Optional)maybe).isPresent() && (val = opt.get()) instanceof ItemStack) {
                ItemStack is = (ItemStack)val;
                try {
                    return GenericStack.fromItemStack((ItemStack)is);
                }
                catch (Throwable ignored) {
                    return null;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    @SubscribeEvent
    public static void onMouseButtonPre(ScreenEvent.MouseButtonPressed.Pre event) {
        GenericStack stack;
        Object typed;
        Optional<?> hovered;
        double mouseY;
        double mouseX;
        if (event.getButton() == 0 && Screen.hasShiftDown()) {
            mouseX = event.getMouseX();
            hovered = InputEvents.getIngredientUnderMouse(mouseX, mouseY = event.getMouseY());
            if (hovered.isEmpty()) {
                hovered = InputEvents.getIngredientUnderMouse();
            }
            if (hovered.isPresent()) {
                if (InputEvents.isJeiCheatModeEnabled()) {
                    return;
                }
                typed = hovered.get();
                stack = InputEvents.toGenericStack(typed);
                if (stack != null) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new PullFromJeiOrCraftC2SPacket(stack), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    event.setCanceled(true);
                    return;
                }
            }
        }
        if (event.getButton() == 2) {
            mouseX = event.getMouseX();
            hovered = InputEvents.getIngredientUnderMouse(mouseX, mouseY = event.getMouseY());
            if (hovered.isEmpty()) {
                hovered = InputEvents.getIngredientUnderMouse();
            }
            if (hovered.isEmpty()) {
                return;
            }
            if (InputEvents.isJeiCheatModeEnabled()) {
                return;
            }
            typed = hovered.get();
            stack = InputEvents.toGenericStack(typed);
            if (stack == null) {
                return;
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new OpenCraftFromJeiC2SPacket(stack), (CustomPacketPayload[])new CustomPacketPayload[0]);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onKeyPressedPre(ScreenEvent.KeyPressed.Pre event) {
        if (event.getKeyCode() != 70) {
            return;
        }
        Screen screen = Minecraft.getInstance().screen;
        if (!(screen instanceof MEStorageScreen) && !(screen instanceof GuiExPatternTerminal)) {
            return;
        }
        Optional<?> hovered = InputEvents.getIngredientUnderMouse();
        if (hovered.isEmpty()) {
            return;
        }
        Object typed = hovered.get();
        String name = InputEvents.getTypedIngredientDisplayName(typed);
        if (name == null || name.isEmpty()) {
            return;
        }
        if (screen instanceof MEStorageScreen) {
            MEStorageScreen me = (MEStorageScreen)screen;
            try {
                MEStorageScreenAccessor acc = (MEStorageScreenAccessor)me;
                acc.eap$getSearchField().setValue(name);
                acc.eap$setSearchText(name);
                event.setCanceled(true);
                return;
            }
            catch (Throwable acc) {}
        } else if (screen instanceof GuiExPatternTerminal) {
            GuiExPatternTerminal gpt = (GuiExPatternTerminal)screen;
            try {
                GuiExPatternTerminalAccessor acc = (GuiExPatternTerminalAccessor)gpt;
                acc.getSearchField().setValue(name);
                event.setCanceled(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

