/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.config;

import java.util.List;
import net.neoforged.neoforge.common.ModConfigSpec;

public final class ModConfigs {
    public static final ModConfigSpec COMMON_SPEC;
    public static final ModConfigSpec.IntValue PAGE_MULTIPLIER;
    public static final ModConfigSpec CLIENT_SPEC;
    public static final ModConfigSpec.BooleanValue SHOW_ENCODER_PATTERN_PLAYER;
    public static final ModConfigSpec.BooleanValue PATTERN_TERMINAL_SHOW_SLOTS_DEFAULT;
    public static final ModConfigSpec.BooleanValue PRIORITIZE_DISK_ENERGY;
    public static final ModConfigSpec SERVER_SPEC;
    public static final ModConfigSpec.BooleanValue PROVIDER_ROUND_ROBIN_ENABLE;
    public static final ModConfigSpec.IntValue SMART_SCALING_MAX_MULTIPLIER;
    public static final ModConfigSpec.IntValue CRAFTING_PAUSE_THRESHOLD;
    public static final ModConfigSpec.DoubleValue WIRELESS_MAX_RANGE;
    public static final ModConfigSpec.BooleanValue WIRELESS_CROSS_DIM_ENABLE;
    public static final ModConfigSpec.IntValue ENTITY_TICKER_COST;
    public static final ModConfigSpec.ConfigValue<List<? extends String>> ENTITY_TICKER_BLACK_LIST;
    public static final ModConfigSpec.ConfigValue<List<? extends String>> ENTITY_TICKER_MULTIPLIERS;

    private ModConfigs() {
    }

    static {
        ModConfigSpec.Builder commonBuilder = new ModConfigSpec.Builder();
        commonBuilder.push("common");
        PAGE_MULTIPLIER = commonBuilder.comment(new String[]{"\u6269\u5c55\u6837\u677f\u4f9b\u5e94\u5668\u603b\u69fd\u4f4d\u5bb9\u91cf\u7684\u500d\u7387", "\u57fa\u7840\u4e3a36\uff0c\u6bcf\u9875\u4ecd\u663e\u793a36\u683c\uff0c\u500d\u7387\u4f1a\u589e\u52a0\u603b\u9875\u6570/\u603b\u5bb9\u91cf", "\u5efa\u8bae\u8303\u56f4 1-16"}).defineInRange("pageMultiplier", 1, 1, 64);
        commonBuilder.pop();
        COMMON_SPEC = commonBuilder.build();
        ModConfigSpec.Builder clientBuilder = new ModConfigSpec.Builder();
        clientBuilder.push("client");
        SHOW_ENCODER_PATTERN_PLAYER = clientBuilder.comment(new String[]{"\u662f\u5426\u663e\u793a\u6837\u677f\u7f16\u7801\u73a9\u5bb6", "\u5f00\u542f\u540e\u5c06\u5728\u6837\u677f HoverText \u4e0a\u6dfb\u52a0\u6837\u677f\u7684\u7f16\u7801\u73a9\u5bb6"}).define("showEncoderPatternPlayer", true);
        PATTERN_TERMINAL_SHOW_SLOTS_DEFAULT = clientBuilder.comment(new String[]{"\u6837\u677f\u7ec8\u7aef\u9ed8\u8ba4\u662f\u5426\u663e\u793a\u69fd\u4f4d", "\u5f71\u54cd\u8fdb\u5165\u754c\u9762\u65f6SlotsRow\u7684\u9ed8\u8ba4\u53ef\u89c1\u6027\uff0c\u4ec5\u5f71\u54cd\u5ba2\u6237\u7aef\u663e\u793a"}).define("patternTerminalShowSlotsDefault", true);
        clientBuilder.pop();
        CLIENT_SPEC = clientBuilder.build();
        ModConfigSpec.Builder serverBuilder = new ModConfigSpec.Builder();
        serverBuilder.push("ae");
        PROVIDER_ROUND_ROBIN_ENABLE = serverBuilder.comment(new String[]{"\u667a\u80fd\u500d\u589e\u65f6\u662f\u5426\u5bf9\u6837\u677f\u4f9b\u5e94\u5668\u8f6e\u8be2\u5206\u914d", "\u4ec5\u591a\u4e2a\u4f9b\u5e94\u5668\u6709\u76f8\u540c\u6837\u677f\u65f6\u751f\u6548\uff0c\u5f00\u542f\u540e\u8bf7\u6c42\u4f1a\u5747\u5206\u5230\u6240\u6709\u53ef\u7528\u4f9b\u5e94\u5668\uff0c\u5173\u95ed\u5219\u5168\u90e8\u5206\u914d\u7ed9\u5355\u4e00\u4f9b\u5e94\u5668", "\u6ce8\u610f\uff1a\u6240\u6709\u76f8\u5173\u4f9b\u5e94\u5668\u9700\u5f00\u542f\u667a\u80fd\u500d\u589e\uff0c\u5426\u5219\u53ef\u80fd\u5931\u6548", "\u9ed8\u8ba4: true"}).define("providerRoundRobinEnable", true);
        SMART_SCALING_MAX_MULTIPLIER = serverBuilder.comment(new String[]{"\u667a\u80fd\u500d\u589e\u7684\u6700\u5927\u500d\u6570\uff080 \u8868\u793a\u4e0d\u9650\u5236\uff09", "\u6b64\u500d\u6570\u662f\u9488\u5bf9\u5355\u6b21\u6837\u677f\u4ea7\u51fa\u7684\u653e\u5927\u500d\u6570\u4e0a\u9650\uff0c\u7528\u4e8e\u9650\u5236\u4e00\u6b21\u63a8\u9001\u4e2d\u6309\u500d\u589e\u7f29\u653e\u7684\u89c4\u6a21"}).defineInRange("smartScalingMaxMultiplier", 0, 0, 0x100000);
        CRAFTING_PAUSE_THRESHOLD = serverBuilder.comment("\u503c\u8d8a\u5927\u5c06\u51cf\u5c11AE\u6784\u5efa\u5408\u6210\u8ba1\u5212\u8fc7\u7a0b\u4e2d\u7684 wait/notify \u6b21\u6570\uff0c\u63d0\u5347\u541e\u5410\u4f46\u4f1a\u964d\u4f4e\u8c03\u5ea6\u54cd\u5e94\u6027").defineInRange("craftingPauseThreshold", 100000, 100, Integer.MAX_VALUE);
        serverBuilder.pop();
        serverBuilder.push("wireless");
        WIRELESS_MAX_RANGE = serverBuilder.comment(new String[]{"\u65e0\u7ebf\u6536\u53d1\u5668\u6700\u5927\u8fde\u63a5\u8ddd\u79bb\uff08\u5355\u4f4d\uff1a\u65b9\u5757\uff09", "\u4ece\u7aef\u4e0e\u4e3b\u7aef\u7684\u76f4\u7ebf\u8ddd\u79bb\u9700\u5c0f\u4e8e\u7b49\u4e8e\u8be5\u503c\u624d\u4f1a\u5efa\u7acb\u8fde\u63a5\u3002"}).defineInRange("wirelessMaxRange", 256.0, 1.0, 4096.0);
        WIRELESS_CROSS_DIM_ENABLE = serverBuilder.comment(new String[]{"\u662f\u5426\u5141\u8bb8\u65e0\u7ebf\u6536\u53d1\u5668\u8de8\u7ef4\u5ea6\u5efa\u7acb\u8fde\u63a5", "\u5f00\u542f\u540e\uff0c\u4ece\u7aef\u53ef\u8fde\u63a5\u5230\u4e0d\u540c\u7ef4\u5ea6\u7684\u4e3b\u7aef\uff08\u5ffd\u7565\u8ddd\u79bb\u9650\u5236\uff09"}).define("wirelessCrossDimEnable", true);
        serverBuilder.pop();
        serverBuilder.push("entitySpeedTicker");
        ENTITY_TICKER_COST = serverBuilder.comment("\u5b9e\u4f53\u52a0\u901f\u5668\u80fd\u91cf\u6d88\u8017\u57fa\u7840\u503c").defineInRange("entityTickerCost", 512, 0, Integer.MAX_VALUE);
        ENTITY_TICKER_BLACK_LIST = serverBuilder.comment(new String[]{"\u5b9e\u4f53\u52a0\u901f\u5668\u9ed1\u540d\u5355\uff1a\u5339\u914d\u7684\u65b9\u5757\u5c06\u4e0d\u4f1a\u88ab\u52a0\u901f\u3002\u652f\u6301\u901a\u914d\u7b26/\u6b63\u5219\uff08\u4f8b\u5982\uff1aminecraft:*\uff09", "\u683c\u5f0f\uff1a\u5168\u540d\u6216\u901a\u914d\u7b26/\u6b63\u5219\u5b57\u7b26\u4e32\uff0c\u4f8b\u5982 'minecraft:chest'\u3001'minecraft:*'\u3001'modid:.*_fluid'"}).defineListAllowEmpty(List.of("entityTickerBlackList"), List::of, () -> "", obj -> obj instanceof String);
        ENTITY_TICKER_MULTIPLIERS = serverBuilder.comment(new String[]{"\u989d\u5916\u6d88\u8017\u500d\u7387\u914d\u7f6e\uff1a\u4e3a\u67d0\u4e9b\u65b9\u5757\u8bbe\u7f6e\u989d\u5916\u80fd\u91cf\u500d\u7387\uff0c\u683c\u5f0f 'modid:blockid multiplier'\uff0c\u4f8b\u5982 'minecraft:chest 2x'", "\u652f\u6301\u901a\u914d\u7b26/\u6b63\u5219\u5339\u914d\uff08\u4f8b\u5982 'minecraft:* 2x' \u4f1a\u5bf9\u6574\u4e2a\u547d\u540d\u7a7a\u95f4\u751f\u6548\uff09\u3002"}).defineListAllowEmpty(List.of("entityTickerMultipliers"), List::of, () -> "", obj -> obj instanceof String);
        PRIORITIZE_DISK_ENERGY = serverBuilder.comment(new String[]{"\u662f\u5426\u4f18\u5148\u4ece\u78c1\u76d8\u63d0\u53d6FE\u80fd\u91cf\uff08\u4ec5\u5f53Applied Flux\u6a21\u7ec4\u5b58\u5728\u65f6\u751f\u6548\uff09", "\u5f00\u542f\u540e\uff0c\u5c06\u4f18\u5148\u5c1d\u8bd5\u4ece\u78c1\u76d8\u63d0\u53d6FE\u80fd\u91cf\uff1b\u53cd\u4e4b\u4f18\u5148\u6d88\u8017AE\u7f51\u7edc\u4e2d\u7684\u80fd\u91cf"}).define("prioritizeDiskEnergy", true);
        serverBuilder.pop();
        SERVER_SPEC = serverBuilder.build();
    }
}

