/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.content.matrix;

import appeng.api.crafting.IPatternDetails;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.CombinedInternalInventory;
import com.extendedae_plus.init.ModBlockEntities;
import com.glodblock.github.extendedae.common.me.CraftingMatrixThread;
import com.glodblock.github.extendedae.common.me.CraftingThread;
import com.glodblock.github.extendedae.common.me.matrix.ClusterAssemblerMatrix;
import com.glodblock.github.extendedae.common.tileentities.matrix.TileAssemblerMatrixCrafter;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class CrafterCorePlusBlockEntity
extends TileAssemblerMatrixCrafter {
    public static final int MAX_THREAD = 32;
    private final CraftingThread[] plusThreads = new CraftingThread[32];
    private final InternalInventory plusInternalInv;
    private int plusStates = 0;

    public CrafterCorePlusBlockEntity(BlockPos pos, BlockState blockState) {
        super(pos, blockState);
        InternalInventory[] inventories = new InternalInventory[32];
        int x = 0;
        while (x < 32) {
            int index = x++;
            this.plusThreads[index] = new CraftingMatrixThread((AEBaseBlockEntity)this, this::getSrc, signal -> this.changeState(index, signal));
            inventories[index] = this.plusThreads[index].getInternalInventory();
        }
        this.plusInternalInv = new CombinedInternalInventory(inventories);
    }

    @NotNull
    public BlockEntityType<?> getType() {
        return (BlockEntityType)ModBlockEntities.ASSEMBLER_MATRIX_CRAFTER_PLUS_BE.get();
    }

    private IActionSource getSrc() {
        return this.cluster == null ? null : this.cluster.getSrc();
    }

    private void changeState(int index, boolean state) {
        boolean oldState;
        boolean bl = oldState = this.plusStates > 0;
        this.plusStates = state ? (this.plusStates |= 1 << index) : (this.plusStates &= ~(1 << index));
        if (state) {
            if (!oldState) {
                this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice(node));
            }
        } else if (oldState && this.plusStates <= 0) {
            this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().sleepDevice(node));
        }
    }

    public int usedThread() {
        int cnt = 0;
        for (CraftingThread t : this.plusThreads) {
            if (t.getCurrentPattern() != null) {
                ++cnt;
                continue;
            }
            if (t.getInternalInventory().isEmpty()) continue;
            ++cnt;
        }
        double scale = 0.25;
        int reported = (int)Math.ceil((double)cnt * scale);
        return Math.min(8, reported);
    }

    public boolean pushJob(IPatternDetails patternDetails, KeyCounter[] inputHolder) {
        for (CraftingThread thread : this.plusThreads) {
            if (!thread.acceptJob(patternDetails, inputHolder, Direction.DOWN)) continue;
            if (this.cluster != null) {
                this.cluster.updateCrafter((TileAssemblerMatrixCrafter)this);
            }
            return true;
        }
        return false;
    }

    public void stop() {
        for (CraftingThread thread : this.plusThreads) {
            thread.stop();
        }
    }

    public void saveAdditional(CompoundTag data, HolderLookup.Provider registries) {
        super.saveAdditional(data, registries);
        for (int x = 0; x < 32; ++x) {
            CompoundTag tag = this.plusThreads[x].writeNBT(registries);
            data.put("#ct" + x, (Tag)tag);
        }
        CompoundTag opt = new CompoundTag();
        for (int x = 0; x < this.plusInternalInv.size(); ++x) {
            ItemStack is = this.plusInternalInv.getStackInSlot(x);
            opt.put("item" + x, is.saveOptional(registries));
        }
        data.put("inv", (Tag)opt);
    }

    public void loadTag(CompoundTag data, HolderLookup.Provider registries) {
        super.loadTag(data, registries);
        for (int x = 0; x < 32; ++x) {
            if (!data.contains("#ct" + x)) continue;
            this.plusThreads[x].readNBT(data.getCompound("#ct" + x), registries);
        }
        CompoundTag opt = data.getCompound("inv");
        for (int x = 0; x < this.plusInternalInv.size(); ++x) {
            CompoundTag item = opt.getCompound("item" + x);
            this.plusInternalInv.setItemDirect(x, ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)item));
        }
    }

    public void add(ClusterAssemblerMatrix cluster) {
        cluster.addCrafter((TileAssemblerMatrixCrafter)this);
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        boolean isAwake = false;
        for (CraftingThread t : this.plusThreads) {
            t.recalculatePlan();
            t.updateSleepiness();
            isAwake |= t.isAwake();
        }
        return new TickingRequest(1, 1, !isAwake);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.cluster == null) {
            return TickRateModulation.SLEEP;
        }
        TickRateModulation rate = TickRateModulation.SLEEP;
        for (CraftingThread t : this.plusThreads) {
            TickRateModulation tr;
            if (!t.isAwake() || (tr = t.tick(this.cluster.getSpeedCore(), ticksSinceLastCall)).ordinal() <= rate.ordinal()) continue;
            rate = tr;
        }
        this.cluster.updateCrafter((TileAssemblerMatrixCrafter)this);
        return rate;
    }

    public void saveChangedInventory(AppEngInternalInventory inv) {
        for (CraftingThread t : this.plusThreads) {
            if (inv != t.getInternalInventory()) continue;
            t.recalculatePlan();
            break;
        }
        this.saveChanges();
    }

    public void onChangeInventory(AppEngInternalInventory inv, int slot) {
        this.saveChangedInventory(inv);
    }

    public void addAdditionalDrops(Level level, BlockPos pos, List<ItemStack> drops) {
        super.addAdditionalDrops(level, pos, drops);
        for (ItemStack stack : this.plusInternalInv) {
            GenericStack genericStack = GenericStack.unwrapItemStack((ItemStack)stack);
            if (genericStack != null) {
                genericStack.what().addDrops(genericStack.amount(), drops, level, pos);
                continue;
            }
            drops.add(stack);
        }
    }

    public void clearContent() {
        super.clearContent();
        this.plusInternalInv.clear();
    }
}

