/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.content.wireless;

import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.IManagedGridNode;
import appeng.api.util.AECableType;
import appeng.blockentity.AEBaseBlockEntity;
import com.extendedae_plus.ae.wireless.IWirelessEndpoint;
import com.extendedae_plus.ae.wireless.WirelessMasterLink;
import com.extendedae_plus.ae.wireless.WirelessSlaveLink;
import com.extendedae_plus.content.wireless.WirelessTransceiverBlock;
import com.extendedae_plus.init.ModBlockEntities;
import com.extendedae_plus.init.ModItems;
import java.util.EnumSet;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class WirelessTransceiverBlockEntity
extends AEBaseBlockEntity
implements IWirelessEndpoint,
IInWorldGridNodeHost {
    private IManagedGridNode managedNode = GridHelper.createManagedNode((Object)this, (IGridNodeListener)NodeListener.INSTANCE).setFlags(new GridFlags[]{GridFlags.DENSE_CAPACITY});
    private long frequency = 1L;
    private boolean masterMode = false;
    private boolean locked = false;
    @Nullable
    private UUID placerId;
    @Nullable
    private String placerName;
    private WirelessMasterLink masterLink;
    private WirelessSlaveLink slaveLink;

    public WirelessTransceiverBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.WIRELESS_TRANSCEIVER_BE.get(), pos, state);
        this.managedNode.setIdlePowerUsage(1.0);
        this.managedNode.setTagName("wireless_node");
        this.managedNode.setInWorldNode(true);
        this.managedNode.setExposedOnSides(EnumSet.allOf(Direction.class));
        this.managedNode.setVisualRepresentation(((Item)ModItems.WIRELESS_TRANSCEIVER.get()).getDefaultInstance());
        this.masterLink = new WirelessMasterLink(this);
        this.slaveLink = new WirelessSlaveLink(this);
    }

    static void serverTick(Level level, BlockPos pos, BlockState state, WirelessTransceiverBlockEntity be) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        if (!be.masterMode) {
            be.slaveLink.updateStatus();
        }
        be.updateStates();
    }

    public void updateStates() {
        BlockState currentState;
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        IGridNode node = this.getGridNode();
        int states = 5;
        if (node != null && node.isActive()) {
            int usedCount = 0;
            for (IGridConnection connection : node.getConnections()) {
                usedCount = Math.max(usedCount, connection.getUsedChannels());
            }
            if (usedCount >= 32) {
                states = 4;
            } else if (usedCount >= 24) {
                states = 3;
            } else if (usedCount >= 16) {
                states = 2;
            } else if (usedCount >= 8) {
                states = 1;
            } else if (usedCount >= 0) {
                states = 0;
            }
        }
        if ((Integer)(currentState = this.getBlockState()).getValue((Property)WirelessTransceiverBlock.STATE) != states) {
            this.level.setBlock(this.worldPosition, (BlockState)currentState.setValue((Property)WirelessTransceiverBlock.STATE, (Comparable)Integer.valueOf(states)), 3);
        }
    }

    @Nullable
    public IGridNode getGridNode(Direction dir) {
        return this.getGridNode();
    }

    public AECableType getCableConnectionType(Direction dir) {
        AECableType t;
        if (this.level == null) {
            return AECableType.GLASS;
        }
        BlockPos adjacentPos = this.worldPosition.relative(dir);
        if (!Objects.requireNonNull(this.getLevel()).hasChunkAt(adjacentPos)) {
            return AECableType.GLASS;
        }
        IInWorldGridNodeHost adjacentHost = GridHelper.getNodeHost((Level)this.getLevel(), (BlockPos)adjacentPos);
        if (adjacentHost != null && (t = adjacentHost.getCableConnectionType(dir.getOpposite())) != null) {
            return t;
        }
        return AECableType.GLASS;
    }

    @Override
    public ServerLevel getServerLevel() {
        ServerLevel sl;
        Level lvl = super.getLevel();
        return lvl instanceof ServerLevel ? (sl = (ServerLevel)lvl) : null;
    }

    @Override
    public IGridNode getGridNode() {
        return this.managedNode == null ? null : this.managedNode.getNode();
    }

    @Override
    public boolean isEndpointRemoved() {
        return super.isRemoved();
    }

    @Override
    public BlockPos getBlockPos() {
        return this.worldPosition;
    }

    void setPlacerId(@Nullable UUID placerId, @Nullable String placerName) {
        if (this.placerId != null && !this.placerId.equals(placerId)) {
            if (this.masterMode) {
                this.masterLink.onUnloadOrRemove();
            } else {
                this.slaveLink.onUnloadOrRemove();
            }
        }
        this.placerId = placerId;
        this.placerName = placerName;
        this.masterLink.setPlacerId(placerId);
        this.slaveLink.setPlacerId(placerId);
        this.setChanged();
    }

    @Nullable
    public UUID getPlacerId() {
        return this.placerId;
    }

    public void setPlacerId(@Nullable UUID placerId) {
        this.setPlacerId(placerId, null);
    }

    @Nullable
    public String getPlacerName() {
        return this.placerName;
    }

    public long getFrequency() {
        return this.frequency;
    }

    public void setFrequency(long frequency) {
        if (this.locked) {
            return;
        }
        if (this.frequency == frequency) {
            return;
        }
        this.frequency = frequency;
        if (this.isMasterMode()) {
            this.masterLink.setFrequency(frequency);
        } else {
            this.slaveLink.setFrequency(frequency);
        }
        this.setChanged();
    }

    public void setFrequencyForced(long frequency) {
        if (this.frequency == frequency) {
            return;
        }
        this.frequency = frequency;
        if (this.isMasterMode()) {
            this.masterLink.setFrequency(frequency);
        } else {
            this.slaveLink.setFrequency(frequency);
        }
        this.setChanged();
    }

    public boolean isMasterMode() {
        return this.masterMode;
    }

    void setMasterMode(boolean masterMode) {
        if (this.locked) {
            return;
        }
        if (this.masterMode == masterMode) {
            return;
        }
        if (this.masterMode) {
            this.masterLink.onUnloadOrRemove();
        } else {
            this.slaveLink.onUnloadOrRemove();
        }
        this.masterMode = masterMode;
        if (this.masterMode) {
            this.masterLink.setFrequency(this.frequency);
        } else {
            this.slaveLink.setFrequency(this.frequency);
        }
        this.setChanged();
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        if (this.locked == locked) {
            return;
        }
        this.locked = locked;
        this.setChanged();
    }

    void onRemoved() {
        if (this.masterMode) {
            this.masterLink.onUnloadOrRemove();
        } else {
            this.slaveLink.onUnloadOrRemove();
        }
        if (this.managedNode != null) {
            this.managedNode.destroy();
        }
    }

    public void onLoad() {
        super.onLoad();
        ServerLevel sl = this.getServerLevel();
        if (sl == null) {
            return;
        }
        GridHelper.onFirstTick((BlockEntity)this, be -> {
            be.managedNode.create(be.getLevel(), be.getBlockPos());
            if (be.masterMode) {
                be.masterLink.setFrequency(be.frequency);
            } else {
                be.slaveLink.setFrequency(be.frequency);
            }
        });
    }

    public void loadTag(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadTag(tag, registries);
        this.frequency = tag.getLong("frequency");
        this.masterMode = tag.getBoolean("master");
        this.locked = tag.getBoolean("locked");
        if (tag.hasUUID("placerId")) {
            this.placerId = tag.getUUID("placerId");
            this.masterLink.setPlacerId(this.placerId);
            this.slaveLink.setPlacerId(this.placerId);
        }
        if (tag.contains("placerName")) {
            this.placerName = tag.getString("placerName");
        }
        if (this.managedNode != null) {
            this.managedNode.loadFromNBT(tag);
        }
        if (this.masterMode) {
            this.masterLink.setFrequency(this.frequency);
        } else {
            this.slaveLink.setFrequency(this.frequency);
        }
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putLong("frequency", this.frequency);
        tag.putBoolean("master", this.masterMode);
        tag.putBoolean("locked", this.locked);
        if (this.placerId != null) {
            tag.putUUID("placerId", this.placerId);
        }
        if (this.placerName != null) {
            tag.putString("placerName", this.placerName);
        }
        if (this.managedNode != null) {
            this.managedNode.saveToNBT(tag);
        }
    }

    static enum NodeListener implements IGridNodeListener<WirelessTransceiverBlockEntity>
    {
        INSTANCE;


        public void onSaveChanges(WirelessTransceiverBlockEntity host, IGridNode node) {
            host.setChanged();
        }

        public void onInWorldConnectionChanged(WirelessTransceiverBlockEntity host, IGridNode node) {
        }

        public void onOwnerChanged(WirelessTransceiverBlockEntity host, IGridNode node) {
        }

        public void onGridChanged(WirelessTransceiverBlockEntity host, IGridNode node) {
        }

        public void onStateChanged(WirelessTransceiverBlockEntity host, IGridNode node, IGridNodeListener.State state) {
        }
    }
}

