/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.hooks;

import appeng.block.crafting.CraftingUnitBlock;
import appeng.util.InteractionUtil;
import com.extendedae_plus.ExtendedAEPlus;
import com.extendedae_plus.client.screen.FrequencyInputScreen;
import com.extendedae_plus.content.wireless.WirelessTransceiverBlockEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="extendedae_plus")
public final class WrenchHook {
    private WrenchHook() {
    }

    @SubscribeEvent
    public static void onPlayerUseBlockEvent(PlayerInteractEvent.RightClickBlock event) {
        BlockEntity be;
        if (event.isCanceled()) {
            return;
        }
        Player player = event.getEntity();
        Level level = event.getLevel();
        InteractionHand hand = event.getHand();
        BlockHitResult hit = event.getHitVec();
        if (player.isSpectator() || hand != InteractionHand.MAIN_HAND) {
            return;
        }
        ItemStack stack = player.getItemInHand(hand);
        if (InteractionUtil.isInAlternateUseMode((Player)player) && InteractionUtil.canWrenchDisassemble((ItemStack)stack)) {
            BlockEntity be2 = level.getBlockEntity(hit.getBlockPos());
            if (be2 instanceof WirelessTransceiverBlockEntity) {
                WirelessTransceiverBlockEntity te = (WirelessTransceiverBlockEntity)be2;
                BlockPos pos = hit.getBlockPos();
                BlockState state = level.getBlockState(pos);
                Block block = state.getBlock();
                if (!level.isClientSide) {
                    List drops = Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)pos, (BlockEntity)te, (Entity)player, (ItemStack)stack);
                    for (ItemStack item : drops) {
                        player.getInventory().placeItemBackInInventory(item);
                    }
                }
                level.playSound(player, hit.getBlockPos(), SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.BLOCKS, 0.7f, 1.0f);
                block.playerWillDestroy(level, hit.getBlockPos(), state, player);
                level.removeBlock(hit.getBlockPos(), false);
                block.destroy((LevelAccessor)level, hit.getBlockPos(), state);
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide));
            } else {
                BlockPos pos = hit.getBlockPos();
                BlockState state = level.getBlockState(pos);
                if (state.getBlock() instanceof CraftingUnitBlock) {
                    if (!level.isClientSide) {
                        List drops = Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)pos, (BlockEntity)level.getBlockEntity(pos), (Entity)player, (ItemStack)stack);
                        for (ItemStack item : drops) {
                            player.getInventory().placeItemBackInInventory(item);
                        }
                    }
                    level.playSound(player, hit.getBlockPos(), SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.BLOCKS, 0.7f, 1.0f);
                    state.getBlock().playerWillDestroy(level, pos, state, player);
                    level.removeBlock(pos, false);
                    state.getBlock().destroy((LevelAccessor)level, pos, state);
                    event.setCanceled(true);
                    event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide));
                }
            }
        } else if (!InteractionUtil.isInAlternateUseMode((Player)player) && InteractionUtil.canWrenchRotate((ItemStack)stack) && (be = level.getBlockEntity(hit.getBlockPos())) instanceof WirelessTransceiverBlockEntity) {
            WirelessTransceiverBlockEntity te = (WirelessTransceiverBlockEntity)be;
            if (!level.isClientSide) {
                boolean newLocked = !te.isLocked();
                te.setLocked(newLocked);
                BlockPos pos = hit.getBlockPos();
                BlockState state = level.getBlockState(pos);
                try {
                    level.sendBlockUpdated(pos, state, state, 3);
                }
                catch (Throwable t) {
                    ExtendedAEPlus.LOGGER.debug("sendBlockUpdated failed: {}", (Object)t.toString());
                }
                player.displayClientMessage((Component)Component.translatable((String)(newLocked ? "extendedae_plus.wireless.locked" : "extendedae_plus.wireless.unlocked")), true);
                level.playSound(player, hit.getBlockPos(), SoundEvents.LEVER_CLICK, SoundSource.BLOCKS, 0.5f, newLocked ? 0.6f : 0.9f);
                ExtendedAEPlus.LOGGER.debug("Wrench toggle lock at {} -> {}", (Object)pos, (Object)newLocked);
            } else {
                ExtendedAEPlus.LOGGER.debug("Client received wrench toggle intent (no-op on client)");
            }
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide));
        }
    }

    @SubscribeEvent
    public static void onPlayerLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        BlockEntity be;
        if (event.isCanceled()) {
            return;
        }
        Player player = event.getEntity();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        if (player.isSpectator()) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        if (InteractionUtil.isInAlternateUseMode((Player)player) && InteractionUtil.canWrenchRotate((ItemStack)stack) && (be = level.getBlockEntity(pos)) instanceof WirelessTransceiverBlockEntity) {
            WirelessTransceiverBlockEntity te = (WirelessTransceiverBlockEntity)be;
            if (level.isClientSide) {
                FrequencyInputScreen.open(pos, te.getFrequency());
                ExtendedAEPlus.LOGGER.debug("Opening frequency input GUI for transceiver at {}", (Object)pos);
            }
            event.setCanceled(true);
        }
    }
}

