/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.integration.jade;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNode;
import appeng.api.networking.pathing.ChannelMode;
import appeng.me.GridNode;
import com.extendedae_plus.ae.wireless.IWirelessEndpoint;
import com.extendedae_plus.ae.wireless.WirelessMasterRegistry;
import com.extendedae_plus.content.wireless.WirelessTransceiverBlockEntity;
import com.extendedae_plus.util.wireless.WirelessTeamUtil;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IServerDataProvider;

public enum WirelessTransceiverProvider implements IServerDataProvider<BlockAccessor>
{
    INSTANCE;

    private static final ResourceLocation UID;

    public ResourceLocation getUid() {
        return UID;
    }

    public void appendServerData(CompoundTag data, BlockAccessor accessor) {
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof WirelessTransceiverBlockEntity) {
            long freq;
            ServerLevel level;
            IWirelessEndpoint master;
            IGridNode node;
            WirelessTransceiverBlockEntity blockEntity2 = (WirelessTransceiverBlockEntity)blockEntity;
            data.putLong("frequency", blockEntity2.getFrequency());
            data.putBoolean("masterMode", blockEntity2.isMasterMode());
            data.putBoolean("locked", blockEntity2.isLocked());
            UUID placerId = blockEntity2.getPlacerId();
            if (placerId != null) {
                data.putUUID("placerId", placerId);
                ServerLevel level2 = blockEntity2.getServerLevel();
                if (level2 != null) {
                    Component ownerName = WirelessTeamUtil.getNetworkOwnerName(level2, placerId);
                    data.putString("ownerName", ownerName.getString());
                }
            }
            IGrid grid = (node = blockEntity2.getGridNode()) == null ? null : node.getGrid();
            boolean networkUsable = false;
            if (grid != null) {
                try {
                    networkUsable = grid.getEnergyService().isNetworkPowered();
                }
                catch (Throwable ignored) {
                    networkUsable = false;
                }
            }
            data.putBoolean("networkUsable", networkUsable);
            int usedChannels = 0;
            int maxChannels = 0;
            if (node != null && node.isActive()) {
                for (IGridConnection connection : node.getConnections()) {
                    usedChannels = Math.max(connection.getUsedChannels(), usedChannels);
                }
                if (node instanceof GridNode) {
                    GridNode gridNode = (GridNode)node;
                    ChannelMode channelMode = gridNode.getGrid().getPathingService().getChannelMode();
                    maxChannels = channelMode == ChannelMode.INFINITE ? -1 : gridNode.getMaxChannels();
                }
            }
            data.putInt("usedChannels", usedChannels);
            data.putInt("maxChannels", maxChannels);
            if (!blockEntity2.isMasterMode() && (master = WirelessMasterRegistry.get(level = blockEntity2.getServerLevel(), freq = blockEntity2.getFrequency(), blockEntity2.getPlacerId())) != null && !master.isEndpointRemoved()) {
                BlockPos pos;
                WirelessTransceiverBlockEntity masterBlockEntity;
                if (master instanceof WirelessTransceiverBlockEntity && (masterBlockEntity = (WirelessTransceiverBlockEntity)master).getCustomName() != null) {
                    data.putString("customName", masterBlockEntity.getCustomName().getString());
                }
                if ((pos = master.getBlockPos()) != null) {
                    data.putLong("masterPos", pos.asLong());
                }
                if (master.getServerLevel() != null) {
                    data.putString("masterDim", master.getServerLevel().dimension().location().toString());
                }
            }
        }
    }

    static {
        UID = ResourceLocation.fromNamespaceAndPath((String)"extendedae_plus", (String)"wireless_transceiver_info");
    }
}

