/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.integration.jei;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.fluids.FluidStack;

public final class JeiRuntimeProxy {
    private static volatile Object RUNTIME;

    private JeiRuntimeProxy() {
    }

    static void setRuntime(Object runtime) {
        RUNTIME = runtime;
    }

    private static Class<?> eap$getIngredientTypeClass() throws ClassNotFoundException {
        return Class.forName("mezz.jei.api.ingredients.IIngredientType");
    }

    @Nullable
    public static Object get() {
        return RUNTIME;
    }

    public static Optional<?> getIngredientUnderMouse() {
        Object rt = RUNTIME;
        if (rt == null) {
            return Optional.empty();
        }
        try {
            Optional o;
            Method m;
            Object opt;
            Optional o2;
            Method m2;
            Object opt2;
            Method getIngredientListOverlay = rt.getClass().getMethod("getIngredientListOverlay", new Class[0]);
            Object list = getIngredientListOverlay.invoke(rt, new Object[0]);
            if (list != null && (opt2 = (m2 = list.getClass().getMethod("getIngredientUnderMouse", new Class[0])).invoke(list, new Object[0])) instanceof Optional && (o2 = (Optional)opt2).isPresent()) {
                return o2;
            }
            Method getBookmarkOverlay = rt.getClass().getMethod("getBookmarkOverlay", new Class[0]);
            Object bm = getBookmarkOverlay.invoke(rt, new Object[0]);
            if (bm != null && (opt = (m = bm.getClass().getMethod("getIngredientUnderMouse", new Class[0])).invoke(bm, new Object[0])) instanceof Optional && (o = (Optional)opt).isPresent()) {
                return o;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Optional.empty();
    }

    public static Optional<?> getIngredientUnderMouse(double mouseX, double mouseY) {
        Object rt = RUNTIME;
        if (rt == null) {
            return Optional.empty();
        }
        try {
            Optional o;
            Optional value;
            Class<?> ingredientTypeClass = JeiRuntimeProxy.eap$getIngredientTypeClass();
            Method getRecipesGui = rt.getClass().getMethod("getRecipesGui", new Class[0]);
            Object gui = getRecipesGui.invoke(rt, new Object[0]);
            if (gui == null) {
                return Optional.empty();
            }
            Object ingredientManager = rt.getClass().getMethod("getIngredientManager", new Class[0]).invoke(rt, new Object[0]);
            Class<?> vanillaTypes = Class.forName("mezz.jei.api.constants.VanillaTypes");
            Object itemType = vanillaTypes.getField("ITEM_STACK").get(null);
            Method getUnder = gui.getClass().getMethod("getIngredientUnderMouse", ingredientTypeClass);
            Object valueOpt = getUnder.invoke(gui, itemType);
            if (!(valueOpt instanceof Optional) || (value = (Optional)valueOpt).isEmpty()) {
                return Optional.empty();
            }
            Method createTyped = ingredientManager.getClass().getMethod("createTypedIngredient", ingredientTypeClass, Object.class);
            Object typedOpt = createTyped.invoke(ingredientManager, itemType, value.get());
            return typedOpt instanceof Optional ? (o = (Optional)typedOpt) : Optional.empty();
        }
        catch (Throwable throwable) {
            return Optional.empty();
        }
    }

    public static boolean isJeiCheatModeEnabled() {
        try {
            Boolean b;
            Class<?> internal = Class.forName("mezz.jei.common.Internal");
            Object toggle = internal.getMethod("getClientToggleState", new Class[0]).invoke(null, new Object[0]);
            Method isCheat = toggle.getClass().getMethod("isCheatItemsEnabled", new Class[0]);
            Object r = isCheat.invoke(toggle, new Object[0]);
            return r instanceof Boolean && (b = (Boolean)r) != false;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static String getTypedIngredientDisplayName(Object typed) {
        Object rt = RUNTIME;
        if (rt == null || typed == null) {
            return "";
        }
        try {
            Class<?> ingredientTypeClass = JeiRuntimeProxy.eap$getIngredientTypeClass();
            Object manager = rt.getClass().getMethod("getIngredientManager", new Class[0]).invoke(rt, new Object[0]);
            Method getType = typed.getClass().getMethod("getType", new Class[0]);
            Object type = getType.invoke(typed, new Object[0]);
            Method getHelper = manager.getClass().getMethod("getIngredientHelper", ingredientTypeClass);
            Object helper = getHelper.invoke(manager, type);
            Method getIngredient = typed.getClass().getMethod("getIngredient", new Class[0]);
            Object ingredient = getIngredient.invoke(typed, new Object[0]);
            Object display = helper.getClass().getMethod("getDisplayName", ingredient.getClass()).invoke(helper, ingredient);
            if (display == null) {
                return "";
            }
            try {
                Class<?> comp = Class.forName("net.minecraft.network.chat.Component");
                if (comp.isInstance(display)) {
                    Method getString = comp.getMethod("getString", new Class[0]);
                    Object s = getString.invoke(display, new Object[0]);
                    return s == null ? "" : s.toString();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return display.toString();
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    public static List<?> getBookmarkList() {
        Object rt = RUNTIME;
        if (rt == null) {
            return Collections.emptyList();
        }
        try {
            Object overlay = rt.getClass().getMethod("getBookmarkOverlay", new Class[0]).invoke(rt, new Object[0]);
            if (overlay == null) {
                return Collections.emptyList();
            }
            try {
                Field f = overlay.getClass().getDeclaredField("bookmarkList");
                f.setAccessible(true);
                Object list = f.get(overlay);
                Method getElements = list.getClass().getMethod("getElements", new Class[0]);
                Object elements = getElements.invoke(list, new Object[0]);
                if (elements instanceof List) {
                    List l = (List)elements;
                    try {
                        Method getTyped = Class.forName("mezz.jei.gui.overlay.elements.IElement").getMethod("getTypedIngredient", new Class[0]);
                        return l.stream().map(e -> {
                            try {
                                return getTyped.invoke(e, new Object[0]);
                            }
                            catch (Throwable ignored) {
                                return null;
                            }
                        }).filter(x -> x != null).toList();
                    }
                    catch (Throwable throwable) {
                    }
                }
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    public static void addBookmark(ItemStack stack) {
        Object rt = RUNTIME;
        if (rt == null || stack == null || stack.isEmpty()) {
            return;
        }
        try {
            Optional opt;
            Object overlay = rt.getClass().getMethod("getBookmarkOverlay", new Class[0]).invoke(rt, new Object[0]);
            if (overlay == null) {
                return;
            }
            Field f = overlay.getClass().getDeclaredField("bookmarkList");
            f.setAccessible(true);
            Object list = f.get(overlay);
            Class<?> ingredientTypeClass = JeiRuntimeProxy.eap$getIngredientTypeClass();
            Object manager = rt.getClass().getMethod("getIngredientManager", new Class[0]).invoke(rt, new Object[0]);
            Object itemType = Class.forName("mezz.jei.api.constants.VanillaTypes").getField("ITEM_STACK").get(null);
            Method createTyped = manager.getClass().getMethod("createTypedIngredient", ingredientTypeClass, Object.class);
            Object typedOpt = createTyped.invoke(manager, itemType, stack);
            if (typedOpt instanceof Optional && (opt = (Optional)typedOpt).isPresent()) {
                Object typed = opt.get();
                Class<?> ibCls = Class.forName("mezz.jei.gui.bookmarks.IngredientBookmark");
                Method create = null;
                for (Method m : ibCls.getMethods()) {
                    if (!m.getName().equals("create") || m.getParameterCount() != 2) continue;
                    create = m;
                    break;
                }
                if (create != null) {
                    Object bookmark = create.invoke(null, typed, manager);
                    list.getClass().getMethod("add", ibCls).invoke(list, bookmark);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void addBookmark(FluidStack fluidStack) {
        Object rt = RUNTIME;
        if (rt == null) {
            return;
        }
        try {
            Optional opt;
            Object overlay = rt.getClass().getMethod("getBookmarkOverlay", new Class[0]).invoke(rt, new Object[0]);
            if (overlay == null) {
                return;
            }
            Field f = overlay.getClass().getDeclaredField("bookmarkList");
            f.setAccessible(true);
            Object list = f.get(overlay);
            Class<?> ingredientTypeClass = JeiRuntimeProxy.eap$getIngredientTypeClass();
            Object manager = rt.getClass().getMethod("getIngredientManager", new Class[0]).invoke(rt, new Object[0]);
            Object fluidType = Class.forName("mezz.jei.api.neoforge.NeoForgeTypes").getField("FLUID_STACK").get(null);
            Method createTyped = manager.getClass().getMethod("createTypedIngredient", ingredientTypeClass, Object.class);
            Object typedOpt = createTyped.invoke(manager, fluidType, fluidStack);
            if (typedOpt instanceof Optional && (opt = (Optional)typedOpt).isPresent()) {
                Object typed = opt.get();
                Class<?> ibCls = Class.forName("mezz.jei.gui.bookmarks.IngredientBookmark");
                Method create = null;
                for (Method m : ibCls.getMethods()) {
                    if (!m.getName().equals("create") || m.getParameterCount() != 2) continue;
                    create = m;
                    break;
                }
                if (create != null) {
                    Object bookmark = create.invoke(null, typed, manager);
                    list.getClass().getMethod("add", ibCls).invoke(list, bookmark);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void addBookmark(Object chemicalStack) {
        if (!ModList.get().isLoaded("mekanism") && !ModList.get().isLoaded("appmek")) {
            return;
        }
        Object rt = RUNTIME;
        if (rt == null || chemicalStack == null) {
            return;
        }
        try {
            Optional opt;
            Object overlay = rt.getClass().getMethod("getBookmarkOverlay", new Class[0]).invoke(rt, new Object[0]);
            if (overlay == null) {
                return;
            }
            Field f = overlay.getClass().getDeclaredField("bookmarkList");
            f.setAccessible(true);
            Object list = f.get(overlay);
            Class<?> ingredientTypeClass = JeiRuntimeProxy.eap$getIngredientTypeClass();
            Object manager = rt.getClass().getMethod("getIngredientManager", new Class[0]).invoke(rt, new Object[0]);
            String mekanismJeiClass = "mekanism.client.recipe_viewer.jei.MekanismJEI";
            Class<?> jeiCls = Class.forName(mekanismJeiClass);
            Field typeField = null;
            if ("mekanism.api.chemical.ChemicalStack".equals(chemicalStack.getClass().getName())) {
                typeField = jeiCls.getField("TYPE_CHEMICAL");
            }
            if (typeField == null) {
                return;
            }
            Object typeConst = typeField.get(null);
            Method createTyped = manager.getClass().getMethod("createTypedIngredient", ingredientTypeClass, Object.class);
            Object typedOpt = createTyped.invoke(manager, typeConst, chemicalStack);
            if (typedOpt instanceof Optional && (opt = (Optional)typedOpt).isPresent()) {
                Object typed = opt.get();
                Class<?> ibCls = Class.forName("mezz.jei.gui.bookmarks.IngredientBookmark");
                Method create = null;
                for (Method m : ibCls.getMethods()) {
                    if (!m.getName().equals("create") || m.getParameterCount() != 2) continue;
                    create = m;
                    break;
                }
                if (create != null) {
                    Object bookmark = create.invoke(null, typed, manager);
                    list.getClass().getMethod("add", ibCls).invoke(list, bookmark);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void removeBookmark(ItemStack stack) {
        Object rt = RUNTIME;
        if (rt == null || stack == null || stack.isEmpty()) {
            return;
        }
        try {
            Optional opt;
            Object overlay = rt.getClass().getMethod("getBookmarkOverlay", new Class[0]).invoke(rt, new Object[0]);
            if (overlay == null) {
                return;
            }
            Field f = overlay.getClass().getDeclaredField("bookmarkList");
            f.setAccessible(true);
            Object list = f.get(overlay);
            Object manager = rt.getClass().getMethod("getIngredientManager", new Class[0]).invoke(rt, new Object[0]);
            Object itemType = Class.forName("mezz.jei.api.constants.VanillaTypes").getField("ITEM_STACK").get(null);
            Method createTyped = manager.getClass().getMethod("createTypedIngredient", itemType.getClass(), Object.class);
            Object typedOpt = createTyped.invoke(manager, itemType, stack);
            if (typedOpt instanceof Optional && (opt = (Optional)typedOpt).isPresent()) {
                Object typed = opt.get();
                Class<?> ibCls = Class.forName("mezz.jei.gui.bookmarks.IngredientBookmark");
                Method create = null;
                for (Method m : ibCls.getMethods()) {
                    if (!m.getName().equals("create") || m.getParameterCount() != 2) continue;
                    create = m;
                    break;
                }
                if (create != null) {
                    Object bookmark = create.invoke(null, typed, manager);
                    list.getClass().getMethod("remove", ibCls).invoke(list, bookmark);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

