/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.items;

import appeng.api.config.FuzzyMode;
import appeng.api.storage.cells.ICellWorkbenchItem;
import com.extendedae_plus.api.storage.InfinityBigIntegerCellInventory;
import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;

public class InfinityBigIntegerCellItem
extends Item
implements ICellWorkbenchItem {
    public InfinityBigIntegerCellItem() {
        super(new Item.Properties().stacksTo(1).fireResistant());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.extendedae_plus.infinity_biginteger_cell.summon1"));
        tooltip.add((Component)Component.translatable((String)"tooltip.extendedae_plus.infinity_biginteger_cell.summon2"));
        Preconditions.checkArgument((stack.getItem() == this ? 1 : 0) != 0);
        CustomData customData = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        if (!customData.isEmpty()) {
            CompoundTag tag = customData.copyTag();
            if (tag.contains("infinity_cell_uuid")) {
                String uuidStr = tag.getUUID("infinity_cell_uuid").toString();
                tooltip.add((Component)Component.literal((String)"UUID: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)uuidStr).withStyle(ChatFormatting.YELLOW)));
            }
            if (tag.contains("infinity_item_types")) {
                try {
                    int types = tag.getInt("infinity_item_types");
                    tooltip.add((Component)Component.literal((String)"Types: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.valueOf(types)).withStyle(ChatFormatting.GREEN)));
                }
                catch (Exception types) {
                    // empty catch block
                }
            }
            if (tag.contains("infinity_item_total")) {
                try {
                    bytes = tag.getByteArray("infinity_item_total");
                    BigInteger total = new BigInteger(bytes);
                    String formatted = InfinityBigIntegerCellInventory.formatBigInteger(total);
                    tooltip.add((Component)Component.literal((String)"Total: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)formatted).withStyle(ChatFormatting.AQUA)));
                }
                catch (Exception bytes) {}
            } else if (tag.contains("infinity_cell_item_count")) {
                try {
                    bytes = tag.getByteArray("infinity_cell_item_count");
                    BigInteger total = new BigInteger(bytes);
                    String formatted = InfinityBigIntegerCellInventory.formatBigInteger(total);
                    tooltip.add((Component)Component.literal((String)"Total: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)formatted).withStyle(ChatFormatting.AQUA)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public FuzzyMode getFuzzyMode(ItemStack itemStack) {
        return null;
    }

    public void setFuzzyMode(ItemStack itemStack, FuzzyMode fuzzyMode) {
    }
}

