/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.items.materials;

import appeng.items.materials.UpgradeCardItem;
import com.extendedae_plus.init.ModItems;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class EntitySpeedCardItem
extends UpgradeCardItem {
    private static final String NBT_MULTIPLIER = "EAS:mult";

    public EntitySpeedCardItem(Item.Properties props) {
        super(props);
    }

    public static ItemStack withMultiplier(byte multiplier) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.ENTITY_SPEED_CARD.get());
        CompoundTag tag = new CompoundTag();
        tag.putByte(NBT_MULTIPLIER, multiplier);
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        return stack;
    }

    public static byte readMultiplier(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return 1;
        }
        CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (customData == null || !customData.copyTag().contains(NBT_MULTIPLIER)) {
            return 1;
        }
        return customData.copyTag().getByte(NBT_MULTIPLIER);
    }

    @NotNull
    public Component getName(@NotNull ItemStack stack) {
        byte mult = EntitySpeedCardItem.readMultiplier(stack);
        return Component.translatable((String)(switch (mult) {
            case 2 -> "item.extendedae_plus.entity_speed_card.x2";
            case 4 -> "item.extendedae_plus.entity_speed_card.x4";
            case 8 -> "item.extendedae_plus.entity_speed_card.x8";
            case 16 -> "item.extendedae_plus.entity_speed_card.x16";
            default -> "item.extendedae_plus.entity_speed_card.x1";
        }));
    }

    private List<Component> getTooltipLines(ItemStack stack) {
        byte mult = EntitySpeedCardItem.readMultiplier(stack);
        int cap = 1;
        switch (mult) {
            case 16: {
                cap = 1024;
                break;
            }
            case 8: {
                cap = 256;
                break;
            }
            case 4: {
                cap = 64;
                break;
            }
            case 2: {
                cap = 8;
            }
        }
        MutableComponent line1 = Component.translatable((String)"tooltip.extendedae_plus.entity_speed_card.multiplier", (Object[])new Object[]{"x" + mult});
        MutableComponent line2 = Component.translatable((String)"tooltip.extendedae_plus.entity_speed_card.max", (Object[])new Object[]{cap});
        return List.of(line1, line2);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> lines, TooltipFlag advancedTooltips) {
        super.appendHoverText(stack, context, lines, advancedTooltips);
        lines.addAll(this.getTooltipLines(stack));
    }
}

