/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.mixin;

import java.util.List;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class ExtendedAEPlusMixinPlugin
implements IMixinConfigPlugin {
    private static boolean isClassPresent(String className) {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class.forName(className, false, cl);
            return true;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    private static boolean isJeiPresent() {
        return ExtendedAEPlusMixinPlugin.isClassPresent("mezz.jei.api.IModPlugin");
    }

    private static boolean isAdvancedAePresent() {
        return ExtendedAEPlusMixinPlugin.isClassPresent("net.pedroksl.advanced_ae.AdvancedAE");
    }

    private static boolean isUfoPresent() {
        return ExtendedAEPlusMixinPlugin.isClassPresent("com.raishxn.ufo.UfoMod");
    }

    private static boolean isBiggerAePresent() {
        return ExtendedAEPlusMixinPlugin.isClassPresent("cn.dancingsnow.bigger_ae2.BiggerAE2Mod");
    }

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (!ExtendedAEPlusMixinPlugin.isJeiPresent()) {
            if (mixinClassName.startsWith("com.extendedae_plus.mixin.jei")) {
                return false;
            }
            if (mixinClassName.equals("com.extendedae_plus.mixin.ae2.menu.CraftConfirmMenuGoBackMixin")) {
                return false;
            }
        }
        if (!ExtendedAEPlusMixinPlugin.isAdvancedAePresent() && mixinClassName.equals("com.extendedae_plus.mixin.advancedae.compat.PatternProviderLogicVirtualCompletionMixin")) {
            return false;
        }
        return !mixinClassName.equals("com.extendedae_plus.mixin.ae2.CraftingCPUClusterMixin") || !ExtendedAEPlusMixinPlugin.isUfoPresent() && !ExtendedAEPlusMixinPlugin.isBiggerAePresent();
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

